/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.Resp3Response;

public class SELECT
extends RespCommand
implements Resp3Command {
    public SELECT() {
        super(-1, 0, 0, 0);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        String db = new String(arguments.get(0), StandardCharsets.US_ASCII);
        try {
            Cache cache = handler.respServer().getCacheManager().getCache(db);
            ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ctx.channel());
            handler.setCache((AdvancedCache<byte[], byte[]>)cache.getAdvancedCache().withSubject(metadata.subject()).withMediaType(MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_OCTET_STREAM));
            metadata.cache(cache.getName());
            Resp3Response.ok(handler.allocator());
        }
        catch (CacheException e) {
            RespErrorUtil.customError("DB index is out of range", handler.allocator());
        }
        return handler.myStage();
    }
}

