/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.set;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.multimap.impl.EmbeddedSetCache;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.server.resp.serialization.Resp3Response;

public class SMOVE
extends RespCommand
implements Resp3Command {
    public SMOVE() {
        super(4, 1, 2, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] source = arguments.get(0);
        byte[] destination = arguments.get(1);
        byte[] element = arguments.get(2);
        boolean sameList = Arrays.equals(source, destination);
        EmbeddedSetCache<byte[], byte[]> esc = handler.getEmbeddedSetCache();
        if (!sameList) {
            Log.SERVER.smoveConsistencyMessage();
            return handler.stageToReturn(this.moveElement(esc, element, source, destination), ctx, Resp3Response.INTEGER);
        }
        return handler.stageToReturn(esc.get((Object)source).thenApply(bucket -> bucket.contains((Object)element) ? 1L : 0L), ctx, Resp3Response.INTEGER);
    }

    private CompletionStage<Long> moveElement(EmbeddedSetCache<byte[], byte[]> cache, byte[] element, byte[] srcKey, byte[] destKey) {
        return cache.exists((Object)destKey).thenCompose(ignore -> this.removeAndAdd(cache, element, srcKey, destKey));
    }

    private CompletionStage<Long> removeAndAdd(EmbeddedSetCache<byte[], byte[]> cache, byte[] element, byte[] srcKey, byte[] destKey) {
        return cache.remove((Object)srcKey, (Object)element).thenCompose(removed -> {
            if (removed == 0L) {
                return CompletableFuture.completedFuture(0L);
            }
            return cache.add((Object)destKey, (Object)element);
        });
    }
}

