/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.logging;

import java.nio.CharBuffer;
import org.infinispan.commons.CacheConfigurationException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final Log CONFIG = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.CONFIG");
    public static final Log SERVER = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.SERVER");

    @Message(value="Cannot enable authentication without an authenticator.", id=12002)
    public CacheConfigurationException authenticationWithoutAuthenticator();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Received an unexpected exception.", id=12003)
    public void unexpectedException(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="An error occurred when removing the listener for channel %s", id=12004)
    public void exceptionWhileRemovingListener(@Cause Throwable var1, CharBuffer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="There was an error adding listener for channel %s", id=12005)
    public void exceptionWhileRegisteringListener(@Cause Throwable var1, CharBuffer var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="LMOVE command can't guarantee atomicity and consistency when the source list and the destination list are different", id=12006)
    @Once
    public void lmoveConsistencyMessage();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="SMOVE command can't guarantee atomicity and consistency when the source list and the destination set are different", id=12008)
    @Once
    public void smoveConsistencyMessage();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="MSETNX command can't guarantee atomicity and consistency against concurrent set", id=12009)
    @Once
    public void msetnxConsistencyMessage();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="PESSIMISTIC locking is preferred instead of '%s'", id=13010)
    public void utilizePessimisticLocking(String var1);

    @Once
    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Multi-Exec operations without transactions have a relaxed isolation level. Consider enabling transaction.", id=13011)
    public void enableTransactionForMultiExec();
}

