/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespUtil;
import org.infinispan.server.resp.commands.Commands;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class COMMAND
extends RespCommand
implements Resp3Command {
    public static final String NAME = "COMMAND";
    private static final JavaObjectSerializer<Object> SERIALIZER = (ignore, writer) -> {
        List<RespCommand> commands = Commands.all();
        writer.arrayStart(commands.size());
        for (RespCommand command : commands) {
            writer.arrayNext();
            COMMAND.describeCommand(command, writer);
        }
        writer.arrayEnd();
    };

    public COMMAND() {
        super(NAME, -1, 0, 0, 0, AclCategory.SLOW.mask() | AclCategory.CONNECTION.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        ResponseWriter writer = handler.writer();
        if (arguments.isEmpty()) {
            writer.write(SERIALIZER);
        } else {
            String subcommand;
            switch (subcommand = RespUtil.ascii(arguments.get(0)).toUpperCase()) {
                case "COUNT": {
                    writer.integers(Commands.all().size());
                    break;
                }
                case "INFO": {
                    if (arguments.size() == 1) {
                        writer.write(SERIALIZER);
                        break;
                    }
                    writer.arrayStart(arguments.size() - 1);
                    for (int i = 1; i < arguments.size(); ++i) {
                        RespCommand command = RespCommand.fromString(RespUtil.ascii(arguments.get(i)));
                        if (command == null) {
                            writer.nulls();
                            continue;
                        }
                        COMMAND.describeCommand(command, writer);
                    }
                    writer.arrayEnd();
                    break;
                }
                case "LIST": {
                    if (arguments.size() == 1) {
                        writer.write(SERIALIZER);
                        break;
                    }
                    writer.customError("syntax error");
                    break;
                }
                default: {
                    writer.customError("unknown subcommand '" + subcommand + "'. Try COMMAND HELP.");
                }
            }
        }
        return handler.myStage();
    }

    private static void describeCommand(RespCommand command, ResponseWriter writer) {
        writer.arrayStart(10);
        writer.arrayNext();
        writer.string(command.getName());
        writer.arrayNext();
        writer.integers(command.getArity());
        writer.arrayNext();
        writer.emptySet();
        writer.arrayNext();
        writer.integers(command.getFirstKeyPos());
        writer.arrayNext();
        writer.integers(command.getLastKeyPos());
        writer.arrayNext();
        writer.integers(command.getSteps());
        writer.arrayNext();
        writer.array(AclCategory.aclNames(command.aclMask()), Resp3Type.BULK_STRING);
        writer.arrayNext();
        writer.emptySet();
        writer.arrayNext();
        writer.emptySet();
        writer.arrayNext();
        writer.emptySet();
        writer.arrayEnd();
    }
}

