/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.json;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.json.EmbeddedJsonCache;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class JSONSET
extends RespCommand
implements Resp3Command {
    private static final String XX = "XX";
    private static final String NX = "NX";
    private static final BiConsumer<? super String, ResponseWriter> biConsumer = JSONSET::jsonSetBiConsumer;

    public JSONSET() {
        super("JSON.SET", -4, 1, 1, 1, AclCategory.JSON.mask() | AclCategory.WRITE.mask() | AclCategory.SLOW.mask());
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] key = arguments.get(0);
        byte[] path = arguments.get(1);
        byte[] value = arguments.get(2);
        if (arguments.size() > 4) {
            handler.writer().syntaxError();
            return handler.myStage();
        }
        boolean nx = false;
        boolean xx = false;
        if (arguments.size() == 4) {
            String arg;
            switch (arg = new String(arguments.get(3), StandardCharsets.UTF_8).toUpperCase()) {
                case "NX": {
                    nx = true;
                    break;
                }
                case "XX": {
                    xx = true;
                    break;
                }
                default: {
                    handler.writer().syntaxError();
                    return handler.myStage();
                }
            }
        }
        EmbeddedJsonCache ejc = handler.getJsonCache();
        if (JSONUtil.isValueInvalid(value)) {
            handler.writer().customError("Invalid json value for JSON.SET");
            return handler.myStage();
        }
        CompletionStage<String> cs = ejc.set(key, value, path, nx, xx);
        return handler.stageToReturn(cs, ctx, biConsumer);
    }

    private static void jsonSetBiConsumer(String value, ResponseWriter writer) {
        if (value == null) {
            writer.nulls();
            return;
        }
        if ("OK".equals(value)) {
            writer.ok();
            return;
        }
        writer.error(value);
    }
}

