/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

@ProtoTypeId(value=6112)
public class JsonArrayAppendFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Long>> {
    @ProtoField(value=1)
    final byte[] path;
    @ProtoField(value=2)
    final List<byte[]> values;

    @ProtoFactory
    public JsonArrayAppendFunction(byte[] path, List<byte[]> values) {
        this.path = path;
        this.values = values;
    }

    public List<Long> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        if (doc == null) {
            throw new CacheException("could not perform this operation on a key that doesn't exist");
        }
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtxPath = JSONUtil.parserForMod.parse((Object)rootNode);
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (Predicate[])new Predicate[0]);
            ArrayNode pathList = (ArrayNode)jpCtxPath.read(jpath);
            ArrayList<Long> resList = new ArrayList<Long>();
            boolean changed = false;
            ArrayNode srcNodes = JSONUtil.objectMapper.createArrayNode();
            for (byte[] value : this.values) {
                srcNodes.add(JSONUtil.objectMapper.readTree(value));
            }
            for (JsonNode pathAsNode : pathList) {
                ArrayNode node = (ArrayNode)jpCtx.read(pathAsNode.asText(), new Predicate[0]);
                if (node.get(0).isArray()) {
                    ArrayNode destNode = (ArrayNode)node.get(0);
                    ArrayNode newString = destNode.addAll(srcNodes);
                    if (JSONUtil.isRoot(pathAsNode.asText().getBytes(StandardCharsets.UTF_8))) {
                        entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)newString)), new MetaParam.Writable[0]);
                        resList.add(Long.valueOf(newString.size()));
                        return resList;
                    }
                    jpCtx.set(pathAsNode.asText(), (Object)newString, new Predicate[0]);
                    changed = true;
                    resList.add(Long.valueOf(newString.size()));
                    continue;
                }
                resList.add(null);
            }
            if (changed) {
                entryView.set((Object)new JsonBucket(JSONUtil.objectMapper.writeValueAsBytes((Object)rootNode)), new MetaParam.Writable[0]);
            }
            return resList;
        }
        catch (IOException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

