/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.commons.CacheException;
import org.infinispan.functional.EntryView;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.server.resp.json.JSONUtil;
import org.infinispan.server.resp.json.JsonBucket;
import org.infinispan.util.function.SerializableFunction;

abstract class JsonLenFunction
implements SerializableFunction<EntryView.ReadWriteEntryView<byte[], JsonBucket>, List<Long>> {
    public static final String ERR_PATH_CAN_T_BE_NULL = "path can't be null";
    @ProtoField(value=1)
    protected final byte[] path;
    protected final Predicate<JsonNode> condition;
    protected final Function<JsonNode, Long> mapper;

    protected JsonLenFunction(byte[] path, Predicate<JsonNode> condition, Function<JsonNode, Long> mapper) {
        Objects.requireNonNull(path, ERR_PATH_CAN_T_BE_NULL);
        this.path = path;
        this.condition = condition;
        this.mapper = mapper;
    }

    public List<Long> apply(EntryView.ReadWriteEntryView<byte[], JsonBucket> entryView) {
        JsonBucket doc = entryView.find().orElse(null);
        String pathStr = new String(this.path, StandardCharsets.UTF_8);
        if (doc == null) {
            return null;
        }
        try {
            JsonNode rootNode = JSONUtil.objectMapper.readTree(doc.value());
            DocumentContext jpCtx = JSONUtil.parserForGet.parse((Object)rootNode);
            JsonPath jpath = JsonPath.compile((String)pathStr, (com.jayway.jsonpath.Predicate[])new com.jayway.jsonpath.Predicate[0]);
            ArrayNode nodeList = (ArrayNode)jpCtx.read(jpath);
            ArrayList<Long> result = new ArrayList<Long>();
            this.addNodeSize(result, nodeList, this.condition, this.mapper);
            return result;
        }
        catch (CacheException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private void addNodeSize(List<Long> result, ArrayNode nodeList, Predicate<JsonNode> condition, Function<JsonNode, Long> mapper) {
        nodeList.forEach(jsonNode -> result.add(condition.test((JsonNode)jsonNode) ? (Long)mapper.apply((JsonNode)jsonNode) : null));
    }
}

