/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import java.util.function.Consumer;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.ResponseSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufResponseWriter;

final class ByteBufThrowableSerializer
implements ResponseSerializer<Throwable, ByteBufPool> {
    static final ByteBufThrowableSerializer INSTANCE = new ByteBufThrowableSerializer();
    private static final String DEFAULT_ERROR_MESSAGE = "failed handling command";

    ByteBufThrowableSerializer() {
    }

    @Override
    public void accept(Throwable throwable, ByteBufPool alloc) {
        ByteBufResponseWriter w = new ByteBufResponseWriter(alloc);
        Consumer<ResponseWriter> writer = ResponseWriter.handleException(throwable);
        if (writer != null) {
            writer.accept(w);
        } else {
            w.error("-ERR " + this.extractRootCauseMessage(throwable));
        }
    }

    private String extractRootCauseMessage(Throwable t) {
        Throwable r;
        for (r = t; r != null && r.getCause() != null; r = r.getCause()) {
        }
        return r == null ? DEFAULT_ERROR_MESSAGE : r.getMessage();
    }

    @Override
    public boolean test(Object object) {
        return object instanceof Throwable;
    }
}

