/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.lua;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.jdkspecific.CallerId;
import org.infinispan.server.resp.RespVersion;
import org.infinispan.server.resp.scripting.LuaContext;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.serialization.SerializationHint;
import party.iroiro.luajava.Lua;

public class LuaResponseWriter
implements ResponseWriter {
    private final Lua lua;
    private RespVersion version = RespVersion.RESP3;
    private int arrayIndex = 0;

    public LuaResponseWriter(Lua lua) {
        this.lua = lua;
    }

    @Override
    public RespVersion version() {
        return this.version;
    }

    @Override
    public void version(RespVersion version) {
        this.version = version;
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public void nulls() {
        this.lua.checkStack(1);
        this.lua.pushNil();
    }

    @Override
    public void ok() {
        this.lua.checkStack(1);
        this.lua.push("OK");
    }

    @Override
    public void queued(Object ignore) {
        throw new UnsupportedOperationException("queued(Object)");
    }

    @Override
    public void simpleString(CharSequence value) {
        this.lua.checkStack(1);
        if (value == null) {
            this.lua.pushNil();
        } else {
            this.lua.push(value.toString());
        }
    }

    @Override
    public void string(CharSequence value) {
        this.lua.checkStack(1);
        if (value == null) {
            this.lua.pushNil();
        } else {
            this.lua.push(value.toString());
        }
    }

    @Override
    public void string(byte[] value) {
        this.lua.checkStack(1);
        if (value == null) {
            this.lua.pushNil();
        } else {
            this.lua.push(new String(value, StandardCharsets.ISO_8859_1));
        }
    }

    @Override
    public void integers(Number value) {
        this.lua.checkStack(1);
        if (value == null) {
            this.lua.pushNil();
        } else {
            this.lua.push(value);
        }
    }

    @Override
    public void doubles(Number value) {
        this.lua.checkStack(1);
        if (value == null) {
            this.lua.pushNil();
        } else {
            this.lua.push(value);
        }
    }

    @Override
    public void booleans(boolean value) {
        this.lua.checkStack(1);
        this.lua.push(value);
    }

    @Override
    public void arrayEmpty() {
        this.lua.checkStack(1);
        this.lua.push(false);
    }

    @Override
    public <T> void array(Collection<T> collection, JavaObjectSerializer<T> serializer) {
        if (collection == null) {
            this.nulls();
        } else {
            this.lua.checkStack(2);
            this.lua.newTable();
            int i = 1;
            for (T o : collection) {
                this.lua.push((long)i);
                serializer.accept(o, this);
                this.lua.setTable(-3);
                ++i;
            }
        }
    }

    @Override
    public void array(Collection<?> collection, Resp3Type contentType) {
        if (collection == null) {
            this.nulls();
        } else {
            this.lua.checkStack(2);
            this.lua.newTable();
            int i = 1;
            for (Object o : collection) {
                this.lua.push((long)i);
                contentType.serialize(o, this);
                this.lua.setTable(-3);
                ++i;
            }
        }
    }

    @Override
    public void emptySet() {
        this.set(Collections.emptySet(), Resp3Type.BULK_STRING);
    }

    @Override
    public void set(Set<?> set, Resp3Type contentType) {
        if (set == null) {
            this.nulls();
        } else {
            this.lua.checkStack(3);
            this.lua.newTable();
            this.lua.push("set");
            this.lua.newTable();
            for (Object o : set) {
                contentType.serialize(o, this);
                this.lua.checkStack(1);
                this.lua.push(true);
                this.lua.setTable(-3);
            }
            this.lua.setTable(-3);
            this.lua.push("len");
            this.lua.push((long)set.size());
            this.lua.setTable(-3);
        }
    }

    @Override
    public <T> void set(Set<?> set, JavaObjectSerializer<T> serializer) {
        throw new UnsupportedOperationException(CallerId.getCallerMethodName((int)1));
    }

    @Override
    public void map(Map<?, ?> map) {
        this.map(map, Resp3Type.BULK_STRING);
    }

    @Override
    public void map(Map<?, ?> map, Resp3Type contentType) {
        this.map(map, contentType, contentType);
    }

    @Override
    public void map(Map<?, ?> map, Resp3Type keyType, Resp3Type valueType) {
        if (map == null) {
            this.nulls();
        } else {
            this.lua.checkStack(3);
            this.lua.newTable();
            this.lua.push("map");
            this.lua.newTable();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                keyType.serialize(entry.getKey(), this);
                valueType.serialize(entry.getValue(), this);
                this.lua.setTable(-3);
            }
            this.lua.setTable(-3);
            this.lua.push("len");
            this.lua.push((long)map.size());
            this.lua.setTable(-3);
        }
    }

    @Override
    public void map(Map<?, ?> map, SerializationHint.KeyValueHint keyValueHint) {
        if (map == null) {
            this.nulls();
        } else {
            this.lua.checkStack(3);
            this.lua.newTable();
            this.lua.push("map");
            this.lua.newTable();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                keyValueHint.key().serialize(entry.getKey(), this);
                keyValueHint.value().serialize(entry.getValue(), this);
                this.lua.setTable(-3);
            }
            this.lua.setTable(-3);
            this.lua.push("len");
            this.lua.push((long)map.size());
            this.lua.setTable(-3);
        }
    }

    @Override
    public void error(CharSequence value) {
        this.lua.checkStack(3);
        LuaContext.luaPushError(this.lua, value.toString());
        this.lua.push("ignore_error_stats_update");
        this.lua.push(true);
        this.lua.setTable(-3);
    }

    @Override
    public void error(Throwable t) {
        this.error(LuaContext.filterCause(t).getMessage());
    }

    @Override
    public <T> void write(T object, JavaObjectSerializer<T> serializer) {
        throw new UnsupportedOperationException(CallerId.getCallerMethodName((int)1));
    }

    @Override
    public <T> void write(JavaObjectSerializer<T> serializer) {
        serializer.accept(null, this);
    }

    @Override
    public void serialize(Object object) {
        throw new UnsupportedOperationException(CallerId.getCallerMethodName((int)1));
    }

    @Override
    public void writeNumericPrefix(byte symbol, long number) {
        throw new UnsupportedOperationException(CallerId.getCallerMethodName((int)1));
    }

    @Override
    public void arrayStart(int size) {
        assert (this.arrayIndex == 0);
        this.lua.checkStack(2);
        this.lua.newTable();
        this.arrayIndex = 1;
    }

    @Override
    public void arrayEnd() {
        if (this.arrayIndex > 1) {
            this.lua.setTable(-3);
        }
        this.arrayIndex = 0;
    }

    @Override
    public void arrayNext() {
        if (this.arrayIndex > 1) {
            this.lua.setTable(-3);
        }
        this.lua.push((long)this.arrayIndex++);
    }
}

