/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.connection;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Commands;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.serialization.ByteBufferUtils;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.Resp3Response;

public class COMMAND
extends RespCommand
implements Resp3Command {
    public static final String NAME = "COMMAND";
    private static final JavaObjectSerializer<Object> SERIALIZER = (ignore, alloc) -> {
        List<RespCommand> commands = Commands.all();
        ByteBufferUtils.writeNumericPrefix((byte)42, commands.size(), alloc);
        for (RespCommand command : commands) {
            COMMAND.describeCommand(command, alloc);
        }
    };

    public COMMAND() {
        super(NAME, -1, 0, 0, 0);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        if (!arguments.isEmpty()) {
            RespErrorUtil.customError("COMMAND does not currently support arguments", handler.allocator());
        } else {
            Resp3Response.write(handler.allocator(), SERIALIZER);
        }
        return handler.myStage();
    }

    private static void describeCommand(RespCommand command, ByteBufPool alloc) {
        ByteBufferUtils.writeNumericPrefix((byte)42, 10L, alloc);
        Resp3Response.simpleString(command.getName(), alloc);
        Resp3Response.integers(command.getArity(), alloc);
        Resp3Response.emptySet(alloc);
        Resp3Response.integers(command.getFirstKeyPos(), alloc);
        Resp3Response.integers(command.getLastKeyPos(), alloc);
        Resp3Response.integers(command.getSteps(), alloc);
        Resp3Response.emptySet(alloc);
        Resp3Response.emptySet(alloc);
        Resp3Response.emptySet(alloc);
        Resp3Response.emptySet(alloc);
    }
}

