/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.generic;

import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.Resp3Command;

public class TTL
extends RespCommand
implements Resp3Command {
    private final boolean unixTime;
    private final boolean milliseconds;

    public TTL() {
        this(false, false);
    }

    protected TTL(boolean unixTime, boolean milliseconds) {
        super(2, 1, 1, 1);
        this.unixTime = unixTime;
        this.milliseconds = milliseconds;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        byte[] keyBytes = arguments.get(0);
        MediaType vmt = handler.cache().getValueDataConversion().getStorageMediaType();
        return handler.stageToReturn(handler.cache().withMediaType(MediaType.APPLICATION_OCTET_STREAM, vmt).getCacheEntryAsync((Object)keyBytes).thenApply(e -> {
            if (e == null) {
                return -2L;
            }
            long ttl = e.getLifespan();
            if (this.unixTime) {
                ttl = Util.toUnixTime(ttl, handler.respServer().getTimeService());
            }
            if (this.milliseconds) {
                return ttl;
            }
            return ttl < 0L ? ttl : ttl / 1000L;
        }), ctx, Consumers.LONG_BICONSUMER);
    }
}

