/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.ArgumentUtils;

public final class ZSetCommonUtils {
    public static final byte[] WITHSCORES = "WITHSCORES".getBytes();
    public static byte EXCLUDE = (byte)40;

    private ZSetCommonUtils() {
    }

    public static boolean isWithScoresArg(byte[] arg) {
        return Util.isAsciiBytesEquals(arg, WITHSCORES);
    }

    private static boolean isInf(byte[] arg, char sign) {
        if (arg.length != 4) {
            return false;
        }
        return arg[0] == (byte)sign && arg[1] == 105 && arg[2] == 110 && arg[3] == 102;
    }

    public static Lex parseLex(byte[] arg) {
        if (arg.length == 0) {
            return null;
        }
        Lex lex = new Lex();
        if (arg.length == 1 && arg[0] == 45) {
            lex.unboundedMin = true;
            return lex;
        }
        if (arg.length == 1 && arg[0] == 43) {
            lex.unboundedMax = true;
            return lex;
        }
        boolean bl = lex.include = arg[0] == 91;
        if (!lex.include && arg[0] != 40) {
            return null;
        }
        lex.value = Arrays.copyOfRange(arg, 1, arg.length);
        return lex;
    }

    public static Score parseScore(byte[] arg) {
        try {
            Score score = new Score();
            if (ZSetCommonUtils.isInf(arg, '-')) {
                score.unboundedMin = true;
                return score;
            }
            if (ZSetCommonUtils.isInf(arg, '+')) {
                score.unboundedMax = true;
                return score;
            }
            if (arg[0] == EXCLUDE) {
                score.value = ArgumentUtils.toDouble(arg, 1);
                score.include = false;
            } else {
                score.value = ArgumentUtils.toDouble(arg);
            }
            return score;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static List<byte[]> mapResultsToArrayList(Collection<ScoredValue<byte[]>> scoredValues, boolean withScores) {
        ArrayList<byte[]> elements = new ArrayList<byte[]>();
        for (ScoredValue<byte[]> item : scoredValues) {
            elements.add((byte[])item.getValue());
            if (!withScores) continue;
            elements.add(Double.toString(item.score()).getBytes(StandardCharsets.US_ASCII));
        }
        return elements;
    }

    public static class Lex {
        public boolean include;
        public boolean unboundedMin;
        public boolean unboundedMax;
        public byte[] value;
    }

    public static class Score {
        public boolean unboundedMin;
        public boolean unboundedMax;
        public boolean include = true;
        public Double value;
    }
}

