/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyValue;
import io.lettuce.core.MapScanCursor;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.sync.RedisCommands;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.HashOperationsTest")
public class HashOperationsTest
extends SingleNodeRespBaseTest {
    public void testHMSET() {
        RedisCommands redis = this.redisConnection.sync();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((String)redis.hmset((Object)"HMSET", map)).isEqualTo("OK");
        Assertions.assertThat((String)((String)redis.hget((Object)"HMSET", (Object)"key1"))).isEqualTo("value1");
        Assertions.assertThat((String)((String)redis.hget((Object)"HMSET", (Object)"unknown"))).isNull();
        Assertions.assertThat((String)((String)redis.hget((Object)"UNKNOWN", (Object)"unknown"))).isNull();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hmset((Object)"plain", Map.of("k1", "v1")));
    }

    public void testHSET() {
        RedisCommands redis = this.redisConnection.sync();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"HSET", map)).isEqualTo(3L);
        Assertions.assertThat((Long)redis.hset((Object)"HSET", Map.of("key1", "other-value1"))).isEqualTo(0L);
        Assertions.assertThat((Long)redis.hset((Object)"HSET", Map.of("key2", "other-value2", "key4", "value4"))).isEqualTo(1L);
        Assertions.assertThat((String)((String)redis.hget((Object)"HSET", (Object)"key1"))).isEqualTo("other-value1");
        Assertions.assertThat((String)((String)redis.hget((Object)"HSET", (Object)"unknown"))).isNull();
        Assertions.assertThat((String)((String)redis.hget((Object)"UNKNOWN", (Object)"unknown"))).isNull();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hmset((Object)"plain", Map.of("k1", "v1")));
        RespTestingUtil.assertWrongType(() -> redis.hmset((Object)"data", Map.of("k1", "v1")), () -> redis.get((Object)"data"));
        RespTestingUtil.assertWrongType(() -> {}, () -> redis.hget((Object)"plain", (Object)"k1"));
    }

    public void testHashLength() {
        RedisCommands redis = this.redisConnection.sync();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"len-test", map)).isEqualTo(3L);
        Assertions.assertThat((Long)redis.hlen((Object)"len-test")).isEqualTo(3L);
        Assertions.assertThat((Long)redis.hlen((Object)"UNKNOWN")).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hlen((Object)"plain"));
    }

    @Test
    public void testHashStringLength() {
        RedisCommands redis = this.redisConnection.sync();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"len-test", map)).isEqualTo(3L);
        Assertions.assertThat((Long)redis.hstrlen((Object)"len-test", (Object)"key1")).isEqualTo(6L);
        Assertions.assertThat((Long)redis.hstrlen((Object)"UNKNOWN", (Object)"key1")).isEqualTo(0L);
        Assertions.assertThat((Long)redis.hstrlen((Object)"len-test", (Object)"UNKNOWN")).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hstrlen((Object)"plain", (Object)"field"));
    }

    public void testHScanOperation() {
        RedisCommands redis = this.redisConnection.sync();
        HashMap<CallSite, CallSite> content = new HashMap<CallSite, CallSite>();
        int dataSize = 15;
        redis.flushdb();
        for (int i = 0; i < dataSize; ++i) {
            content.put((CallSite)((Object)("key" + i)), (CallSite)((Object)("value" + i)));
        }
        Assertions.assertThat((String)redis.hmset((Object)"hscan-test", content)).isEqualTo("OK");
        Assertions.assertThat((Long)redis.hlen((Object)"hscan-test")).isEqualTo((long)dataSize);
        HashMap scanned = new HashMap();
        MapScanCursor cursor = redis.hscan((Object)"hscan-test");
        while (true) {
            scanned.putAll(cursor.getMap());
            if (cursor.isFinished()) break;
            cursor = redis.hscan((Object)"hscan-test", (ScanCursor)cursor);
        }
        ((MapAssert)Assertions.assertThat(scanned).hasSize(dataSize)).containsAllEntriesOf(content);
        MapScanCursor empty = redis.hscan((Object)"unknown");
        ((ObjectAssert)Assertions.assertThat((Object)empty).satisfies(new ThrowingConsumer[]{v -> Assertions.assertThat((boolean)v.isFinished()).isTrue()})).satisfies(new ThrowingConsumer[]{v -> Assertions.assertThat((Map)v.getMap()).isEmpty()});
    }

    public void testHScanCount() {
        RedisCommands redis = this.redisConnection.sync();
        HashMap<CallSite, CallSite> content = new HashMap<CallSite, CallSite>();
        int dataSize = 15;
        for (int i = 0; i < dataSize; ++i) {
            content.put((CallSite)((Object)("key" + i)), (CallSite)((Object)("value" + i)));
        }
        Assertions.assertThat((String)redis.hmset((Object)"hscan-count-test", content)).isEqualTo("OK");
        Assertions.assertThat((Long)redis.hlen((Object)"hscan-count-test")).isEqualTo((long)dataSize);
        int count = 5;
        HashMap scanned = new HashMap();
        ScanArgs args = ScanArgs.Builder.limit((long)count);
        MapScanCursor cursor = redis.hscan((Object)"hscan-count-test", args);
        while (true) {
            scanned.putAll(cursor.getMap());
            if (cursor.isFinished()) break;
            Assertions.assertThat((Map)cursor.getMap()).hasSize(count);
            cursor = redis.hscan((Object)"hscan-count-test", (ScanCursor)cursor, args);
        }
        ((MapAssert)Assertions.assertThat(scanned).hasSize(dataSize)).containsAllEntriesOf(content);
    }

    public void testHScanMatch() {
        RedisCommands redis = this.redisConnection.sync();
        HashMap<CallSite, CallSite> content = new HashMap<CallSite, CallSite>();
        int dataSize = 15;
        for (int i = 0; i < dataSize; ++i) {
            content.put((CallSite)((Object)("k" + i)), (CallSite)((Object)("value" + i)));
        }
        Assertions.assertThat((String)redis.hmset((Object)"hscan-match-test", content)).isEqualTo("OK");
        Assertions.assertThat((Long)redis.hlen((Object)"hscan-match-test")).isEqualTo((long)dataSize);
        HashMap scanned = new HashMap();
        ScanArgs args = ScanArgs.Builder.matches((String)"k1*");
        MapScanCursor cursor = redis.hscan((Object)"hscan-match-test", args);
        while (true) {
            scanned.putAll(cursor.getMap());
            for (String key : cursor.getMap().keySet()) {
                Assertions.assertThat((String)key).startsWith((CharSequence)"k1");
            }
            if (cursor.isFinished()) break;
            cursor = redis.hscan((Object)"hscan-match-test", (ScanCursor)cursor, args);
        }
        ((MapAssert)Assertions.assertThat(scanned).hasSize(6)).containsKeys((Object[])new String[]{"k1", "k10", "k11", "k12", "k13", "k14"});
    }

    public void testKeySetOperation() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((List)redis.hkeys((Object)"something")).asList().isEmpty();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"keyset-operation", map)).isEqualTo(3L);
        ((AbstractListAssert)Assertions.assertThat((List)redis.hkeys((Object)"keyset-operation")).asList().hasSize(3)).containsAll(map.keySet());
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hkeys((Object)"plain"));
    }

    public void testValuesOperation() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((List)redis.hvals((Object)"something")).asList().isEmpty();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"values-operation", map)).isEqualTo(3L);
        ((AbstractListAssert)Assertions.assertThat((List)redis.hvals((Object)"values-operation")).asList().hasSize(3)).containsAll(map.values());
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hvals((Object)"plain"));
    }

    public void testPropertyExists() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Boolean)redis.hexists((Object)"something", (Object)"key")).isFalse();
        Assertions.assertThat((Boolean)redis.hset((Object)"exists-test", (Object)"key", (Object)"value")).isTrue();
        Assertions.assertThat((Boolean)redis.hexists((Object)"exists-test", (Object)"key")).isTrue();
        Assertions.assertThat((Boolean)redis.hexists((Object)"exists-test", (Object)"key2")).isFalse();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hexists((Object)"plain", (Object)"key"));
    }

    public void testSetAndGet() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.hdel((Object)"not-existent", (Object[])new String[]{"key1"})).isEqualTo(0L);
        Assertions.assertThat((Map)redis.hgetall((Object)"not-existent")).isEmpty();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"HSET-HDEL", map)).isEqualTo(3L);
        Assertions.assertThat((Map)redis.hgetall((Object)"HSET-HDEL")).containsAllEntriesOf(map);
        Assertions.assertThat((Long)redis.hdel((Object)"HSET-HDEL", (Object[])new String[]{"key1"})).isEqualTo(1L);
        Assertions.assertThat((Long)redis.hdel((Object)"HSET-HDEL", (Object[])new String[]{"key1"})).isEqualTo(0L);
        Assertions.assertThat((Long)redis.hdel((Object)"HSET-HDEL", (Object[])new String[]{"key2", "key3", "key4"})).isEqualTo(2L);
        Assertions.assertThat((Map)redis.hgetall((Object)"HSET-HDEL")).isEmpty();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hdel((Object)"plain", (Object[])new String[]{"key1"}));
    }

    public void testIncrementOperations() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.hincrby((Object)"incr-test", (Object)"age", 5L)).isEqualTo(5L);
        Assertions.assertThat((Long)redis.hincrby((Object)"incr-test", (Object)"age", 2L)).isEqualTo(7L);
        Assertions.assertThat((Long)redis.hincrby((Object)"incr-test", (Object)"age", -3L)).isEqualTo(4L);
        Assertions.assertThat((Long)redis.hincrby((Object)"incr-test", (Object)"age", 0L)).isEqualTo(4L);
        Map<String, String> map = Map.of("key1", "value1");
        Assertions.assertThat((Long)redis.hset((Object)"incr-test", map)).isEqualTo(1L);
        Assertions.assertThat((String)((String)redis.hget((Object)"incr-test", (Object)"key1"))).isEqualTo("value1");
        Assertions.assertThat((String)((String)redis.hget((Object)"incr-test", (Object)"age"))).isEqualTo("4");
        AssertionsForClassTypes.assertThatThrownBy(() -> redis.hincrby((Object)"incr-test", (Object)"key1", 1L)).hasCauseInstanceOf(RedisCommandExecutionException.class).hasMessageContaining("value is not an integer or out of range");
        Assertions.assertThat((Double)redis.hincrbyfloat((Object)"incr-test", (Object)"age", 0.5)).isEqualTo(4.5);
        AssertionsForClassTypes.assertThatThrownBy(() -> redis.hincrbyfloat((Object)"incr-test", (Object)"key1", 1.0)).hasCauseInstanceOf(RedisCommandExecutionException.class).hasMessageContaining("value is not an integer or out of range");
        AssertionsForClassTypes.assertThatThrownBy(() -> redis.hincrby((Object)"incr-test", (Object)"age", 1L)).hasCauseInstanceOf(RedisCommandExecutionException.class).hasMessageContaining("value is not an integer or out of range");
        Assertions.assertThat((Double)redis.hincrbyfloat((Object)"incr-test", (Object)"age", 0.5)).isEqualTo(5.0);
        Assertions.assertThat((Long)redis.hincrby((Object)"incr-test", (Object)"age", -1L)).isEqualTo(4L);
        Assertions.assertThat((Double)redis.hincrbyfloat((Object)"incr-test", (Object)"age", -0.5)).isEqualTo(3.5);
        Assertions.assertThat((String)((String)redis.hget((Object)"incr-test", (Object)"key1"))).isEqualTo("value1");
        Assertions.assertThat((String)((String)redis.hget((Object)"incr-test", (Object)"age"))).isEqualTo("3.5");
    }

    public void testHrandField() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)((String)redis.hrandfield((Object)"something"))).isNull();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"hrand-operations", map)).isEqualTo(3L);
        Assertions.assertThat((String)((String)redis.hrandfield((Object)"hrand-operations"))).isIn(map.keySet());
        Assertions.assertThat((Object)redis.hrandfieldWithvalues((Object)"hrand-operations")).satisfies(new ThrowingConsumer[]{kv -> Assertions.assertThat((String)((String)map.get(kv.getKey()))).isEqualTo((String)kv.getValue())});
        Assertions.assertThat((List)redis.hrandfield((Object)"hrand-operations", 0L)).isEmpty();
        Assertions.assertThat((List)redis.hrandfield((Object)"hrand-operations", 2L)).hasSize(2);
        Assertions.assertThat((List)redis.hrandfieldWithvalues((Object)"hrand-operations", 2L)).hasSize(2);
        Assertions.assertThat((List)redis.hrandfield((Object)"hrand-operations", 20L)).hasSize(3);
        Assertions.assertThat((List)redis.hrandfieldWithvalues((Object)"hrand-operations", 20L)).hasSize(3);
        Assertions.assertThat((List)redis.hrandfield((Object)"hrand-operations", -20L)).hasSize(20);
        Assertions.assertThat((List)redis.hrandfieldWithvalues((Object)"hrand-operations", -20L)).hasSize(20);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hrandfield((Object)"plain"));
    }

    public void testHMultiGet() {
        RedisCommands redis = this.redisConnection.sync();
        ((ListAssert)Assertions.assertThat((List)redis.hmget((Object)"something", (Object[])new String[]{"k1"})).hasSize(1)).contains((Object[])new KeyValue[]{KeyValue.empty((Object)"k1")});
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"hmget-operations", map)).isEqualTo(3L);
        ((ListAssert)Assertions.assertThat((List)redis.hmget((Object)"hmget-operations", (Object[])new String[]{"key1", "key2", "key3"})).hasSize(3)).satisfies(new ThrowingConsumer[]{entries -> entries.forEach(kv -> Assertions.assertThat((String)((String)map.get(kv.getKey()))).isEqualTo((String)kv.getValue()))});
        ((ListAssert)((ListAssert)Assertions.assertThat((List)redis.hmget((Object)"hmget-operations", (Object[])new String[]{"key3", "key4"})).hasSize(2)).contains((Object[])new KeyValue[]{KeyValue.just((Object)"key3", (Object)"value3")})).contains((Object[])new KeyValue[]{KeyValue.empty((Object)"key4")});
    }

    public void testHSetNx() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Boolean)redis.hsetnx((Object)"key", (Object)"propK", (Object)"propV")).isTrue();
        Assertions.assertThat((Boolean)redis.hsetnx((Object)"key", (Object)"propK", (Object)"value")).isFalse();
        Assertions.assertThat((String)((String)redis.hget((Object)"key", (Object)"propK"))).isEqualTo("propV");
    }
}

