/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.test.Stoppable;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespServerTest")
public class RespServerTest
extends AbstractInfinispanTest {
    public void testValidateDefaultConfiguration() {
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createCacheManager(), cm -> Stoppable.useServer((AbstractProtocolServer)new RespServer(), ms -> {
            ms.start((ProtocolServerConfiguration)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().port(0)).build(), cm);
            AssertJUnit.assertEquals((String)ms.getHost(), (String)"127.0.0.1");
            AssertJUnit.assertEquals((String)ms.getCache().getName(), (String)"respCache");
        }));
    }

    public void testExpiration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.encoding().key().mediaType(MediaType.APPLICATION_OCTET_STREAM);
        config.expiration().lifespan(10L);
        Stoppable.useCacheManager((EmbeddedCacheManager)TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)config), cm -> Stoppable.useServer((AbstractProtocolServer)new RespServer(), ms -> {
            ms.start((ProtocolServerConfiguration)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().port(0)).defaultCacheName((String)cm.getCacheManagerConfiguration().defaultCacheName().get())).build(), cm);
            AssertJUnit.assertEquals((long)10L, (long)ms.getCache().getCacheConfiguration().expiration().lifespan());
        }));
    }

    public void testNoDefaultConfigurationLocal() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        Stoppable.useCacheManager((EmbeddedCacheManager)new DefaultCacheManager(global.build()), cm -> Stoppable.useServer((AbstractProtocolServer)new RespServer(), ms -> {
            ms.start((ProtocolServerConfiguration)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().port(0)).build(), (EmbeddedCacheManager)cm);
            AssertJUnit.assertEquals((Object)CacheMode.LOCAL, (Object)ms.getCache().getCacheConfiguration().clustering().cacheMode());
        }));
    }

    public void testNoDefaultConfigurationClustered() {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        Stoppable.useCacheManager((EmbeddedCacheManager)new DefaultCacheManager(global.build()), cm -> Stoppable.useServer((AbstractProtocolServer)new RespServer(), ms -> {
            ms.start((ProtocolServerConfiguration)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().port(0)).build(), (EmbeddedCacheManager)cm);
            AssertJUnit.assertEquals((Object)CacheMode.DIST_SYNC, (Object)ms.getCache().getCacheConfiguration().clustering().cacheMode());
        }));
    }
}

