/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.AbstractRedisClient;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.RESPHashFunctionPartitioner;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.server.resp.test.TestSetup;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.AfterClass;

public abstract class AbstractRespTest
extends MultipleCacheManagersTest {
    private List<RespServer> servers;
    private List<AbstractRedisClient> clients;
    protected int timeout = 15000;
    protected final TimeService timeService = new ControlledTimeService();

    protected void createCacheManagers() {
        TestSetup setup = this.setup();
        this.servers = new ArrayList<RespServer>(setup.clusterSize());
        this.clients = new ArrayList<AbstractRedisClient>(setup.clusterSize());
        for (int i = 0; i < setup.clusterSize(); ++i) {
            EmbeddedCacheManager ecm = setup.createCacheManager(this::defaultRespConfiguration, this::amendConfiguration);
            TestingUtil.replaceComponent((CacheContainer)ecm, TimeService.class, (Object)this.timeService, (boolean)true);
            this.cacheManagers.add(ecm);
            RespServer server = this.createRespServer(i, ecm);
            this.servers.add(server);
        }
        for (RespServer server : this.servers) {
            AbstractRedisClient c = this.createRedisClient(server.getPort());
            if (c == null) continue;
            this.clients.add(c);
        }
        this.afterSetupFinished();
    }

    protected abstract TestSetup setup();

    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
    }

    protected void afterSetupFinished() {
    }

    protected AbstractRedisClient createRedisClient(int port) {
        return RespTestingUtil.createClient(this.timeout, port);
    }

    protected RespServer createRespServer(int i, EmbeddedCacheManager ecm) {
        RespServerConfiguration serverConfiguration = this.serverConfiguration(i).build();
        return RespTestingUtil.startServer(ecm, serverConfiguration);
    }

    protected RespServerConfigurationBuilder serverConfiguration(int i) {
        String serverName = TestResourceTracker.getCurrentTestShortName();
        return (RespServerConfigurationBuilder)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().name(serverName)).host("127.0.0.1")).port(RespTestingUtil.port() + i);
    }

    protected final <T extends AbstractRedisClient> T client(int i) {
        return (T)this.clients.get(i);
    }

    protected final RespServer server(int i) {
        return this.servers.get(i);
    }

    protected final Cache<String, String> respCache(int i) {
        return this.manager(i).getCache(((RespServerConfiguration)this.server(i).getConfiguration()).defaultCacheName());
    }

    protected final ConfigurationBuilder defaultRespConfiguration() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.encoding().key().mediaType(MediaType.APPLICATION_OCTET_STREAM);
        builder.clustering().hash().keyPartitioner((KeyPartitioner)new RESPHashFunctionPartitioner()).numSegments(256);
        return builder;
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        for (AbstractRedisClient client : this.clients) {
            RespTestingUtil.killClient(client);
        }
        for (RespServer server : this.servers) {
            RespTestingUtil.killServer(server);
        }
        super.destroy();
    }
}

