/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.ValueScanCursor;
import io.lettuce.core.api.sync.RedisCommands;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespSetCommandsTest")
public class RespSetCommandsTest
extends SingleNodeRespBaseTest {
    @Test
    public void testSadd() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sadd";
        Long newValue = redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((long)newValue).isEqualTo(3L);
        newValue = redis.sadd((Object)key, (Object[])new String[]{"4", "5"});
        Assertions.assertThat((long)newValue).isEqualTo(2L);
        newValue = redis.sadd((Object)key, (Object[])new String[]{"5", "6"});
        Assertions.assertThat((long)newValue).isEqualTo(1L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sadd((Object)"leads", (Object[])new String[]{"william"}));
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sadd((Object)"listleads", (Object[])new String[]{"william"}));
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"data", (Object[])new String[]{"e1"}), () -> redis.get((Object)"data"));
    }

    @Test
    public void testSmembers() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "smembers";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Collection)redis.smembers((Object)key)).containsExactlyInAnyOrder((Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Collection)redis.smembers((Object)"nonexistent")).isEmpty();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.smembers((Object)"leads"));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.smembers((Object)"listleads"));
    }

    @Test
    public void testSismember() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sismember";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Boolean)redis.sismember((Object)key, (Object)"e1")).isTrue();
        Assertions.assertThat((Boolean)redis.sismember((Object)key, (Object)"e4")).isFalse();
        Assertions.assertThat((Boolean)redis.sismember((Object)"nonexistent-sismember", (Object)"e4")).isFalse();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sismember((Object)"leads", (Object)"tristan"));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sismember((Object)"listleads", (Object)"tristan"));
    }

    @Test
    public void testScard() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "smembers";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Long)redis.scard((Object)key)).isEqualTo(3L);
        Assertions.assertThat((Long)redis.scard((Object)"nonexistent")).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.scard((Object)"leads"));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.scard((Object)"listleads"));
    }

    @Test
    public void testSinter() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sinter";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Collection)redis.sinter((Object[])new String[]{key})).containsExactlyInAnyOrder((Object[])new String[]{"e1", "e2", "e3"});
        String key1 = "sinter1";
        redis.sadd((Object)key1, (Object[])new String[]{"e2", "e3", "e4"});
        Assertions.assertThat((Collection)redis.sinter((Object[])new String[]{key, key1})).containsExactlyInAnyOrder((Object[])new String[]{"e2", "e3"});
        Assertions.assertThat((Collection)redis.sinter((Object[])new String[]{"nonexistent", "nonexistent1"})).isEmpty();
        Assertions.assertThat((Collection)redis.sinter((Object[])new String[]{key, key1, "nonexistent"})).isEmpty();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sinter((Object[])new String[]{"leads", key}));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sinter((Object[])new String[]{"listleads", "william"}));
    }

    @Test
    public void testSintercard() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sinter";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Long)redis.sintercard((Object[])new String[]{key})).isEqualTo(3L);
        String key1 = "sinter1";
        redis.sadd((Object)key1, (Object[])new String[]{"e2", "e3", "e4"});
        Assertions.assertThat((Long)redis.sintercard((Object[])new String[]{key, key1})).isEqualTo(2L);
        Assertions.assertThat((Long)redis.sintercard(1L, (Object[])new String[]{key, key1})).isEqualTo(1L);
        Assertions.assertThat((Long)redis.sintercard((Object[])new String[]{"nonexistent", "nonexistent1"})).isEqualTo(0L);
        Assertions.assertThat((Long)redis.sintercard((Object[])new String[]{key, key1, "nonexistent"})).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sintercard((Object[])new String[]{"leads", key}));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sintercard((Object[])new String[]{"listleads", "william"}));
    }

    @Test
    public void testSinterstore() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sinter";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Long)redis.sinterstore((Object)"destination", (Object[])new String[]{key})).isEqualTo(3L);
        String key1 = "sinter1";
        redis.sadd((Object)key1, (Object[])new String[]{"e2", "e3", "e4"});
        Assertions.assertThat((Long)redis.sinterstore((Object)"destination", (Object[])new String[]{key, key1})).isEqualTo(2L);
        Assertions.assertThat((Collection)redis.smembers((Object)"destination")).containsExactlyInAnyOrder((Object[])new String[]{"e2", "e3"});
        Assertions.assertThat((Long)redis.sinterstore((Object)"destination", (Object[])new String[]{"nonexistent", "nonexistent1"})).isEqualTo(0L);
        Assertions.assertThat((Collection)redis.smembers((Object)"destination")).isEmpty();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sinterstore((Object)"destination", (Object[])new String[]{"leads", key}));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sinterstore((Object)"destination", (Object[])new String[]{"listleads", "william"}));
    }

    @Test
    public void testSmove() {
        RedisCommands redis = this.redisConnection.sync();
        String src = "smove-src";
        String dst = "smove-dst";
        redis.sadd((Object)src, (Object[])new String[]{"1", "2", "3"});
        redis.sadd((Object)dst, (Object[])new String[]{"4", "5"});
        Assertions.assertThat((Boolean)redis.smove((Object)src, (Object)dst, (Object)"2")).isTrue();
        Assertions.assertThat((Collection)redis.smembers((Object)src)).containsExactlyInAnyOrder((Object[])new String[]{"1", "3"});
        Assertions.assertThat((Collection)redis.smembers((Object)dst)).containsExactlyInAnyOrder((Object[])new String[]{"2", "4", "5"});
        Assertions.assertThat((Boolean)redis.smove((Object)src, (Object)dst, (Object)"3")).isTrue();
        Assertions.assertThat((Boolean)redis.smove((Object)src, (Object)dst, (Object)"3")).isFalse();
        String nesrc = "smove-nonexist-src";
        Assertions.assertThat((Boolean)redis.smove((Object)nesrc, (Object)dst, (Object)"2")).isFalse();
        String nedst = "smove-nonexist-dst";
        Assertions.assertThat((Boolean)redis.smove((Object)src, (Object)nedst, (Object)"1")).isTrue();
        Assertions.assertThat((Collection)redis.smembers((Object)src)).isEmpty();
        Assertions.assertThat((Collection)redis.smembers((Object)nedst)).containsExactlyInAnyOrder((Object[])new String[]{"1"});
        String samesrc = "same-src";
        redis.sadd((Object)samesrc, (Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((Boolean)redis.smove((Object)samesrc, (Object)samesrc, (Object)"2")).isTrue();
        Assertions.assertThat((Boolean)redis.smove((Object)samesrc, (Object)samesrc, (Object)"4")).isFalse();
    }

    @Test
    public void testSrem() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "srem";
        redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3", "4", "5"});
        Long removed = redis.srem((Object)key, (Object[])new String[]{"1"});
        Assertions.assertThat((long)removed).isEqualTo(1L);
        removed = redis.srem((Object)key, (Object[])new String[]{"4", "2", "5"});
        Assertions.assertThat((long)removed).isEqualTo(3L);
        removed = redis.srem((Object)key, (Object[])new String[]{"6"});
        Assertions.assertThat((long)removed).isEqualTo(0L);
        removed = redis.srem((Object)key, (Object[])new String[]{"6", "7"});
        Assertions.assertThat((long)removed).isEqualTo(0L);
        removed = redis.srem((Object)key, (Object[])new String[]{"3", "6"});
        Assertions.assertThat((long)removed).isEqualTo(1L);
        Assertions.assertThat((Collection)redis.smembers((Object)key)).isEmpty();
        ScanArgs args = ScanArgs.Builder.matches((String)"k1*");
        KeyScanCursor cursor = redis.scan(args);
        Assertions.assertThat((List)cursor.getKeys()).doesNotContain((Object[])new String[]{key});
        removed = redis.srem((Object)key, (Object[])new String[]{"4", "2"});
        Assertions.assertThat((long)removed).isEqualTo(0L);
        Assertions.assertThat((Long)redis.lpush((Object)key, (Object[])new String[]{"vittorio"})).isEqualTo(1L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.srem((Object)"leads", (Object[])new String[]{"william"}));
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.srem((Object)"listleads", (Object[])new String[]{"william"}));
    }

    @Test
    public void testSunion() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sunion";
        String key1 = "sunion1";
        String key2 = "sunion2";
        redis.sadd((Object)key, (Object[])new String[]{"e1"});
        Assertions.assertThat((Collection)redis.sunion((Object[])new String[]{key})).containsExactlyInAnyOrder((Object[])new String[]{"e1"});
        redis.sadd((Object)key1, (Object[])new String[]{"e2", "e3", "e4"});
        redis.sadd((Object)key2, (Object[])new String[]{"e5", "e6"});
        Assertions.assertThat((Collection)redis.sunion((Object[])new String[]{key, key1})).containsExactlyInAnyOrder((Object[])new String[]{"e1", "e2", "e3", "e4"});
        Assertions.assertThat((Collection)redis.sunion((Object[])new String[]{key, key1, key2})).containsExactlyInAnyOrder((Object[])new String[]{"e1", "e2", "e3", "e4", "e5", "e6"});
        Assertions.assertThat((Collection)redis.sunion((Object[])new String[]{key1, "nonexistent1"})).containsExactlyInAnyOrder((Object[])new String[]{"e2", "e3", "e4"});
        Assertions.assertThat((Collection)redis.sunion((Object[])new String[]{"nonexistent", "nonexistent1"})).isEmpty();
        Assertions.assertThat((Collection)redis.sunion((Object[])new String[]{key1, key1})).containsExactlyInAnyOrder((Object[])new String[]{"e2", "e3", "e4"});
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sunion((Object[])new String[]{"leads", key}));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sunion((Object[])new String[]{"listleads", "william"}));
    }

    @Test
    public void testSunionstore() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sunionstore";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        Assertions.assertThat((Long)redis.sunionstore((Object)"destination", (Object[])new String[]{key})).isEqualTo(3L);
        String key1 = "sunionstore1";
        redis.sadd((Object)key1, (Object[])new String[]{"e2", "e3", "e4"});
        Assertions.assertThat((Long)redis.sunionstore((Object)"destination", (Object[])new String[]{key, key1})).isEqualTo(4L);
        Assertions.assertThat((Collection)redis.smembers((Object)"destination")).containsExactlyInAnyOrder((Object[])new String[]{"e1", "e2", "e3", "e4"});
        Assertions.assertThat((Long)redis.sunionstore((Object)"destination", (Object[])new String[]{"destination", "nonexistent1"})).isEqualTo(4L);
        Assertions.assertThat((Long)redis.sunionstore((Object)"destination", (Object[])new String[]{"nonexistent", "nonexistent1"})).isEqualTo(0L);
        Assertions.assertThat((Collection)redis.smembers((Object)"destination")).isEmpty();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sunionstore((Object)"destination", (Object[])new String[]{"leads", key}));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sunionstore((Object)"destination", (Object[])new String[]{"listleads", "william"}));
    }

    @Test
    public void testSpop() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "spop";
        redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3"});
        Set initialSet = redis.smembers((Object)key);
        Set popSet = redis.spop((Object)key, 4L);
        Set finalSet = redis.smembers((Object)key);
        Assertions.assertThat((Collection)popSet).containsExactlyInAnyOrderElementsOf((Iterable)initialSet);
        Assertions.assertThat((Collection)finalSet).isEmpty();
        redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3", "4"});
        initialSet = redis.smembers((Object)key);
        popSet = redis.spop((Object)key, 4L);
        finalSet = redis.smembers((Object)key);
        Assertions.assertThat((Collection)popSet).containsExactlyInAnyOrderElementsOf((Iterable)initialSet);
        Assertions.assertThat((Collection)finalSet).isEmpty();
        redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3", "4", "5"});
        initialSet = redis.smembers((Object)key);
        popSet = redis.spop((Object)key, 3L);
        finalSet = redis.smembers((Object)key);
        Assertions.assertThat((int)(popSet.size() + finalSet.size())).isEqualTo(initialSet.size());
        HashSet copyOfPop = new HashSet(popSet);
        popSet.addAll(finalSet);
        Assertions.assertThat((Collection)popSet).containsExactlyInAnyOrder((Object[])((String[])initialSet.toArray(String[]::new)));
        initialSet.removeAll(finalSet);
        Assertions.assertThat((Collection)initialSet).containsExactlyInAnyOrder((Object[])((String[])copyOfPop.toArray(String[]::new)));
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.spop((Object)"leads", 1L));
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.spop((Object)"listleads", 1L));
    }

    @Test
    public void testRandmember() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "srandmember";
        redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3"});
        Set initialSet = redis.smembers((Object)key);
        List popSet = redis.srandmember((Object)key, 4L);
        Set finalSet = redis.smembers((Object)key);
        Assertions.assertThat((List)popSet).containsExactlyInAnyOrderElementsOf((Iterable)initialSet);
        Assertions.assertThat((Collection)finalSet).containsExactlyInAnyOrderElementsOf((Iterable)initialSet);
        popSet = redis.srandmember((Object)key, 4L);
        finalSet = redis.smembers((Object)key);
        Assertions.assertThat((List)popSet).containsExactlyInAnyOrderElementsOf((Iterable)initialSet);
        Assertions.assertThat((Collection)finalSet).containsExactlyInAnyOrderElementsOf((Iterable)initialSet);
        redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3", "4", "5"});
        initialSet = redis.smembers((Object)key);
        popSet = redis.srandmember((Object)key, 3L);
        finalSet = redis.smembers((Object)key);
        Assertions.assertThat((Collection)initialSet).containsAll((Iterable)popSet);
        redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3", "4", "5"});
        initialSet = redis.smembers((Object)key);
        popSet = redis.srandmember((Object)key, -20L);
        Assertions.assertThat((int)popSet.size()).isEqualTo(20);
        Assertions.assertThat((Collection)initialSet).containsAll((Iterable)popSet);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.srandmember((Object)"leads", 1L));
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.srandmember((Object)"listleads", 1L));
    }

    @Test
    public void testSscanMatch() {
        RedisCommands redis = this.redisConnection.sync();
        HashSet<CallSite> content = new HashSet<CallSite>();
        int dataSize = 15;
        for (int i = 0; i < dataSize; ++i) {
            content.add((CallSite)((Object)("v" + i)));
        }
        Assertions.assertThat((Long)redis.sadd((Object)"sscan-match-test", (Object[])((String[])content.toArray(String[]::new)))).isEqualTo((long)dataSize);
        HashSet scanned = new HashSet();
        ScanArgs args = ScanArgs.Builder.matches((String)"v1*");
        ValueScanCursor cursor = redis.sscan((Object)"sscan-match-test", args);
        while (true) {
            scanned.addAll(cursor.getValues());
            for (String key : cursor.getValues()) {
                Assertions.assertThat((String)key).startsWith((CharSequence)"v1");
            }
            if (cursor.isFinished()) break;
            cursor = redis.sscan((Object)"sscan-match-test", (ScanCursor)cursor, args);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(scanned).hasSize(6)).containsExactlyInAnyOrder((Object[])new String[]{"v1", "v10", "v11", "v12", "v13", "v14"});
    }

    @Test
    public void testHScanOperation() {
        RedisCommands redis = this.redisConnection.sync();
        HashSet<CallSite> content = new HashSet<CallSite>();
        int dataSize = 15;
        redis.flushdb();
        for (int i = 0; i < dataSize; ++i) {
            content.add((CallSite)((Object)("value" + i)));
        }
        Assertions.assertThat((Long)redis.sadd((Object)"sscan-test", (Object[])((String[])content.toArray(String[]::new)))).isEqualTo((long)dataSize);
        HashSet scanned = new HashSet();
        ValueScanCursor cursor = redis.sscan((Object)"sscan-test");
        while (true) {
            scanned.addAll(cursor.getValues());
            if (cursor.isFinished()) break;
            cursor = redis.sscan((Object)"sscan-test", (ScanCursor)cursor);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(scanned).hasSize(dataSize)).containsExactlyInAnyOrderElementsOf(content);
        ValueScanCursor empty = redis.sscan((Object)"unknown");
        ((ObjectAssert)Assertions.assertThat((Object)empty).satisfies(new ThrowingConsumer[]{v -> Assertions.assertThat((boolean)v.isFinished()).isTrue()})).satisfies(new ThrowingConsumer[]{v -> Assertions.assertThat((List)v.getValues()).isEmpty()});
    }

    @Test
    public void testSscanCount() {
        RedisCommands redis = this.redisConnection.sync();
        HashSet<CallSite> content = new HashSet<CallSite>();
        int dataSize = 15;
        for (int i = 0; i < dataSize; ++i) {
            content.add((CallSite)((Object)("value" + i)));
        }
        Assertions.assertThat((Long)redis.sadd((Object)"sscan-count-test", (Object[])((String[])content.toArray(String[]::new)))).isEqualTo((long)dataSize);
        int count = 5;
        HashSet scanned = new HashSet();
        ScanArgs args = ScanArgs.Builder.limit((long)count);
        ValueScanCursor cursor = redis.sscan((Object)"sscan-count-test", args);
        while (true) {
            scanned.addAll(cursor.getValues());
            if (cursor.isFinished()) break;
            Assertions.assertThat((List)cursor.getValues()).hasSize(count);
            cursor = redis.sscan((Object)"sscan-count-test", (ScanCursor)cursor, args);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(scanned).hasSize(dataSize)).containsExactlyInAnyOrderElementsOf(content);
    }

    @Test
    public void testSdiff() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sdiff";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        String key1 = "sdiff1";
        redis.sadd((Object)key1, (Object[])new String[]{"e2", "e3", "e4"});
        Assertions.assertThat((Collection)redis.sdiff((Object[])new String[]{key, key1})).containsExactlyInAnyOrder((Object[])new String[]{"e1"});
        String key2 = "sdiff2";
        redis.sadd((Object)key2, (Object[])new String[]{"e1", "e3", "e4"});
        Assertions.assertThat((Collection)redis.sdiff((Object[])new String[]{key, key1, key2})).isEmpty();
        Assertions.assertThat((Collection)redis.sdiff((Object[])new String[]{key, key})).isEmpty();
        Assertions.assertThat((Collection)redis.sdiff((Object[])new String[]{key, "nonexistent1"})).containsExactlyInAnyOrderElementsOf((Iterable)redis.smembers((Object)key));
        Assertions.assertThat((Collection)redis.sdiff((Object[])new String[]{"nonexistent", "nonexistent1"})).isEmpty();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sdiff((Object[])new String[]{"leads", key}));
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sdiff((Object[])new String[]{key, "leads"}));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sdiff((Object[])new String[]{"listleads", "william"}));
    }

    @Test
    public void testSdiffstore() {
        RedisCommands redis = this.redisConnection.sync();
        String dest = "dest";
        String key = "sdiffStore";
        redis.sadd((Object)key, (Object[])new String[]{"e1", "e2", "e3"});
        String key1 = "sdiff1Store";
        redis.sadd((Object)key1, (Object[])new String[]{"e2", "e3", "e4"});
        Assertions.assertThat((Long)redis.sdiffstore((Object)dest, (Object[])new String[]{key, key1})).isEqualTo(1L);
        Assertions.assertThat((Collection)redis.smembers((Object)dest)).containsExactlyInAnyOrder((Object[])new String[]{"e1"});
        String key2 = "sdiff2Store";
        redis.sadd((Object)key2, (Object[])new String[]{"e1", "e3", "e4"});
        Assertions.assertThat((Long)redis.sdiffstore((Object)dest, (Object[])new String[]{key, key1, key2})).isEqualTo(0L);
        Assertions.assertThat((Collection)redis.smembers((Object)dest)).isEmpty();
        Assertions.assertThat((Long)redis.sdiffstore((Object)dest, (Object[])new String[]{key, key})).isEqualTo(0L);
        Assertions.assertThat((Collection)redis.smembers((Object)dest)).isEmpty();
        Assertions.assertThat((Long)redis.sdiffstore((Object)dest, (Object[])new String[]{key, "nonexistent1"})).isEqualTo((long)redis.smembers((Object)key).size());
        Assertions.assertThat((Collection)redis.smembers((Object)dest)).containsExactlyInAnyOrderElementsOf((Iterable)redis.smembers((Object)key));
        Assertions.assertThat((Long)redis.sdiffstore((Object)"dest", (Object[])new String[]{"nonexistent", "nonexistent1"})).isEqualTo(0L);
        Assertions.assertThat((Collection)redis.smembers((Object)dest)).isEmpty();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sdiffstore((Object)"dest", (Object[])new String[]{"leads", key}));
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sdiffstore((Object)"dest", (Object[])new String[]{key, "leads"}));
        RespTestingUtil.assertWrongType(() -> redis.rpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sdiffstore((Object)"dest", (Object[])new String[]{"listleads", "william"}));
    }
}

