/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.GetExArgs;
import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.SetArgs;
import io.lettuce.core.StrAlgoArgs;
import io.lettuce.core.StringMatchResult;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.server.resp.CustomStringCommands;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.StringCommandsTest")
public class StringCommandsTest
extends SingleNodeRespBaseTest {
    @Test
    public void testIncrNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String nonPresentKey = "incr-notpresent";
        Long newValue = redis.incr((Object)nonPresentKey);
        Assertions.assertThat((long)newValue).isEqualTo(1L);
        Long nextValue = redis.incr((Object)nonPresentKey);
        Assertions.assertThat((long)nextValue).isEqualTo(2L);
    }

    @Test
    public void testIncrPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "incr";
        redis.set((Object)key, (Object)"12");
        Long newValue = redis.incr((Object)key);
        Assertions.assertThat((long)newValue).isEqualTo(13L);
        Long nextValue = redis.incr((Object)key);
        Assertions.assertThat((long)nextValue).isEqualTo(14L);
    }

    @Test
    public void testIncrPresentNotInteger() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "incr-string";
        redis.set((Object)key, (Object)"foo");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> redis.incr((Object)key)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("value is not an integer or out of range");
    }

    @Test
    public void testDecrNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String nonPresentKey = "decr-notpresent";
        Long newValue = redis.decr((Object)nonPresentKey);
        Assertions.assertThat((long)newValue).isEqualTo(-1L);
        Long nextValue = redis.decr((Object)nonPresentKey);
        Assertions.assertThat((long)nextValue).isEqualTo(-2L);
    }

    @Test
    public void testDecrPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "decr";
        redis.set((Object)key, (Object)"12");
        Long newValue = redis.decr((Object)key);
        Assertions.assertThat((long)newValue).isEqualTo(11L);
        Long nextValue = redis.decr((Object)key);
        Assertions.assertThat((long)nextValue).isEqualTo(10L);
    }

    @Test
    public void testIncrbyNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String nonPresentKey = "incrby-notpresent";
        Long newValue = redis.incrby((Object)nonPresentKey, 42L);
        Assertions.assertThat((long)newValue).isEqualTo(42L);
        Long nextValue = redis.incrby((Object)nonPresentKey, 2L);
        Assertions.assertThat((long)nextValue).isEqualTo(44L);
    }

    @Test
    public void testIncrbyPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "incrby";
        redis.set((Object)key, (Object)"12");
        Long newValue = redis.incrby((Object)key, 23L);
        Assertions.assertThat((long)newValue).isEqualTo(35L);
        Long nextValue = redis.incrby((Object)key, 23L);
        Assertions.assertThat((long)nextValue).isEqualTo(58L);
    }

    @Test
    public void testIncrbyPresentNotInteger() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "incrby-string";
        redis.set((Object)key, (Object)"foo");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> redis.incrby((Object)key, 1L), (String)"", (Object[])new Object[0]).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("value is not an integer or out of range");
    }

    @Test
    public void testDecrbyNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String nonPresentKey = "decrby-notpresent";
        Long newValue = redis.decrby((Object)nonPresentKey, 42L);
        Assertions.assertThat((long)newValue).isEqualTo(-42L);
        Long nextValue = redis.decrby((Object)nonPresentKey, 2L);
        Assertions.assertThat((long)nextValue).isEqualTo(-44L);
    }

    @Test
    public void testDecrbyPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "decrby";
        redis.set((Object)key, (Object)"12");
        Long newValue = redis.decrby((Object)key, 10L);
        Assertions.assertThat((long)newValue).isEqualTo(2L);
        Long nextValue = redis.decrby((Object)key, 10L);
        Assertions.assertThat((long)nextValue).isEqualTo(-8L);
    }

    @Test
    public void testIncrbyFloatNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String nonPresentKey = "incrbyfloat-notpresent";
        Double newValue = redis.incrbyfloat((Object)nonPresentKey, 0.42);
        Assertions.assertThat((double)newValue).isEqualTo(0.42, Assertions.withPrecision((Double)2.0));
        Double nextValue = redis.incrbyfloat((Object)nonPresentKey, 0.2);
        Assertions.assertThat((double)nextValue).isEqualTo(0.62, Assertions.withPrecision((Double)2.0));
    }

    @Test
    public void testIncrbyFloatPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "incrbyfloat";
        redis.set((Object)key, (Object)"0.12");
        Double newValue = redis.incrbyfloat((Object)key, 0.23);
        Assertions.assertThat((double)newValue).isEqualTo(0.35, Assertions.withPrecision((Double)2.0));
        Double nextValue = redis.incrbyfloat((Object)key, -0.23);
        Assertions.assertThat((double)nextValue).isEqualTo(0.12, Assertions.withPrecision((Double)2.0));
    }

    @Test
    public void testIncrbyFloatPresentNotFloat() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "incrbyfloat-string";
        redis.set((Object)key, (Object)"foo");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> redis.incrbyfloat((Object)key, 0.1), (String)"", (Object[])new Object[0]).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("value is not a valid float");
    }

    @Test
    public void testAppend() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "append";
        String val = "Hello";
        String app = " World";
        String expect = val + app;
        redis.set((Object)key, (Object)val);
        long retVal = redis.append((Object)key, (Object)app);
        Assertions.assertThat((long)retVal).isEqualTo((long)expect.length());
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo(expect);
    }

    @Test
    public void testAppendNotPresent() {
        String app;
        RedisCommands redis = this.redisConnection.sync();
        String key = "append";
        String expect = app = " World";
        long retVal = redis.append((Object)key, (Object)app);
        Assertions.assertThat((long)retVal).isEqualTo((long)expect.length());
        String val = (String)redis.get((Object)key);
        Assertions.assertThat((String)val).isEqualTo(expect);
    }

    public void testGetdel() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "getdel";
        redis.set((Object)key, (Object)"value");
        String retval = (String)redis.getdel((Object)key);
        Assertions.assertThat((String)retval).isEqualTo("value");
        Assertions.assertThat((String)((String)redis.get((Object)key))).isNull();
    }

    @Test
    public void testGetdelNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "getdel-notpresent";
        Assertions.assertThat((String)((String)redis.getdel((Object)key))).isNull();
    }

    @Test
    public void testStrlen() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "strlen";
        String val = "Hello";
        String app = " World";
        redis.set((Object)key, (Object)val);
        Assertions.assertThat((Long)redis.strlen((Object)key)).isEqualTo(5L);
        long retVal = redis.append((Object)key, (Object)app);
        Assertions.assertThat((Long)redis.strlen((Object)key)).isEqualTo(retVal);
    }

    @Test
    public void testStrlenUTF8() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "strlen-nonascii";
        String val = "Euro is \u20ac";
        String app = " yen is \u00a5";
        redis.set((Object)key, (Object)val);
        Assertions.assertThat((Long)redis.strlen((Object)key)).isEqualTo(11L);
        long retVal = redis.append((Object)key, (Object)app);
        Assertions.assertThat((Long)redis.strlen((Object)key)).isEqualTo(retVal);
    }

    @Test
    public void testStrlenNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "strlen-notpresent";
        Assertions.assertThat((Long)redis.strlen((Object)key)).isEqualTo(0L);
    }

    @Test
    public void testLcsCommand() {
        String key1 = "lcs-test-k1";
        String key2 = "lcs-test-k2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)"ohmytext");
        redis.set((Object)key2, (Object)"mynewtext");
        CustomStringCommands commands = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        byte[] k1 = key1.getBytes(StandardCharsets.US_ASCII);
        byte[] k2 = key2.getBytes(StandardCharsets.US_ASCII);
        byte[] match = commands.lcs(k1, k2);
        Assertions.assertThat((String)new String(match, StandardCharsets.US_ASCII)).isEqualTo("mytext");
        Assertions.assertThat((Long)commands.lcsLen(k1, k2)).isEqualTo(6L);
    }

    @Test(dataProvider="lcsCases")
    public void testLcs(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2});
        StringMatchResult res = redis.stralgoLcs(args);
        Assertions.assertThat((String)res.getMatchString()).isEqualTo(resp);
        Assertions.assertThat((long)res.getLen()).isZero();
    }

    @Test(dataProvider="lcsCases")
    public void testLcsLen(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).justLen();
        StringMatchResult res = redis.stralgoLcs(args);
        Assertions.assertThat((long)res.getLen()).isEqualTo((long)resp.length());
        Assertions.assertThat((String)res.getMatchString()).isNull();
    }

    @Test(dataProvider="lcsCases")
    public void testLcsIdx(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).withIdx();
        StringMatchResult res = redis.stralgoLcs(args);
        this.checkIdx(resp, idx, res, false);
    }

    @Test(dataProvider="lcsCases")
    public void testLcsIdxWithLen(String v1, String v2, String resp, int[][] idx) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).withIdx().withMatchLen();
        StringMatchResult res = redis.stralgoLcs(args);
        this.checkIdx(resp, idx, res, true);
    }

    @Test(dataProvider="lcsCasesWithMinLen")
    public void testLcsIdxWithMinLen(String v1, String v2, String resp, int[][] idxs, int minLen) {
        String key1 = "lcs-base-1";
        String key2 = "lcs-base-2";
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)key1, (Object)v1);
        redis.set((Object)key2, (Object)v2);
        StrAlgoArgs args = StrAlgoArgs.Builder.keys((String[])new String[]{key1, key2}).withIdx().minMatchLen(minLen);
        int[][] idx = (int[][])Arrays.stream(idxs).filter(pos -> ((int[])pos).length == 1 || pos[1] - pos[0] >= minLen).toArray(x$0 -> new int[x$0][]);
        StringMatchResult res = redis.stralgoLcs(args);
        this.checkIdx(resp, idx, res, false);
    }

    @DataProvider
    public Object[][] lcsCases() {
        return new Object[][]{{"GAC", "AGCAT", "AC", new int[][]{{2, 2, 2, 2}, {1, 1, 0, 0}, {2}}}, {"XMJYAUZ", "MZJAWXU", "MJAU", new int[][]{{5, 5, 6, 6}, {4, 4, 3, 3}, {2, 2, 2, 2}, {1, 1, 0, 0}, {4}}}, {"ohmytext", "mynewtext", "mytext", new int[][]{{4, 7, 5, 8}, {2, 3, 0, 1}, {6}}}, {"ABCBDAB", "BDCABA", "BDAB", new int[][]{{5, 6, 3, 4}, {3, 4, 0, 1}, {4}}}, {"ABCEZ12 21AAZ", "12ABZ 21AZAZ", "ABZ 21AAZ", new int[][]{{11, 12, 10, 11}, {7, 10, 5, 8}, {4, 4, 4, 4}, {0, 1, 2, 3}, {9}}}};
    }

    @DataProvider
    public Object[][] lcsCasesWithMinLen() {
        Object[][] minLengths = new Object[][]{{1}, {2}, {4}, {10}};
        Object[][] lcsCases = this.lcsCases();
        Object[][] result = new Object[lcsCases.length][];
        for (Object[] len : minLengths) {
            for (int i = 0; i < lcsCases.length; ++i) {
                result[i] = Stream.concat(Arrays.stream(lcsCases[i]), Arrays.stream(len)).toArray();
            }
        }
        return result;
    }

    private void checkIdx(String resp, int[][] idx, StringMatchResult res, boolean withLen) {
        List matches = res.getMatches();
        Assertions.assertThat((int)matches.size()).isEqualTo(idx.length - 1);
        for (int i = 0; i < matches.size(); ++i) {
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getA().getStart()).isEqualTo((long)idx[i][0]);
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getA().getEnd()).isEqualTo((long)idx[i][1]);
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getB().getStart()).isEqualTo((long)idx[i][2]);
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getB().getEnd()).isEqualTo((long)idx[i][3]);
            if (!withLen) continue;
            Assertions.assertThat((long)((StringMatchResult.MatchedPosition)matches.get(i)).getMatchLen()).isEqualTo((long)(idx[i][1] - idx[i][0] + 1));
        }
        Assertions.assertThat((long)res.getLen()).isEqualTo((long)resp.length());
        Assertions.assertThat((String)res.getMatchString()).isNull();
    }

    @Test
    void testGetRange() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "getrange";
        redis.set((Object)key, (Object)"A long string for testing");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, 1L, 7L))).isEqualTo(" long s");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, 10L, -2L))).isEqualTo("ing for testin");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, 0L, Long.MAX_VALUE))).isEqualTo("A long string for testing");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, Long.MIN_VALUE, Long.MAX_VALUE))).isEqualTo("A long string for testing");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, 0L, -9223372036854775807L))).isEqualTo("");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, Long.MAX_VALUE, -9223372036854775807L))).isEqualTo("");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, 0L, 0L))).isEqualTo("");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, 3L, 2L))).isEqualTo("");
        Assertions.assertThat((String)((String)redis.getrange((Object)"something", 0L, 10L))).isEqualTo("");
    }

    @Test
    void testGetRangeMultibyte() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "getrange";
        redis.set((Object)key, (Object)"Testing with \u20ac char");
        String g = (String)redis.getrange((Object)key, 13L, 20L);
        Assertions.assertThat((String)g).isEqualTo("\u20ac char");
        Assertions.assertThat((String)((String)redis.getrange((Object)key, 10L, -2L))).isEqualTo("th \u20ac cha");
    }

    @Test
    public void testSetrange() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "setrange";
        redis.set((Object)key, (Object)"A long string for testing");
        Assertions.assertThat((Long)redis.setrange((Object)key, 2L, (Object)"tiny")).isEqualTo(25L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("A tiny string for testing");
    }

    @Test
    public void testSetrangePatchOverflowsLength() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "setrange";
        redis.set((Object)key, (Object)"A long string for testing");
        Assertions.assertThat((Long)redis.setrange((Object)key, 18L, (Object)"setrange testing")).isEqualTo(34L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("A long string for setrange testing");
    }

    @Test
    public void testSetrangeOffsetGreaterThanLength() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "setrange";
        redis.set((Object)key, (Object)"A long string for testing");
        Assertions.assertThat((Long)redis.setrange((Object)key, 30L, (Object)"my setrange")).isEqualTo(41L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("A long string for testing\u0000\u0000\u0000\u0000\u0000my setrange");
    }

    @Test
    public void testSetrangeNotPresent() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "setrange-notpresent";
        Assertions.assertThat((Long)redis.setrange((Object)key, 5L, (Object)"my setrange")).isEqualTo(16L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("\u0000\u0000\u0000\u0000\u0000my setrange");
    }

    @Test
    public void testGetexWithEX() throws InterruptedException {
        RedisCommands redis = this.redisConnection.sync();
        GetExArgs args = GetExArgs.Builder.ex((long)1L);
        String key = "getexex";
        String value = "getex-value";
        redis.set((Object)key, (Object)value);
        redis.getex((Object)key, args);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo(value);
        ((ControlledTimeService)this.timeService).advance(2000L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isNull();
    }

    @Test
    public void testGetexWithPEX() throws InterruptedException {
        RedisCommands redis = this.redisConnection.sync();
        GetExArgs args = GetExArgs.Builder.px((long)500L);
        String key = "getexpex";
        String value = "getexpex-value";
        redis.set((Object)key, (Object)value);
        redis.getex((Object)key, args);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo(value);
        ((ControlledTimeService)this.timeService).advance(1000L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isNull();
    }

    @Test
    public void testGetexWithPERSIST() throws InterruptedException {
        RedisCommands redis = this.redisConnection.sync();
        GetExArgs args = GetExArgs.Builder.ex((long)2L);
        String key = "getexpersist";
        String value = "getexpersist-value";
        redis.set((Object)key, (Object)value);
        redis.getex((Object)key, args);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo(value);
        ((ControlledTimeService)this.timeService).advance(1000L);
        args = GetExArgs.Builder.persist();
        redis.getex((Object)key, args);
        ((ControlledTimeService)this.timeService).advance(1500L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo(value);
    }

    @Test
    public void testGetexWithEXNotPresent() throws InterruptedException {
        RedisCommands redis = this.redisConnection.sync();
        GetExArgs args = GetExArgs.Builder.ex((long)2L);
        String key = "getexex";
        redis.getex((Object)key, args);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isNull();
    }

    @Test
    public void testSetWithEX() throws InterruptedException {
        RedisCommands redis = this.redisConnection.sync();
        String key = "setex";
        String value = "getex-value";
        SetArgs args = new SetArgs().ex(1L);
        redis.set((Object)key, (Object)value, args);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo(value);
        ((ControlledTimeService)this.timeService).advance(2000L);
        Assertions.assertThat((String)((String)redis.get((Object)key))).isNull();
    }

    @Test
    public void testSetWithXX() throws InterruptedException {
        RedisCommands redis = this.redisConnection.sync();
        String key = "setxx";
        String value = "getex-value";
        SetArgs args = new SetArgs().xx();
        Assertions.assertThat((String)redis.set((Object)key, (Object)value, args)).isNull();
        redis.set((Object)key, (Object)value);
        Assertions.assertThat((String)redis.set((Object)key, (Object)value, args)).isEqualTo("OK");
    }

    @Test
    public void testSetWithXXWithTTL() throws InterruptedException {
        RedisCommands redis = this.redisConnection.sync();
        String key = "setxx";
        String value = "getex-value";
        redis.set((Object)key, (Object)value);
        SetArgs args = new SetArgs().xx().px(10000L);
        Assertions.assertThat((String)redis.set((Object)key, (Object)value, args)).isEqualTo("OK");
        Assertions.assertThat((Long)redis.ttl((Object)key)).isEqualTo(10L);
    }

    @Test
    public void testMsetnx() {
        RedisCommands redis = this.redisConnection.sync();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("k1", "v1");
        values.put("k3", "v3");
        values.put("k4", "v4");
        Assertions.assertThat((Boolean)redis.msetnx(values)).isEqualTo(true);
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>(4);
        expected.add(KeyValue.just((Object)"k1", (Object)"v1"));
        expected.add(KeyValue.empty((Object)"k2"));
        expected.add(KeyValue.just((Object)"k3", (Object)"v3"));
        expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
        List results = redis.mget((Object[])new String[]{"k1", "k2", "k3", "k4"});
        Assertions.assertThat((List)results).containsExactlyElementsOf(expected);
        values.clear();
        values.put("k4", "v4");
        values.put("k5", "v5");
        values.put("k6", "v6");
        Assertions.assertThat((Boolean)redis.msetnx(values)).isEqualTo(false);
        expected.clear();
        expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
        expected.add(KeyValue.empty((Object)"k5"));
        expected.add(KeyValue.empty((Object)"k6"));
        results = redis.mget((Object[])new String[]{"k4", "k5", "k6"});
        Assertions.assertThat((List)results).containsExactlyElementsOf(expected);
    }

    @Test
    public void testSetex() {
        RedisCommands redis = this.redisConnection.sync();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> redis.setex((Object)"key", -30L, (Object)"value")).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR invalid expire time in 'SETEX' command");
        Assertions.assertThat((boolean)this.redisConnection.isOpen()).isTrue();
        Assertions.assertThat((String)redis.setex((Object)"key", 1L, (Object)"value")).isEqualTo("OK");
        Assertions.assertThat((Long)redis.ttl((Object)"key")).isEqualTo(1L);
        ((ControlledTimeService)this.timeService).advance(2000L);
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isNull();
    }

    @Test
    public void testSetnx() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Boolean)redis.setnx((Object)"key", (Object)"value")).isTrue();
        Assertions.assertThat((Boolean)redis.setnx((Object)"key", (Object)"another-value")).isFalse();
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isEqualTo("value");
    }

    @Test
    public void testGetset() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)((String)redis.getset((Object)"key", (Object)"value"))).isNull();
        Assertions.assertThat((String)((String)redis.getset((Object)"key", (Object)"another"))).isEqualTo("value");
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isEqualTo("another");
    }

    @Test
    public void testGetsetWrongType() {
        RedisCommands redis = this.redisConnection.sync();
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"key", (Object[])new String[]{"value"}), () -> redis.getset((Object)"key", (Object)"shouldfail"));
        RespTestingUtil.assertWrongType(() -> {}, () -> redis.get((Object)"key"));
        Assertions.assertThat((List)redis.lrange((Object)"key", 0L, -1L)).containsExactly((Object[])new String[]{"value"});
    }

    @Test
    public void testGetsetCounter() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.incr((Object)"counter")).isEqualTo(1L);
        Assertions.assertThat((String)((String)redis.getset((Object)"counter", (Object)"0"))).isEqualTo("1");
        Assertions.assertThat((String)((String)redis.get((Object)"counter"))).isEqualTo("0");
    }

    @Test
    public void testPsetex() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.psetex((Object)"key", 1000L, (Object)"value")).isEqualTo("OK");
        Assertions.assertThat((Long)redis.pttl((Object)"key")).isEqualTo(1000L);
        ((ControlledTimeService)this.timeService).advance(1001L);
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isNull();
    }

    @Test
    public void testMget() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"k1", (Object)"v1");
        redis.sadd((Object)"k2", (Object[])new String[]{"s1", "s2", "s3"});
        redis.set((Object)"k3", (Object)"v3");
        redis.set((Object)"k4", (Object)"v4");
        List results = redis.mget((Object[])new String[]{"k1", "k2", "k3", "k4", "k5"});
        ArrayList<KeyValue> expected = new ArrayList<KeyValue>(5);
        expected.add(KeyValue.just((Object)"k1", (Object)"v1"));
        expected.add(KeyValue.empty((Object)"k2"));
        expected.add(KeyValue.just((Object)"k3", (Object)"v3"));
        expected.add(KeyValue.just((Object)"k4", (Object)"v4"));
        expected.add(KeyValue.empty((Object)"k5"));
        Assertions.assertThat((List)results).containsExactlyElementsOf(expected);
    }
}

