/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.types;

import io.lettuce.core.ScoredValue;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.types.DataStructuresMediaTypesTest")
public class DataStructuresMediaTypesTest
extends SingleNodeRespBaseTest {
    private boolean simpleCache;
    private MediaType valueType;

    public void testHSET() {
        RedisCommands redis = this.redisConnection.sync();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"HSET", map)).isEqualTo(3L);
        Assertions.assertThat((Long)redis.hset((Object)"HSET", Map.of("key1", "other-value1"))).isEqualTo(0L);
        Assertions.assertThat((Long)redis.hset((Object)"HSET", Map.of("key2", "other-value2", "key4", "value4"))).isEqualTo(1L);
        Assertions.assertThat((String)((String)redis.hget((Object)"HSET", (Object)"key1"))).isEqualTo("other-value1");
        Assertions.assertThat((String)((String)redis.hget((Object)"HSET", (Object)"unknown"))).isNull();
        Assertions.assertThat((String)((String)redis.hget((Object)"UNKNOWN", (Object)"unknown"))).isNull();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hmset((Object)"plain", Map.of("k1", "v1")));
        RespTestingUtil.assertWrongType(() -> {}, () -> redis.hget((Object)"plain", (Object)"k1"));
    }

    public void testRPUSH() {
        RedisCommands redis = this.redisConnection.sync();
        long result = redis.rpush((Object)"people", (Object[])new String[]{"tristan"});
        Assertions.assertThat((long)result).isEqualTo(1L);
        result = redis.rpush((Object)"people", (Object[])new String[]{"william"});
        Assertions.assertThat((long)result).isEqualTo(2L);
        result = redis.rpush((Object)"people", (Object[])new String[]{"william", "jose", "pedro"});
        Assertions.assertThat((long)result).isEqualTo(5L);
        Assertions.assertThat((List)redis.lrange((Object)"people", 0L, 4L)).containsExactly((Object[])new String[]{"tristan", "william", "william", "jose", "pedro"});
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.rpush((Object)"leads", (Object[])new String[]{"william"}));
    }

    public void testSadd() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sadd";
        Long newValue = redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((long)newValue).isEqualTo(3L);
        newValue = redis.sadd((Object)key, (Object[])new String[]{"4", "5"});
        Assertions.assertThat((long)newValue).isEqualTo(2L);
        newValue = redis.sadd((Object)key, (Object[])new String[]{"5", "6"});
        Assertions.assertThat((long)newValue).isEqualTo(1L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sadd((Object)"leads", (Object[])new String[]{"william"}));
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sadd((Object)"listleads", (Object[])new String[]{"william"}));
    }

    public void testZADD() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.zadd((Object)"people", 10.4, (Object)"william")).isEqualTo(1L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", new ScoredValue[]{ScoredValue.just((double)13.4, (Object)"tristan")})).isEqualTo(1L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"tristan")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", new ScoredValue[]{ScoredValue.just((double)13.4, (Object)"jose")})).isEqualTo(1L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", new ScoredValue[]{ScoredValue.just((double)13.4, (Object)"xavier")})).isEqualTo(1L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)13.4, (Object)"xavier")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")})).isEqualTo(2L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)13.4, (Object)"xavier"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", ZAddArgs.Builder.nx(), new ScoredValue[]{ScoredValue.just((double)0.8, (Object)"fabio"), ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan")})).isEqualTo(1L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)13.4, (Object)"xavier"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", ZAddArgs.Builder.xx(), new ScoredValue[]{ScoredValue.just((double)0.8, (Object)"fabio"), ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"katia")})).isEqualTo(0L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)0.8, (Object)"fabio"), ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", ZAddArgs.Builder.gt(), new ScoredValue[]{ScoredValue.just((double)13.0, (Object)"fabio"), ScoredValue.just((double)0.5, (Object)"xavier"), ScoredValue.just((double)2.0, (Object)"katia")})).isEqualTo(1L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)2.0, (Object)"katia"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.0, (Object)"fabio"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)redis.zadd((Object)"people", ZAddArgs.Builder.lt(), new ScoredValue[]{ScoredValue.just((double)100.0, (Object)"fabio"), ScoredValue.just((double)0.3, (Object)"xavier"), ScoredValue.just((double)0.2, (Object)"vittorio")})).isEqualTo(1L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)0.2, (Object)"vittorio"), ScoredValue.just((double)0.3, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)2.0, (Object)"katia"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.0, (Object)"fabio"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)21.9, (Object)"marc")});
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"another", (Object)"tristan"), () -> redis.zadd((Object)"another", 2.3, (Object)"tristan"));
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        if (this.simpleCache) {
            configurationBuilder.clustering().cacheMode(CacheMode.LOCAL).simpleCache(true);
        } else {
            configurationBuilder.clustering().cacheMode(this.cacheMode);
        }
        configurationBuilder.encoding().value().mediaType(this.valueType.toString());
    }

    private DataStructuresMediaTypesTest withValueType(MediaType type) {
        this.valueType = type;
        return this;
    }

    private DataStructuresMediaTypesTest withSimpleCache() {
        this.simpleCache = true;
        return this;
    }

    private DataStructuresMediaTypesTest withCacheMode(CacheMode mode) {
        this.cacheMode = mode;
        return this;
    }

    public Object[] factory() {
        MediaType[] types;
        ArrayList<DataStructuresMediaTypesTest> instances = new ArrayList<DataStructuresMediaTypesTest>();
        for (MediaType value : types = new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT, MediaType.TEXT_PLAIN}) {
            instances.add(new DataStructuresMediaTypesTest().withValueType(value).withCacheMode(CacheMode.LOCAL));
            instances.add(new DataStructuresMediaTypesTest().withValueType(value).withSimpleCache());
        }
        return instances.toArray();
    }

    protected String parameters() {
        return "[simpleCache=" + this.simpleCache + ", cacheMode=" + String.valueOf(this.cacheMode) + ", value=" + String.valueOf(this.valueType) + "]";
    }
}

