/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.CacheRespRequestHandler;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespConstants;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.commands.PubSubResp3Command;
import org.infinispan.server.resp.commands.pubsub.KeyChannelUtils;
import org.infinispan.server.resp.commands.pubsub.RespCacheListener;
import org.infinispan.server.resp.logging.Log;

public class SubscriberHandler
extends CacheRespRequestHandler {
    private static final Log log = (Log)LogFactory.getLog(MethodHandles.lookup().lookupClass(), Log.class);
    private static final AttributeKey<Long> SUBSCRIPTIONS_COUNTER = AttributeKey.newInstance((String)"channel-subscriptions");
    private final Resp3Handler resp3Handler;
    private final Map<WrappedByteArray, RespCacheListener> specificChannelSubscribers = new HashMap<WrappedByteArray, RespCacheListener>();

    public SubscriberHandler(RespServer respServer, Resp3Handler prevHandler) {
        super(respServer);
        this.resp3Handler = prevHandler;
    }

    public static RespCacheListener newKeyListener(Channel channel, byte[] key) {
        return new PubSubListener(channel, key);
    }

    public static RespCacheListener newPatternListener(Channel channel, byte[] pattern) {
        return new PubSubListener(channel, null, pattern);
    }

    public Map<WrappedByteArray, RespCacheListener> specificChannelSubscribers() {
        return this.specificChannelSubscribers;
    }

    public Resp3Handler resp3Handler() {
        return this.resp3Handler;
    }

    @Override
    public void handleChannelDisconnect(ChannelHandlerContext ctx) {
        this.removeAllListeners();
    }

    @Override
    protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand command, List<byte[]> arguments) {
        this.initializeIfNecessary(ctx);
        if (command instanceof PubSubResp3Command) {
            PubSubResp3Command pubSubsCommand = (PubSubResp3Command)((Object)command);
            return pubSubsCommand.perform(this, ctx, arguments);
        }
        return super.actualHandleRequest(ctx, command, arguments);
    }

    public CompletionStage<Void> handleStageListenerError(CompletionStage<Void> stage, byte[] keyChannel, boolean subscribeOrUnsubscribe) {
        return stage.whenComplete((__, t) -> {
            if (t != null) {
                if (subscribeOrUnsubscribe) {
                    log.exceptionWhileRegisteringListener((Throwable)t, CharsetUtil.UTF_8.decode(ByteBuffer.wrap(keyChannel)));
                } else {
                    log.exceptionWhileRemovingListener((Throwable)t, CharsetUtil.UTF_8.decode(ByteBuffer.wrap(keyChannel)));
                }
            }
        });
    }

    public void removeAllListeners() {
        Iterator<Map.Entry<WrappedByteArray, RespCacheListener>> iterator = this.specificChannelSubscribers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WrappedByteArray, RespCacheListener> entry = iterator.next();
            RespCacheListener listener = entry.getValue();
            this.cache.removeListenerAsync((Object)listener);
            iterator.remove();
        }
    }

    public CompletionStage<RespRequestHandler> unsubscribeAll(ChannelHandlerContext ctx) {
        AggregateCompletionStage aggregateCompletionStage = CompletionStages.aggregateCompletionStage();
        ArrayList<byte[]> channels = new ArrayList<byte[]>(this.specificChannelSubscribers.size());
        Iterator<Map.Entry<WrappedByteArray, RespCacheListener>> iterator = this.specificChannelSubscribers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<WrappedByteArray, RespCacheListener> entry = iterator.next();
            RespCacheListener listener = entry.getValue();
            CompletionStage stage = this.cache.removeListenerAsync((Object)listener);
            byte[] keyChannel = entry.getKey().getBytes();
            channels.add(keyChannel);
            aggregateCompletionStage.dependsOn(this.handleStageListenerError(stage, keyChannel, false));
            iterator.remove();
        }
        return this.sendSubscriptions(ctx, aggregateCompletionStage.freeze(), channels, false);
    }

    public CompletionStage<RespRequestHandler> sendSubscriptions(ChannelHandlerContext ctx, CompletionStage<Void> stageToWaitFor, Collection<byte[]> keyChannels, boolean subscribeOrUnsubscribe) {
        return this.stageToReturn(stageToWaitFor, ctx, (? super E __, ByteBufPool alloc) -> {
            assert (ctx.executor().inEventLoop());
            Long counter = (Long)ctx.channel().attr(SUBSCRIPTIONS_COUNTER).get();
            if (counter == null) {
                counter = 0L;
            }
            for (byte[] keyChannel : keyChannels) {
                String initialCharSeq = subscribeOrUnsubscribe ? "*3\r\n$9\r\nsubscribe\r\n$" : "*3\r\n$11\r\nunsubscribe\r\n$";
                counter = Math.max(0L, counter + (long)(subscribeOrUnsubscribe ? 1 : -1));
                int countSize = counter == 0L ? 1 : (int)Math.log10(counter.longValue()) + 1;
                int sizeRequired = initialCharSeq.length() + (int)Math.log10(keyChannel.length) + 1 + 2 + keyChannel.length + 2 + 1 + countSize + 2;
                ByteBuf subscribeBuffer = (ByteBuf)alloc.apply(sizeRequired);
                int initialPos = subscribeBuffer.writerIndex();
                subscribeBuffer.writeCharSequence((CharSequence)(initialCharSeq + keyChannel.length + "\r\n"), CharsetUtil.US_ASCII);
                subscribeBuffer.writeBytes(keyChannel);
                subscribeBuffer.writeBytes(RespConstants.CRLF);
                subscribeBuffer.writeByte(58);
                ByteBufferUtils.setIntChars(counter, countSize, subscribeBuffer);
                subscribeBuffer.writeBytes(RespConstants.CRLF);
                assert (subscribeBuffer.writerIndex() - initialPos == sizeRequired);
            }
            if (counter == 0L) {
                ctx.channel().attr(SUBSCRIPTIONS_COUNTER).set(null);
            } else {
                ctx.channel().attr(SUBSCRIPTIONS_COUNTER).set((Object)counter);
            }
        });
    }

    @Listener(clustered=true)
    public static class PubSubListener
    implements RespCacheListener {
        private final Channel channel;
        private final byte[] key;
        private final byte[] pattern;

        private PubSubListener(Channel channel, byte[] key) {
            this(channel, key, null);
        }

        private PubSubListener(Channel channel, byte[] key, byte[] pattern) {
            this.channel = channel;
            this.key = key;
            this.pattern = pattern;
        }

        @CacheEntryCreated
        @CacheEntryModified
        public CompletionStage<Void> onEvent(CacheEntryEvent<Object, byte[]> entryEvent) {
            byte[] key = KeyChannelUtils.channelToKey(this.unwrap(entryEvent.getKey()));
            byte[] value = (byte[])entryEvent.getValue();
            if (key.length > 0 && value != null && value.length > 0) {
                int byteSize = 18 + (int)Math.log10(key.length) + 1 + 2 + key.length + 2 + 1 + (int)Math.log10(value.length) + 1 + 2 + value.length + 2;
                ByteBuf byteBuf = this.channel.alloc().buffer(byteSize, byteSize);
                byteBuf.writeCharSequence((CharSequence)("*3\r\n$7\r\nmessage\r\n$" + key.length + "\r\n"), CharsetUtil.US_ASCII);
                byteBuf.writeBytes(key);
                byteBuf.writeCharSequence((CharSequence)("\r\n$" + value.length + "\r\n"), CharsetUtil.US_ASCII);
                byteBuf.writeBytes(value);
                byteBuf.writeByte(13);
                byteBuf.writeByte(10);
                assert (byteBuf.writerIndex() == byteSize);
                this.channel.writeAndFlush((Object)byteBuf, this.channel.voidPromise());
            }
            return CompletableFutures.completedNull();
        }

        private byte[] unwrap(Object key) {
            return key instanceof WrappedByteArray ? ((WrappedByteArray)key).getBytes() : (byte[])key;
        }

        @Override
        public byte[] subscribedChannel() {
            return this.key;
        }

        @Override
        public byte[] pattern() {
            return this.pattern;
        }
    }
}

