/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset;

import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.jgroups.util.CompletableFutures;

public class ZMPOP
extends RespCommand
implements Resp3Command {
    private static final byte[] MIN = "MIN".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] MAX = "MAX".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] COUNT = "COUNT".getBytes(StandardCharsets.US_ASCII);
    private static final BiConsumer<List<Object>, ByteBufPool> RESPONSE_HANDLER = (res, buff) -> {
        if (res != null) {
            Consumers.ZMPOP_BICONSUMER.accept((List)res, (ByteBufPool)buff);
        } else {
            Consumers.GET_BICONSUMER.accept((byte[])null, (ByteBufPool)buff);
        }
    };

    public ZMPOP() {
        super(-4, 0, 0, 0);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        boolean isMin;
        byte[] minOrMax;
        int pos = 0;
        int numberKeys = -1;
        try {
            byte[] bytes = arguments.get(pos++);
            numberKeys = ArgumentUtils.toInt(bytes);
        }
        catch (Exception bytes) {
            // empty catch block
        }
        if (numberKeys <= 0) {
            RespErrorUtil.customError("numkeys should be greater than 0", handler.allocator());
            return handler.myStage();
        }
        ArrayList<byte[]> sortedSetNames = new ArrayList<byte[]>();
        while (sortedSetNames.size() < numberKeys && pos < arguments.size()) {
            sortedSetNames.add(arguments.get(pos++));
        }
        if (sortedSetNames.size() != numberKeys || pos >= arguments.size()) {
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        if (Util.isAsciiBytesEquals(MIN, minOrMax = arguments.get(pos++))) {
            isMin = true;
        } else if (Util.isAsciiBytesEquals(MAX, minOrMax)) {
            isMin = false;
        } else {
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        int count = 1;
        if (pos < arguments.size()) {
            byte[] countArg;
            if (Util.isAsciiBytesEquals(COUNT, countArg = arguments.get(pos++)) && pos < arguments.size()) {
                try {
                    byte[] bytes = arguments.get(pos++);
                    count = ArgumentUtils.toInt(bytes);
                }
                catch (Exception ex) {
                    count = -1;
                }
                if (count <= 0) {
                    RespErrorUtil.customError("count should be greater than 0", handler.allocator());
                    return handler.myStage();
                }
            } else {
                RespErrorUtil.syntaxError(handler.allocator());
                return handler.myStage();
            }
        }
        if (arguments.size() > pos) {
            RespErrorUtil.syntaxError(handler.allocator());
            return handler.myStage();
        }
        CompletionStage<List<Object>> cs = this.asyncCalls(CompletableFutures.completedNull(), null, sortedSetNames.iterator(), count, isMin, ctx, handler);
        return handler.stageToReturn(cs, ctx, RESPONSE_HANDLER);
    }

    private CompletionStage<List<Object>> asyncCalls(CompletionStage<Collection<ScoredValue<byte[]>>> popValues, byte[] prevName, Iterator<byte[]> iteNames, long count, boolean isMin, ChannelHandlerContext ctx, Resp3Handler handler) {
        return popValues.thenApply(c -> {
            if (c != null && !c.isEmpty()) {
                ArrayList<Object> result = new ArrayList<Object>(2);
                result.add(prevName);
                result.add(c);
                return result;
            }
            return null;
        }).thenCompose(res -> {
            if (res != null) {
                return CompletableFuture.completedFuture(res);
            }
            if (!iteNames.hasNext()) {
                return CompletableFutures.completedNull();
            }
            byte[] nextName = (byte[])iteNames.next();
            return this.asyncCalls(handler.getSortedSeMultimap().pop((Object)nextName, isMin, count), nextName, iteNames, count, isMin, ctx, handler);
        });
    }
}

