/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.FixedLengthFrameDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.server.resp.BaseRespDecoder;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespDecoder;
import org.infinispan.server.resp.RespHandler;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.RespServer;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespDecoderTest")
public class RespDecoderTest {
    EmbeddedChannel channel;
    Queue<Request> queuedCommands;

    @BeforeClass
    public void beforeClass() {
        RespServer server = (RespServer)Mockito.mock((Object[])new RespServer[0]);
        Mockito.when((Object)server.getTimeService()).thenReturn((Object)new ControlledTimeService());
        this.queuedCommands = new ArrayDeque<Request>();
        RespRequestHandler myRespRequestHandler = new RespRequestHandler(server){

            protected CompletionStage<RespRequestHandler> actualHandleRequest(ChannelHandlerContext ctx, RespCommand type, List<byte[]> arguments) {
                RespDecoderTest.this.queuedCommands.add(new Request(type, arguments));
                return this.myStage;
            }
        };
        RespDecoder decoder = new RespDecoder();
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new FixedLengthFrameDecoder(1), decoder, new RespHandler((BaseRespDecoder)decoder, myRespRequestHandler)});
    }

    @AfterClass
    public void afterClass() {
        this.channel.close();
    }

    @Test
    public void testMixtureOfTypes() {
        String commandName = "PSUBSCRIBE";
        String minValueStr = String.valueOf(Long.MIN_VALUE);
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)("*6\r\n+" + commandName + "\r\n$3\r\nkey\r\n+value\r\n:23\r\n$5\r\nworks\r\n:" + minValueStr + "\r\n"), (Charset)StandardCharsets.US_ASCII);
        this.channel.writeInbound(new Object[]{buffer});
        this.channel.checkException();
        Request req = this.queuedCommands.poll();
        AssertJUnit.assertNotNull((Object)req);
        AssertJUnit.assertEquals((String)commandName, (String)req.command.getName());
        List<byte[]> arguments = req.arguments;
        AssertJUnit.assertEquals((int)5, (int)arguments.size());
        AssertJUnit.assertEquals((byte[])"key".getBytes(StandardCharsets.US_ASCII), (byte[])arguments.get(0));
        AssertJUnit.assertEquals((byte[])"value".getBytes(StandardCharsets.US_ASCII), (byte[])arguments.get(1));
        AssertJUnit.assertEquals((byte[])"23".getBytes(StandardCharsets.US_ASCII), (byte[])arguments.get(2));
        AssertJUnit.assertEquals((byte[])"works".getBytes(StandardCharsets.US_ASCII), (byte[])arguments.get(3));
        AssertJUnit.assertEquals((byte[])minValueStr.getBytes(StandardCharsets.US_ASCII), (byte[])arguments.get(4));
        AssertJUnit.assertEquals((int)0, (int)this.queuedCommands.size());
        AssertJUnit.assertEquals((int)0, (int)buffer.readableBytes());
    }

    static class Request {
        private final RespCommand command;
        private final List<byte[]> arguments;

        Request(RespCommand command, List<byte[]> arguments) {
            this.command = command;
            this.arguments = new ArrayList<byte[]>(arguments);
        }
    }
}

