/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.TransactionOperationsTest")
public class TransactionOperationsTest
extends SingleNodeRespBaseTest {
    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        configurationBuilder.invocationBatching().enable(true);
    }

    @Test
    public void testStartTxAndQueueCommands() throws Exception {
        int i;
        int numCommands = 20;
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        for (i = 0; i < numCommands; ++i) {
            Assertions.assertThat((String)redis.set((Object)("k" + i), (Object)("v" + i))).isNull();
        }
        ((IterableAssert)Assertions.assertThat((Iterable)redis.exec()).hasSize(numCommands)).allMatch("OK"::equals);
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        for (i = 0; i < numCommands; ++i) {
            Assertions.assertThat((String)((String)redis.get((Object)("k" + i)))).isEqualTo("v" + i);
        }
    }

    @Test
    public void testExecWithoutMulti() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).exec()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR EXEC without MULTI");
    }

    @Test
    public void testEmptyTransaction() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((Iterable)redis.exec()).isEmpty();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
    }

    @Test
    public void testTransactionWithError() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        redis.set((Object)"tx-err-k1", (Object)"v1");
        redis.hlen((Object)"tx-err-k1");
        redis.set((Object)"tx-err-k2", (Object)"v2");
        TransactionResult result = redis.exec();
        Assertions.assertThat((String)((String)result.get(0))).isEqualTo("OK");
        Assertions.assertThat((Throwable)((Throwable)result.get(1))).hasMessage("WRONGTYPE Operation against a key holding the wrong kind of value");
        Assertions.assertThat((String)((String)result.get(2))).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)((String)redis.get((Object)"tx-err-k1"))).isEqualTo("v1");
        Assertions.assertThat((String)((String)redis.get((Object)"tx-err-k2"))).isEqualTo("v2");
    }

    @Test
    public void testStartNestedTx() throws Exception {
        StatefulRedisConnection<String, String> multi = this.newConnection();
        RedisCommands redis = multi.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)multi.isMulti()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).multi()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR MULTI calls can not be nested");
        multi.closeAsync().get(10L, TimeUnit.SECONDS);
    }

    @Test
    public void testTransactionAbortWithError() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.watch((Object[])new String[]{"something"})).isNull();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).exec()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("EXECABORT Transaction discarded because of previous errors.");
    }

    @Test
    public void testTransactionWithWatcher() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.watch((Object[])new String[]{"tx-watcher-k1"})).isEqualTo("OK");
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)"tx-watcher-k1", (Object)"value")).isNull();
        TransactionResult result = redis.exec();
        Assertions.assertThat((String)((String)result.get(0))).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)((String)redis.get((Object)"tx-watcher-k1"))).isEqualTo("value");
    }

    @Test
    public void testWatcherCapturesChange() {
        this.testMultiWithWatcher(false);
    }

    @Test
    public void testRemovingWatcherBeforeExec() {
        this.testMultiWithWatcher(true);
    }

    private void testMultiWithWatcher(boolean unwatchBeforeExec) {
        StatefulRedisConnection<String, String> multi = this.newConnection();
        StatefulRedisConnection<String, String> outside = this.newConnection();
        RedisCommands tx = multi.sync();
        RedisCommands redis = outside.sync();
        Assertions.assertThat((String)tx.watch((Object[])new String[]{"tx-watcher-key"})).isEqualTo("OK");
        Assertions.assertThat((String)redis.set((Object)"tx-watcher-key", (Object)"value-outside")).isEqualTo("OK");
        if (unwatchBeforeExec) {
            Assertions.assertThat((String)tx.unwatch()).isEqualTo("OK");
        }
        Assertions.assertThat((String)tx.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)multi.isMulti()).isTrue();
        Assertions.assertThat((boolean)outside.isMulti()).isFalse();
        Assertions.assertThat((String)tx.set((Object)"tx-watcher-key", (Object)"value-inside")).isNull();
        TransactionResult result = tx.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isEqualTo(!unwatchBeforeExec);
        Assertions.assertThat((boolean)multi.isMulti()).isFalse();
        String expected = unwatchBeforeExec ? "value-inside" : "value-outside";
        Assertions.assertThat((String)((String)redis.get((Object)"tx-watcher-key"))).isEqualTo(expected);
        Assertions.assertThat((String)((String)tx.get((Object)"tx-watcher-key"))).isEqualTo(expected);
    }

    @Test
    public void testDiscardWithoutMulti() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).discard()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR DISCARD without MULTI");
    }

    @Test
    public void testDiscardingTransaction() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)"tx-discard-k1", (Object)"value")).isNull();
        Assertions.assertThat((String)redis.discard()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).exec()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR EXEC without MULTI");
        Assertions.assertThat((String)((String)redis.get((Object)"tx-discard-k1"))).isNull();
    }

    @Test
    public void testDiscardRemoveListeners() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.watch((Object[])new String[]{"tx-discard-k2"})).isEqualTo("OK");
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)"tx-discard-k2", (Object)"value")).isNull();
        Assertions.assertThat((String)redis.discard()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)"tx-discard-k2", (Object)"value-inside")).isNull();
        StatefulRedisConnection<String, String> outside = this.newConnection();
        RedisCommands outsideSync = outside.sync();
        Assertions.assertThat((String)outsideSync.set((Object)"tx-discard-k2", (Object)"value-outside")).isEqualTo("OK");
        Assertions.assertThat((String)((String)outsideSync.get((Object)"tx-discard-k2"))).isEqualTo("value-outside");
        outside.close();
        TransactionResult result = redis.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isFalse();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)((String)redis.get((Object)"tx-discard-k2"))).isEqualTo("value-inside");
    }
}

