/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.dist;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import java.time.Duration;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.AbstractRespTest;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.server.resp.test.TestSetup;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="dist.server.resp.BasicOperationsClusteredTest")
public class BasicOperationsClusteredTest
extends AbstractRespTest {
    private static final int CLUSTER_SIZE = 3;
    private RedisClusterClient client;
    private CacheMode mode;

    private BasicOperationsClusteredTest withCacheMode(CacheMode mode) {
        this.mode = mode;
        return this;
    }

    @Test
    public void testBasicCommandsClusteredClient() {
        try (StatefulRedisClusterConnection conn = this.client.connect();){
            RedisAdvancedClusterCommands redis = conn.sync();
            redis.set((Object)"k1", (Object)"v1");
            String v = (String)redis.get((Object)"k1");
            Assertions.assertThat((String)v).isEqualTo("v1");
            redis.del((Object[])new String[]{"k1"});
            Assertions.assertThat((String)((String)redis.get((Object)"k1"))).isNull();
            Assertions.assertThat((String)((String)redis.get((Object)"something"))).isNull();
        }
    }

    @Test
    public void testCommandRouting() {
        try (StatefulRedisConnection conn = ((RedisClient)this.client(0)).connect();){
            RedisCommands redis = conn.sync();
            for (int i = 1; i < 3; ++i) {
                String k = this.getStringKeyForCache(this.respCache(2));
                redis.set((Object)k, (Object)"value");
                String v = (String)redis.get((Object)k);
                Assertions.assertThat((String)v).isEqualTo("value");
                redis.del((Object[])new String[]{k});
                Assertions.assertThat((String)((String)redis.get((Object)k))).isNull();
            }
        }
    }

    @Override
    protected void afterSetupFinished() {
        ArrayList<RedisURI> uris = new ArrayList<RedisURI>(3);
        for (int i = 0; i < 3; ++i) {
            RespServer server = this.server(i);
            uris.add(RedisURI.Builder.redis((String)"127.0.0.1").withTimeout(Duration.ofMillis(this.timeout)).withPort(server.getPort().intValue()).build());
        }
        this.client = RedisClusterClient.create(uris);
    }

    public Object[] factory() {
        return new Object[]{new BasicOperationsClusteredTest().withCacheMode(CacheMode.DIST_SYNC), new BasicOperationsClusteredTest().withCacheMode(CacheMode.REPL_SYNC)};
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        configurationBuilder.clustering().cacheMode(this.mode);
    }

    protected String parameters() {
        return "[mode=" + String.valueOf(this.mode) + "]";
    }

    @Override
    protected TestSetup setup() {
        return TestSetup.clusteredTestSetup(3);
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        RespTestingUtil.killClient((AbstractRedisClient)this.client);
        super.destroy();
    }
}

