/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.test;

import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.testng.AssertJUnit;

public class CommonRespTests {
    public static void testPipeline(StatefulRedisConnection<String, String> redisConnection) throws ExecutionException, InterruptedException, TimeoutException {
        int commandCount = 35;
        AtomicReference error = new AtomicReference();
        AtomicInteger setCompleted = new AtomicInteger();
        RedisAsyncCommands redis = redisConnection.async();
        for (int i = 0; i < commandCount; ++i) {
            redis.set((Object)("key-" + i), (Object)("value-" + i)).whenComplete((___, t) -> {
                if (t != null) {
                    error.set(t);
                }
                setCompleted.incrementAndGet();
            });
        }
        redis.ping().get(10L, TimeUnit.SECONDS);
        Throwable throwable = (Throwable)error.get();
        if (throwable != null) {
            throw new AssertionError((Object)throwable);
        }
        AtomicReferenceArray atomicReferenceArray = new AtomicReferenceArray(commandCount + 1);
        int i = 0;
        while (i < commandCount) {
            String key = "key-" + i;
            if (i == 13) {
                redis.get((Object)"not-present").whenComplete((v, t) -> {
                    if (t != null) {
                        error.set(t);
                    } else {
                        atomicReferenceArray.set(commandCount, new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)("key-" + commandCount)), (String)v));
                    }
                });
            }
            int j = i++;
            redis.get((Object)key).whenComplete((v, t) -> {
                if (t != null) {
                    error.set(t);
                } else {
                    atomicReferenceArray.set(j, new AbstractMap.SimpleEntry<String, String>(key, (String)v));
                }
            });
        }
        redis.ping().get(10L, TimeUnit.SECONDS);
        throwable = (Throwable)error.get();
        if (throwable != null) {
            throw new AssertionError((Object)throwable);
        }
        for (i = 0; i < atomicReferenceArray.length(); ++i) {
            Map.Entry entry = (Map.Entry)atomicReferenceArray.get(i);
            AssertJUnit.assertEquals((String)("key-" + i), (String)((String)entry.getKey()));
            if (i == commandCount) {
                AssertJUnit.assertNull(entry.getValue());
                continue;
            }
            AssertJUnit.assertEquals((String)("value-" + i), (String)((String)entry.getValue()));
        }
    }
}

