/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.server.resp.BaseMultipleRespTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.ClusteredOperationsTest")
public class ClusteredOperationsTest
extends BaseMultipleRespTest {
    public void testClusteredGetAndSet() {
        int i;
        for (i = 0; i < 100; ++i) {
            Assertions.assertThat((String)this.redisConnection1.sync().set((Object)("key" + i), (Object)("value" + i))).isEqualTo("OK");
        }
        for (i = 0; i < 100; ++i) {
            Assertions.assertThat((String)((String)this.redisConnection2.sync().get((Object)("key" + i)))).isEqualTo("value" + i);
        }
    }

    public void retrieveShardsInformation() {
        this.validate(this.redisConnection1.sync().clusterShards());
        this.validate(this.redisConnection2.sync().clusterShards());
    }

    public void retrieveNodesInformation() {
        this.assertClusterNodesResponse(this.redisConnection1.sync().clusterNodes());
        this.assertClusterNodesResponse(this.redisConnection2.sync().clusterNodes());
    }

    private void assertClusterNodesResponse(String response) {
        Object[] nodes = response.split("\n");
        Assertions.assertThat((Object[])nodes).hasSize(2);
        for (Object node : nodes) {
            Object[] information = ((String)node).split(" ");
            ((ObjectArrayAssert)((ObjectArrayAssert)((ObjectArrayAssert)Assertions.assertThat((Object[])information).hasSizeGreaterThan(8)).containsAnyOf((Object[])new String[]{"master", "myself,master"})).satisfies(new ThrowingConsumer[]{c -> Assertions.assertThat((boolean)Stream.of(c).anyMatch(s -> s.startsWith("127.0.0.1:"))).isTrue()})).contains((Object[])new String[]{"connected", "-", "0"});
        }
    }

    public void retrieveSlotsInformation() {
        List slots = this.redisConnection1.sync().clusterSlots();
        Assertions.assertThat((List)slots).hasSizeGreaterThanOrEqualTo(2);
        for (Object slot : slots) {
            List values = (List)slot;
            Assertions.assertThat((List)values).hasSizeGreaterThanOrEqualTo(3);
            Assertions.assertThat(values.get(0)).isInstanceOf(Long.class);
            Assertions.assertThat(values.get(1)).isInstanceOf(Long.class);
            List<Object> owner = ClusteredOperationsTest.asList(values, 2);
            Assertions.assertThat(owner).hasSizeGreaterThanOrEqualTo(3);
            ((ObjectAssert)Assertions.assertThat((Object)owner.get(0)).isInstanceOf(String.class)).satisfies(new ThrowingConsumer[]{h -> Assertions.assertThat((h.equals(this.server1.getHost()) || h.equals(this.server2.getHost()) ? 1 : 0) != 0).isTrue()});
            ((ObjectAssert)Assertions.assertThat((Object)owner.get(1)).isInstanceOf(Long.class)).satisfies(new ThrowingConsumer[]{v -> Assertions.assertThat((v.equals(this.server1.getPort()) || v.equals(this.server2.getPort()) ? 1 : 0) != 0).isTrue()});
        }
    }

    private void validate(List<Object> shards) {
        Assertions.assertThat(shards).hasSize(2);
        ClusteredOperationsTest.assertShard(ClusteredOperationsTest.asList(shards, 0), 2);
        ClusteredOperationsTest.assertShard(ClusteredOperationsTest.asList(shards, 1), 2);
    }

    static void assertShard(List<Object> values, int size) {
        ((ListAssert)Assertions.assertThat(values).hasSize(4)).contains(new Object[]{"slots", "nodes"});
        HashMap<String, Object> slot = new HashMap<String, Object>();
        slot.put((String)values.get(0), values.get(1));
        slot.put((String)values.get(2), values.get(3));
        ((ObjectAssert)Assertions.assertThat(slot.get("slots")).isInstanceOf(List.class)).asList().isNotEmpty();
        ((ObjectAssert)Assertions.assertThat(slot.get("nodes")).isInstanceOf(List.class)).asList().hasSize(size);
        for (int i = 0; i < size; ++i) {
            String role = i == 0 ? "master" : "replica";
            ClusteredOperationsTest.assertNode(ClusteredOperationsTest.toNodeInformation(ClusteredOperationsTest.asList((List)slot.get("nodes"), i)), role);
        }
    }

    private static void assertNode(Map<String, Object> node, String role) {
        ((MapAssert)((MapAssert)((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat(node).containsKeys((Object[])new String[]{"id", "port", "endpoint", "ip", "replication-offset", "role", "health"})).containsEntry((Object)"role", (Object)role)).containsEntry((Object)"replication-offset", (Object)0L)).containsEntry((Object)"health", (Object)"online")).hasEntrySatisfying((Object)"port", port -> Assertions.assertThat((Long)((Long)port)).isGreaterThanOrEqualTo(0L))).hasEntrySatisfying((Object)"endpoint", endpoint -> Assertions.assertThat((Object)endpoint).isEqualTo(node.get("ip")));
    }

    private static List<Object> asList(List<Object> slots, int idx) {
        Object object = slots.get(idx);
        Assertions.assertThat((Object)object).isInstanceOf(List.class);
        return (List)object;
    }

    private static Map<String, Object> toNodeInformation(List<Object> values) {
        Assertions.assertThat(values).size().satisfies(new ThrowingConsumer[]{size -> Assertions.assertThat((Integer)size).isEven()});
        HashMap<String, Object> node = new HashMap<String, Object>();
        for (int i = 0; i < values.size(); i += 2) {
            node.put((String)values.get(i), values.get(i + 1));
        }
        return node;
    }
}

