/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisConnectionException;
import io.lettuce.core.RedisURI;
import io.netty.channel.Channel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.server.resp.RespSingleNodeTest;
import org.infinispan.server.resp.authentication.RespAuthenticator;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespAuthSingleNodeTest")
public class RespAuthSingleNodeTest
extends RespSingleNodeTest {
    private static final String USERNAME = "default";
    private static final String PASSWORD = "password";

    @Override
    protected RespServerConfigurationBuilder serverConfiguration(int i) {
        RespServerConfigurationBuilder builder = super.serverConfiguration(i);
        builder.authentication().enable().authenticator((RespAuthenticator)new FakeRespAuthenticator());
        return builder;
    }

    protected RedisClient createRedisClient(int port) {
        RedisURI uri = RedisURI.Builder.redis((String)"127.0.0.1", (int)port).withAuthentication(USERNAME, (CharSequence)PASSWORD).withTimeout(Duration.ofMillis(this.timeout)).build();
        return RedisClient.create((RedisURI)uri);
    }

    public void testNoAuthHello() {
        RedisURI uri = RedisURI.Builder.redis((String)"127.0.0.1", (int)this.server.getPort()).build();
        try (RedisClient noAuthClient = RedisClient.create((RedisURI)uri);){
            ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisClient)noAuthClient).connect()).isInstanceOf(RedisConnectionException.class)).cause().isInstanceOf(RedisCommandExecutionException.class)).hasMessage("NOAUTH HELLO must be called with the client already authenticated, otherwise the HELLO <proto> AUTH <user> <pass> option can be used to authenticate the client and select the RESP protocol version at the same time");
        }
    }

    @Override
    public Object[] factory() {
        return new Object[]{new RespAuthSingleNodeTest(), new RespAuthSingleNodeTest().simpleCache()};
    }

    @Override
    RespSingleNodeTest simpleCache() {
        super.simpleCache();
        return this;
    }

    public static class FakeRespAuthenticator
    implements RespAuthenticator {
        public CompletionStage<Subject> clientCertAuth(Channel channel) throws SaslException {
            return CompletableFutures.completedNull();
        }

        public CompletionStage<Subject> usernamePasswordAuth(String username, char[] password) {
            if (username.equals(RespAuthSingleNodeTest.USERNAME) && new String(password).equals(RespAuthSingleNodeTest.PASSWORD)) {
                return CompletableFuture.completedFuture(new Subject());
            }
            return CompletableFutures.completedNull();
        }

        public boolean isClientCertAuthEnabled() {
            return false;
        }
    }
}

