/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyValue;
import io.lettuce.core.LMPopArgs;
import io.lettuce.core.LMoveArgs;
import io.lettuce.core.LPosArgs;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.server.resp.CustomStringCommands;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespListCommandsTest")
public class RespListCommandsTest
extends SingleNodeRespBaseTest {
    RedisCommands<String, String> redis;

    @BeforeMethod
    public void initConnection() {
        this.redis = this.redisConnection.sync();
    }

    public void testRPUSH() {
        long result = this.redis.rpush((Object)"people", (Object[])new String[]{"tristan"});
        Assertions.assertThat((long)result).isEqualTo(1L);
        result = this.redis.rpush((Object)"people", (Object[])new String[]{"william"});
        Assertions.assertThat((long)result).isEqualTo(2L);
        result = this.redis.rpush((Object)"people", (Object[])new String[]{"william", "jose", "pedro"});
        Assertions.assertThat((long)result).isEqualTo(5L);
        Assertions.assertThat((List)this.redis.lrange((Object)"people", 0L, 4L)).containsExactly((Object[])new String[]{"tristan", "william", "william", "jose", "pedro"});
        result = this.redis.rpush((Object)"people2", (Object[])new String[]{"william", "jose", "pedro"});
        Assertions.assertThat((long)result).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.lrange((Object)"people2", 0L, -1L)).containsExactly((Object[])new String[]{"william", "jose", "pedro"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"leads", (Object)"tristan"), () -> this.redis.rpush((Object)"leads", (Object[])new String[]{"william"}));
        RespTestingUtil.assertWrongType(() -> this.redis.rpush((Object)"data", (Object[])new String[]{"e1"}), () -> this.redis.get((Object)"data"));
    }

    public void testRPUSHX() {
        long result = this.redis.rpushx((Object)"noexisting", (Object[])new String[]{"doraemon", "son goku"});
        Assertions.assertThat((long)result).isEqualTo(0L);
        result = this.redis.rpush((Object)"existing", (Object[])new String[]{"tristan"});
        Assertions.assertThat((long)result).isEqualTo(1L);
        result = this.redis.rpushx((Object)"existing", (Object[])new String[]{"william", "jose"});
        Assertions.assertThat((long)result).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.lrange((Object)"existing", 0L, 2L)).containsExactly((Object[])new String[]{"tristan", "william", "jose"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"leads", (Object)"tristan"), () -> this.redis.rpushx((Object)"leads", (Object[])new String[]{"william"}));
    }

    public void testLPUSH() {
        long result = this.redis.lpush((Object)"people", (Object[])new String[]{"tristan"});
        Assertions.assertThat((long)result).isEqualTo(1L);
        result = this.redis.lpush((Object)"people", (Object[])new String[]{"william"});
        Assertions.assertThat((long)result).isEqualTo(2L);
        result = this.redis.lpush((Object)"people", (Object[])new String[]{"william", "jose", "pedro"});
        Assertions.assertThat((long)result).isEqualTo(5L);
        Assertions.assertThat((List)this.redis.lrange((Object)"people", 0L, 4L)).containsExactly((Object[])new String[]{"pedro", "jose", "william", "william", "tristan"});
        result = this.redis.lpush((Object)"people2", (Object[])new String[]{"william", "jose", "pedro"});
        Assertions.assertThat((long)result).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.lrange((Object)"people2", 0L, -1L)).containsExactly((Object[])new String[]{"pedro", "jose", "william"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"leads", (Object)"tristan"), () -> this.redis.lpush((Object)"leads", (Object[])new String[]{"william"}));
    }

    public void testLPUSHX() {
        long result = this.redis.lpushx((Object)"noexisting", (Object[])new String[]{"doraemon", "son goku"});
        Assertions.assertThat((long)result).isEqualTo(0L);
        result = this.redis.lpush((Object)"existing", (Object[])new String[]{"tristan"});
        Assertions.assertThat((long)result).isEqualTo(1L);
        result = this.redis.lpushx((Object)"existing", (Object[])new String[]{"william", "jose"});
        Assertions.assertThat((long)result).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.lrange((Object)"existing", 0L, 2L)).containsExactly((Object[])new String[]{"jose", "william", "tristan"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"leads", (Object)"tristan"), () -> this.redis.lpushx((Object)"leads", (Object[])new String[]{"william"}));
    }

    public void testRPOP() {
        Assertions.assertThat((String)((String)this.redis.rpop((Object)"not_exist"))).isNull();
        Assertions.assertThat((Long)this.redis.rpush((Object)"leads", (Object[])new String[]{"tristan"})).isEqualTo(1L);
        Assertions.assertThat((String)((String)this.redis.rpop((Object)"leads"))).isEqualTo("tristan");
        Assertions.assertThat((String)((String)this.redis.rpop((Object)"leads"))).isNull();
        Assertions.assertThat((Long)this.redis.rpush((Object)"leads", (Object[])new String[]{"tristan", "jose", "william", "pedro"})).isEqualTo(4L);
        Assertions.assertThat((List)this.redis.rpop((Object)"leads", 0L)).isEmpty();
        Assertions.assertThat((List)this.redis.rpop((Object)"leads", 3L)).containsExactly((Object[])new String[]{"pedro", "william", "jose"});
        Assertions.assertThat((List)this.redis.rpop((Object)"leads", 1L)).containsExactly((Object[])new String[]{"tristan"});
        Assertions.assertThat((String)((String)this.redis.rpop((Object)"leads"))).isNull();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"leads", (Object)"tristan"), () -> this.redis.rpop((Object)"leads"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.rpop((Object)"leads", -42L)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR value is out of range, must be positive");
        CustomStringCommands commands = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> commands.rpopWrongArgNum("leads".getBytes(), "1".getBytes(), "2".getBytes())).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR wrong number of arguments for 'rpop' command");
    }

    public void testLPOP() {
        Assertions.assertThat((String)((String)this.redis.lpop((Object)"not_exist"))).isNull();
        Assertions.assertThat((Long)this.redis.rpush((Object)"leads", (Object[])new String[]{"tristan"})).isEqualTo(1L);
        Assertions.assertThat((String)((String)this.redis.lpop((Object)"leads"))).isEqualTo("tristan");
        Assertions.assertThat((String)((String)this.redis.lpop((Object)"leads"))).isNull();
        Assertions.assertThat((Long)this.redis.rpush((Object)"leads", (Object[])new String[]{"tristan", "jose", "william", "pedro"})).isEqualTo(4L);
        Assertions.assertThat((List)this.redis.lpop((Object)"leads", 0L)).isEmpty();
        Assertions.assertThat((List)this.redis.lpop((Object)"leads", 3L)).containsExactly((Object[])new String[]{"tristan", "jose", "william"});
        Assertions.assertThat((List)this.redis.lpop((Object)"leads", 1L)).containsExactly((Object[])new String[]{"pedro"});
        Assertions.assertThat((String)((String)this.redis.lpop((Object)"leads"))).isNull();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"leads", (Object)"tristan"), () -> this.redis.lpop((Object)"leads"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.lpop((Object)"leads", -42L)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR value is out of range, must be positive");
        CustomStringCommands commands = CustomStringCommands.instance((StatefulConnection<String, String>)this.redisConnection);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> commands.lpopWrongArgNum("leads".getBytes(), "1".getBytes(), "2".getBytes())).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR wrong number of arguments for 'lpop' command");
    }

    public void testLINDEX() {
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"noexisting", 10L))).isNull();
        this.redis.rpush((Object)"leads", (Object[])new String[]{"tristan"});
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", 0L))).isEqualTo("tristan");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -1L))).isEqualTo("tristan");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", 1L))).isNull();
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -2L))).isNull();
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio"});
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", 1L))).isEqualTo("william");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -1L))).isEqualTo("vittorio");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -6L))).isEqualTo("tristan");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", 3L))).isEqualTo("ryan");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -3L))).isEqualTo("ryan");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", 6L))).isNull();
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -7L))).isNull();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.lindex((Object)"another", 1L));
    }

    public void testLLEN() {
        Assertions.assertThat((Long)this.redis.llen((Object)"noexisting")).isEqualTo(0L);
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio"});
        Assertions.assertThat((Long)this.redis.llen((Object)"leads")).isEqualTo(5L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.llen((Object)"another"));
    }

    public void testLRANGE() {
        Assertions.assertThat((List)this.redis.lrange((Object)"noexisting", -1L, 3L)).isEmpty();
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio"});
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, 5L)).containsExactly((Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio"});
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 1L, -1L)).containsExactly((Object[])new String[]{"jose", "ryan", "pedro", "vittorio"});
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 3L, 3L)).containsExactly((Object[])new String[]{"pedro"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.llen((Object)"another"));
    }

    public void testLSET() {
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio"});
        Assertions.assertThat((String)this.redis.lset((Object)"leads", 0L, (Object)"fabio")).isEqualTo("OK");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", 0L))).isEqualTo("fabio");
        Assertions.assertThat((String)this.redis.lset((Object)"leads", -1L, (Object)"tristan")).isEqualTo("OK");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -1L))).isEqualTo("tristan");
        Assertions.assertThat((String)this.redis.lset((Object)"leads", 2L, (Object)"wolf")).isEqualTo("OK");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", 2L))).isEqualTo("wolf");
        Assertions.assertThat((String)this.redis.lset((Object)"leads", -3L, (Object)"anna")).isEqualTo("OK");
        Assertions.assertThat((String)((String)this.redis.lindex((Object)"leads", -3L))).isEqualTo("anna");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.lset((Object)"leads", 5L, (Object)"dan")).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR index out of range");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.lset((Object)"leads", -6L, (Object)"dan")).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR index out of range");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.lset((Object)"not_existing", 0L, (Object)"tristan")).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR no such key");
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.lset((Object)"another", 0L, (Object)"tristan"));
    }

    public void testLPOS() {
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio", "ryan", "michael", "ryan"});
        Assertions.assertThat((Long)this.redis.lpos((Object)"not_existing", (Object)"ryan")).isNull();
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ramona")).isNull();
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ryan")).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ryan", LPosArgs.Builder.rank((long)1L))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ryan", LPosArgs.Builder.rank((long)-1L))).isEqualTo(7L);
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ryan", LPosArgs.Builder.rank((long)-2L))).isEqualTo(5L);
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ryan", LPosArgs.Builder.rank((long)2L))).isEqualTo(5L);
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ryan", LPosArgs.Builder.maxlen((long)3L))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.lpos((Object)"leads", (Object)"ryan", LPosArgs.Builder.maxlen((long)2L))).isNull();
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 0)).containsExactly((Object[])new Long[]{2L, 5L, 7L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 1)).containsExactly((Object[])new Long[]{2L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 2)).containsExactly((Object[])new Long[]{2L, 5L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 3)).containsExactly((Object[])new Long[]{2L, 5L, 7L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 10)).containsExactly((Object[])new Long[]{2L, 5L, 7L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 0, LPosArgs.Builder.rank((long)2L))).containsExactly((Object[])new Long[]{5L, 7L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 2, LPosArgs.Builder.rank((long)-2L))).containsExactly((Object[])new Long[]{5L, 2L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ryan", 2, LPosArgs.Builder.rank((long)1L))).containsExactly((Object[])new Long[]{2L, 5L});
        Assertions.assertThat((List)this.redis.lpos((Object)"leads", (Object)"ramona", 0)).isEmpty();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.redis.lpos((Object)"leads", (Object)"ryan", LPosArgs.Builder.rank((long)0L))).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR RANK can't be zero");
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.lpos((Object)"another", (Object)"tristan"));
    }

    public void testLINSERT() {
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "jose"});
        Assertions.assertThat((Long)this.redis.linsert((Object)"not_exsiting", true, (Object)"william", (Object)"fabio")).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.linsert((Object)"leads", true, (Object)"vittorio", (Object)"fabio")).isEqualTo(-1L);
        Assertions.assertThat((Long)this.redis.linsert((Object)"leads", true, (Object)"jose", (Object)"fabio")).isEqualTo(6L);
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "fabio", "jose", "ryan", "pedro", "jose"});
        Assertions.assertThat((Long)this.redis.linsert((Object)"leads", false, (Object)"jose", (Object)"fabio")).isEqualTo(7L);
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "fabio", "jose", "fabio", "ryan", "pedro", "jose"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.linsert((Object)"another", true, (Object)"tristan", (Object)"william"));
    }

    public void testLREM() {
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "jose", "pedro", "pedro", "tristan", "pedro"});
        Assertions.assertThat((Long)this.redis.lrem((Object)"not_existing", 1L, (Object)"ramona")).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.lrem((Object)"leads", 1L, (Object)"ramona")).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.lrem((Object)"leads", 1L, (Object)"pedro")).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "jose", "ryan", "jose", "pedro", "pedro", "tristan", "pedro"});
        Assertions.assertThat((Long)this.redis.lrem((Object)"leads", -2L, (Object)"pedro")).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "jose", "ryan", "jose", "pedro", "tristan"});
        Assertions.assertThat((Long)this.redis.lrem((Object)"leads", 0L, (Object)"jose")).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "ryan", "pedro", "tristan"});
        this.redis.lrem((Object)"leads", 0L, (Object)"tristan");
        this.redis.lrem((Object)"leads", 0L, (Object)"william");
        this.redis.lrem((Object)"leads", 0L, (Object)"pedro");
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"leads"})).isEqualTo(1L);
        this.redis.lrem((Object)"leads", 0L, (Object)"ryan");
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"leads"})).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.lrem((Object)"another", 0L, (Object)"tristan"));
    }

    public void testLTRIM() {
        Assertions.assertThat((List)this.redis.lrange((Object)"noexisting", -1L, 3L)).isEmpty();
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio"});
        Assertions.assertThat((String)this.redis.ltrim((Object)"leads", 0L, 2L)).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "jose", "ryan"});
        Assertions.assertThat((String)this.redis.ltrim((Object)"leads", 1L, 1L)).isEqualTo("OK");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"jose"});
        Assertions.assertThat((String)this.redis.ltrim((Object)"leads", 1L, -1L)).isEqualTo("OK");
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"leads"})).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.ltrim((Object)"another", 0L, 2L));
    }

    public void testLMOVE() {
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "tristan", "pedro", "jose", "ryan"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"not_existing", (Object)"leads", LMoveArgs.Builder.rightRight()))).isNull();
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"leads", LMoveArgs.Builder.rightRight()))).isEqualTo("ryan");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "tristan", "pedro", "jose", "ryan"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"leads", LMoveArgs.Builder.leftLeft()))).isEqualTo("william");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "tristan", "pedro", "jose", "ryan"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"leads", LMoveArgs.Builder.leftRight()))).isEqualTo("william");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"tristan", "pedro", "jose", "ryan", "william"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"leads", LMoveArgs.Builder.rightLeft()))).isEqualTo("william");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "tristan", "pedro", "jose", "ryan"});
        this.redis.rpush((Object)"fantasy_leads", (Object[])new String[]{"doraemon", "son goku", "snape"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"fantasy_leads", LMoveArgs.Builder.rightRight()))).isEqualTo("ryan");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "tristan", "pedro", "jose"});
        Assertions.assertThat((List)this.redis.lrange((Object)"fantasy_leads", 0L, -1L)).containsExactly((Object[])new String[]{"doraemon", "son goku", "snape", "ryan"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"fantasy_leads", LMoveArgs.Builder.rightLeft()))).isEqualTo("jose");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "tristan", "pedro"});
        Assertions.assertThat((List)this.redis.lrange((Object)"fantasy_leads", 0L, -1L)).containsExactly((Object[])new String[]{"jose", "doraemon", "son goku", "snape", "ryan"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"fantasy_leads", LMoveArgs.Builder.leftRight()))).isEqualTo("william");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"tristan", "pedro"});
        Assertions.assertThat((List)this.redis.lrange((Object)"fantasy_leads", 0L, -1L)).containsExactly((Object[])new String[]{"jose", "doraemon", "son goku", "snape", "ryan", "william"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"fantasy_leads", LMoveArgs.Builder.leftLeft()))).isEqualTo("tristan");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"pedro"});
        Assertions.assertThat((List)this.redis.lrange((Object)"fantasy_leads", 0L, -1L)).containsExactly((Object[])new String[]{"tristan", "jose", "doraemon", "son goku", "snape", "ryan", "william"});
        Assertions.assertThat((String)((String)this.redis.lmove((Object)"leads", (Object)"new_leads", LMoveArgs.Builder.leftLeft()))).isEqualTo("pedro");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).isEmpty();
        Assertions.assertThat((List)this.redis.lrange((Object)"new_leads", 0L, -1L)).containsExactly((Object[])new String[]{"pedro"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.lmove((Object)"another", (Object)"another", LMoveArgs.Builder.leftRight()));
    }

    public void testRPOPLPUSH() {
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "tristan", "pedro", "jose", "ryan"});
        Assertions.assertThat((String)((String)this.redis.rpoplpush((Object)"not_existing", (Object)"leads"))).isNull();
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"william", "tristan", "pedro", "jose", "ryan"});
        Assertions.assertThat((String)((String)this.redis.rpoplpush((Object)"leads", (Object)"leads"))).isEqualTo("ryan");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"ryan", "william", "tristan", "pedro", "jose"});
        this.redis.rpush((Object)"fantasy_leads", (Object[])new String[]{"doraemon", "son goku", "snape"});
        Assertions.assertThat((String)((String)this.redis.rpoplpush((Object)"leads", (Object)"fantasy_leads"))).isEqualTo("jose");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"ryan", "william", "tristan", "pedro"});
        Assertions.assertThat((List)this.redis.lrange((Object)"fantasy_leads", 0L, -1L)).containsExactly((Object[])new String[]{"jose", "doraemon", "son goku", "snape"});
        Assertions.assertThat((String)((String)this.redis.rpoplpush((Object)"leads", (Object)"new_leads"))).isEqualTo("pedro");
        Assertions.assertThat((List)this.redis.lrange((Object)"leads", 0L, -1L)).containsExactly((Object[])new String[]{"ryan", "william", "tristan"});
        Assertions.assertThat((List)this.redis.lrange((Object)"new_leads", 0L, -1L)).containsExactly((Object[])new String[]{"pedro"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.rpoplpush((Object)"another", (Object)"another"));
    }

    @Test
    public void testLMPOP() {
        Assertions.assertThat((Object)this.redis.lmpop(LMPopArgs.Builder.left(), (Object[])new String[]{"unk1"})).isNull();
        Assertions.assertThat((Object)this.redis.lmpop(LMPopArgs.Builder.right(), (Object[])new String[]{"unk1"})).isNull();
        Assertions.assertThat((Object)this.redis.lmpop(LMPopArgs.Builder.left(), (Object[])new String[]{"unk1", "unk2", "unk3"})).isNull();
        Assertions.assertThat((Object)this.redis.lmpop(LMPopArgs.Builder.right(), (Object[])new String[]{"unk1", "unk2", "unk3"})).isNull();
        this.redis.rpush((Object)"leads", (Object[])new String[]{"william", "jose", "ryan", "pedro", "vittorio"});
        KeyValue call = this.redis.lmpop(LMPopArgs.Builder.right(), (Object[])new String[]{"unk1", "unk2", "leads"});
        Assertions.assertThat((String)((String)call.getKey())).isEqualTo("leads");
        Assertions.assertThat((List)((List)call.getValue())).containsExactly((Object[])new String[]{"vittorio"});
        call = this.redis.lmpop(LMPopArgs.Builder.left().count(2L), (Object[])new String[]{"unk1", "leads", "unk2"});
        Assertions.assertThat((String)((String)call.getKey())).isEqualTo("leads");
        Assertions.assertThat((List)((List)call.getValue())).containsExactly((Object[])new String[]{"william", "jose"});
        call = this.redis.lmpop(LMPopArgs.Builder.left().count(4L), (Object[])new String[]{"leads", "unk1", "unk2"});
        Assertions.assertThat((String)((String)call.getKey())).isEqualTo("leads");
        Assertions.assertThat((List)((List)call.getValue())).containsExactly((Object[])new String[]{"ryan", "pedro"});
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"leads"})).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.lmpop(LMPopArgs.Builder.left(), (Object[])new String[]{"another"}));
        StringCodec codec = StringCodec.UTF8;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testLMPOP$44((RedisCodec)codec)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR syntax error");
    }

    @Test
    public void testLMPOPWithLowerCase() {
        StringCodec codec = StringCodec.UTF8;
        this.redis.dispatch((ProtocolKeyword)CommandType.LMPOP, (CommandOutput)new IntegerOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).add(1L).addKey((Object)"mylist").add("left").add("count").add(1L));
    }

    private /* synthetic */ void lambda$testLMPOP$44(RedisCodec codec) throws Throwable {
        this.redis.dispatch((ProtocolKeyword)CommandType.LMPOP, (CommandOutput)new IntegerOutput(codec), new CommandArgs(codec).add(1L).addKey((Object)"mylist").add("left").add("count").add(1L).add("count").add(2L));
    }
}

