/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.resp.AbstractRespTest;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfiguration;
import org.infinispan.server.resp.test.TestSetup;
import org.testng.annotations.AfterClass;

public abstract class SingleNodeRespBaseTest
extends AbstractRespTest {
    protected RedisClient client;
    protected RespServer server;
    protected StatefulRedisConnection<String, String> redisConnection;
    private final List<StatefulRedisConnection<String, String>> connections = new ArrayList<StatefulRedisConnection<String, String>>();
    protected Cache<Object, Object> cache;

    @Override
    protected void afterSetupFinished() {
        EmbeddedCacheManager cacheManager = this.manager(0);
        this.server = this.server(0);
        this.client = (RedisClient)this.client(0);
        this.redisConnection = this.newConnection();
        this.cache = cacheManager.getCache(((RespServerConfiguration)this.server.getConfiguration()).defaultCacheName());
    }

    @Override
    protected TestSetup setup() {
        return TestSetup.singleNodeTestSetup();
    }

    protected final StatefulRedisConnection<String, String> newConnection() {
        StatefulRedisConnection conn = this.client.connect();
        this.connections.add((StatefulRedisConnection<String, String>)conn);
        return conn;
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        this.connections.forEach(StatefulConnection::close);
        super.destroy();
    }
}

