/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyValue;
import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.ZAggregateArgs;
import io.lettuce.core.ZPopArgs;
import io.lettuce.core.ZStoreArgs;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import io.lettuce.core.output.CommandOutput;
import io.lettuce.core.output.IntegerOutput;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandType;
import io.lettuce.core.protocol.ProtocolKeyword;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.SortedSetCommandsTest")
public class SortedSetCommandsTest
extends SingleNodeRespBaseTest {
    public static final String ERR_XX_AND_NX_OPTIONS_AT_THE_SAME_TIME_ARE_NOT_COMPATIBLE = "ERR XX and NX options at the same time are not compatible";
    public static final String ERR_GT_LT_AND_OR_NX_OPTIONS_AT_THE_SAME_TIME_ARE_NOT_COMPATIBLE = "ERR GT, LT, and/or NX options at the same time are not compatible";
    RedisCommands<String, String> redis;

    @BeforeMethod
    public void initConnection() {
        this.redis = this.redisConnection.sync();
    }

    public void testZADD() {
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", 10.4, (Object)"william")).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", new ScoredValue[]{ScoredValue.just((double)13.4, (Object)"tristan")})).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"tristan")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", new ScoredValue[]{ScoredValue.just((double)13.4, (Object)"jose")})).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", new ScoredValue[]{ScoredValue.just((double)13.4, (Object)"xavier")})).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)13.4, (Object)"xavier")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")})).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)13.4, (Object)"xavier"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", ZAddArgs.Builder.nx(), new ScoredValue[]{ScoredValue.just((double)0.8, (Object)"fabio"), ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan")})).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)13.4, (Object)"xavier"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", ZAddArgs.Builder.xx(), new ScoredValue[]{ScoredValue.just((double)0.8, (Object)"fabio"), ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"katia")})).isEqualTo(0L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)0.8, (Object)"fabio"), ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", ZAddArgs.Builder.gt(), new ScoredValue[]{ScoredValue.just((double)13.0, (Object)"fabio"), ScoredValue.just((double)0.5, (Object)"xavier"), ScoredValue.just((double)2.0, (Object)"katia")})).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)0.9, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)2.0, (Object)"katia"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.0, (Object)"fabio"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", ZAddArgs.Builder.lt(), new ScoredValue[]{ScoredValue.just((double)100.0, (Object)"fabio"), ScoredValue.just((double)0.3, (Object)"xavier"), ScoredValue.just((double)0.2, (Object)"vittorio")})).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)0.2, (Object)"vittorio"), ScoredValue.just((double)0.3, (Object)"xavier"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)2.0, (Object)"katia"), ScoredValue.just((double)10.4, (Object)"william"), ScoredValue.just((double)13.0, (Object)"fabio"), ScoredValue.just((double)13.4, (Object)"jose"), ScoredValue.just((double)13.4, (Object)"tristan"), ScoredValue.just((double)21.9, (Object)"marc")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zadd((Object)"another", 2.3, (Object)"tristan"));
        RespTestingUtil.assertWrongType(() -> this.redis.zadd((Object)"data", 2.3, (Object)"tristan"), () -> this.redis.get((Object)"data"));
    }

    @Test
    public void testIncompatibleArgsError() {
        StringCodec codec = StringCodec.UTF8;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testIncompatibleArgsError$4((RedisCodec)codec)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining(ERR_XX_AND_NX_OPTIONS_AT_THE_SAME_TIME_ARE_NOT_COMPATIBLE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testIncompatibleArgsError$5((RedisCodec)codec)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining(ERR_GT_LT_AND_OR_NX_OPTIONS_AT_THE_SAME_TIME_ARE_NOT_COMPATIBLE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testIncompatibleArgsError$6((RedisCodec)codec)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining(ERR_GT_LT_AND_OR_NX_OPTIONS_AT_THE_SAME_TIME_ARE_NOT_COMPATIBLE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$testIncompatibleArgsError$7((RedisCodec)codec)).isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining(ERR_GT_LT_AND_OR_NX_OPTIONS_AT_THE_SAME_TIME_ARE_NOT_COMPATIBLE);
    }

    @Test
    public void testZADDLowerCaseArg() {
        StringCodec codec = StringCodec.UTF8;
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", new Object[]{10.4, "william", 12.0, "vittorio"})).isEqualTo(2L);
        Assertions.assertThat((Long)((Long)this.redis.dispatch((ProtocolKeyword)CommandType.ZADD, (CommandOutput)new IntegerOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)"people").add("ch").add("gt").add(14.0).addValue((Object)"tristan").add(12.1).add("vittorio")))).isEqualTo(2L);
    }

    public void testZADDINCR() {
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", 30.0, (Object)"tristan")).isEqualTo(30.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)30.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", 2.0, (Object)"tristan")).isEqualTo(32.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)32.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", -4.0, (Object)"tristan")).isEqualTo(28.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)28.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.nx(), -4.0, (Object)"tristan")).isNull();
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.xx(), -4.0, (Object)"jose")).isNull();
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)28.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.nx(), -4.0, (Object)"jose")).isEqualTo(-4.0);
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.xx(), -4.0, (Object)"tristan")).isEqualTo(24.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-4.0, (Object)"jose"), ScoredValue.just((double)24.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.lt(), -4.0, (Object)"tristan")).isEqualTo(20.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-4.0, (Object)"jose"), ScoredValue.just((double)20.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.gt(), -4.0, (Object)"tristan")).isNull();
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-4.0, (Object)"jose"), ScoredValue.just((double)20.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.lt(), 4.0, (Object)"tristan")).isNull();
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-4.0, (Object)"jose"), ScoredValue.just((double)20.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.gt(), 4.0, (Object)"tristan")).isEqualTo(24.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-4.0, (Object)"jose"), ScoredValue.just((double)24.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.lt(), 2.0, (Object)"vittorio")).isEqualTo(2.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-4.0, (Object)"jose"), ScoredValue.just((double)2.0, (Object)"vittorio"), ScoredValue.just((double)24.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zaddincr((Object)"people", ZAddArgs.Builder.gt(), -10.0, (Object)"pedro")).isEqualTo(-10.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"pedro"), ScoredValue.just((double)-4.0, (Object)"jose"), ScoredValue.just((double)2.0, (Object)"vittorio"), ScoredValue.just((double)24.0, (Object)"tristan")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zaddincr((Object)"another", 2.3, (Object)"tristan"));
    }

    @Test
    public void testZADDwithLTOrGTAndUpdateOption() {
        this.redis.zadd((Object)"ztmp", new ScoredValue[]{ScoredValue.just((double)10.0, (Object)"x"), ScoredValue.just((double)20.0, (Object)"y"), ScoredValue.just((double)30.0, (Object)"z")});
        this.redis.zadd((Object)"ztmp", ZAddArgs.Builder.lt().xx().ch(), new ScoredValue[]{ScoredValue.just((double)5.0, (Object)"foo"), ScoredValue.just((double)10.0, (Object)"x"), ScoredValue.just((double)21.0, (Object)"y"), ScoredValue.just((double)29.0, (Object)"z")});
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"ztmp", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)10.0, (Object)"x"), ScoredValue.just((double)20.0, (Object)"y"), ScoredValue.just((double)29.0, (Object)"z")});
        this.redis.zadd((Object)"ztmp", new ScoredValue[]{ScoredValue.just((double)10.0, (Object)"x"), ScoredValue.just((double)20.0, (Object)"y"), ScoredValue.just((double)30.0, (Object)"z")});
        this.redis.zadd((Object)"ztmp", ZAddArgs.Builder.gt().xx().ch(), new ScoredValue[]{ScoredValue.just((double)5.0, (Object)"foo"), ScoredValue.just((double)10.0, (Object)"x"), ScoredValue.just((double)21.0, (Object)"y"), ScoredValue.just((double)30.0, (Object)"z")});
    }

    public void testZCARD() {
        Assertions.assertThat((Long)this.redis.zcard((Object)"not_existing")).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")})).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(2L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zcard((Object)"another"));
    }

    public void testZCOUNT() {
        Range unbounded = Range.unbounded();
        Assertions.assertThat((Long)this.redis.zcount((Object)"not_existing", unbounded)).isEqualTo(0L);
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(7L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", unbounded)).isEqualTo(7L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-10.0), (Range.Boundary)Range.Boundary.including((Object)21.9)))).isEqualTo(7L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-11.0), (Range.Boundary)Range.Boundary.including((Object)22.9)))).isEqualTo(7L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)1.0), (Range.Boundary)Range.Boundary.including((Object)17.0)))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)0.0), (Range.Boundary)Range.Boundary.including((Object)18.0)))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)0.0), (Range.Boundary)Range.Boundary.including((Object)18.9)))).isEqualTo(5L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18.9), (Range.Boundary)Range.Boundary.including((Object)22.0)))).isEqualTo(4L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)1.0), (Range.Boundary)Range.Boundary.including((Object)19)))).isEqualTo(4L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)1.0), (Range.Boundary)Range.Boundary.excluding((Object)19)))).isEqualTo(5L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-10.0), (Range.Boundary)Range.Boundary.excluding((Object)18.9)))).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-10.0), (Range.Boundary)Range.Boundary.excluding((Object)-10.0)))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10.0), (Range.Boundary)Range.Boundary.including((Object)-10.0)))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-10.0), (Range.Boundary)Range.Boundary.including((Object)-10.0)))).isEqualTo(1L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10.0), (Range.Boundary)Range.Boundary.excluding((Object)-10.0)))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18.9), (Range.Boundary)Range.Boundary.excluding((Object)18.9)))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18.9), (Range.Boundary)Range.Boundary.excluding((Object)18.9)))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18.9), (Range.Boundary)Range.Boundary.including((Object)18.9)))).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18.9), (Range.Boundary)Range.Boundary.including((Object)18.9)))).isEqualTo(0L);
        this.redis.zadd((Object)"manyduplicates", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)1.0, (Object)"b"), ScoredValue.just((double)1.0, (Object)"c"), ScoredValue.just((double)2.0, (Object)"d"), ScoredValue.just((double)2.0, (Object)"e"), ScoredValue.just((double)2.0, (Object)"f"), ScoredValue.just((double)2.0, (Object)"g"), ScoredValue.just((double)2.0, (Object)"h"), ScoredValue.just((double)2.0, (Object)"i"), ScoredValue.just((double)3.0, (Object)"j"), ScoredValue.just((double)3.0, (Object)"k"), ScoredValue.just((double)3.0, (Object)"l"), ScoredValue.just((double)3.0, (Object)"m"), ScoredValue.just((double)3.0, (Object)"n")});
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.including((Object)1), (Range.Boundary)Range.Boundary.including((Object)3)))).isEqualTo(14L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.excluding((Object)1), (Range.Boundary)Range.Boundary.excluding((Object)3)))).isEqualTo(6L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.including((Object)1), (Range.Boundary)Range.Boundary.excluding((Object)2)))).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.excluding((Object)1), (Range.Boundary)Range.Boundary.including((Object)2)))).isEqualTo(6L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.including((Object)1), (Range.Boundary)Range.Boundary.including((Object)1)))).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.including((Object)2), (Range.Boundary)Range.Boundary.including((Object)2)))).isEqualTo(6L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.including((Object)3), (Range.Boundary)Range.Boundary.including((Object)3)))).isEqualTo(5L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.including((Object)1.5), (Range.Boundary)Range.Boundary.excluding((Object)2.1)))).isEqualTo(6L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.excluding((Object)1), (Range.Boundary)Range.Boundary.excluding((Object)2)))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.excluding((Object)2.5), (Range.Boundary)Range.Boundary.excluding((Object)3)))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.zcount((Object)"manyduplicates", Range.from((Range.Boundary)Range.Boundary.including((Object)1), (Range.Boundary)Range.Boundary.excluding((Object)3)))).isEqualTo(9L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zcount((Object)"another", unbounded));
    }

    public void testZPOPMIN() {
        Assertions.assertThat((boolean)this.redis.zpopmin((Object)"not_existing").isEmpty()).isTrue();
        Assertions.assertThat((List)this.redis.zpopmin((Object)"not_existing", 2L)).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(7L);
        Assertions.assertThat((Object)this.redis.zpopmin((Object)"people")).isEqualTo((Object)ScoredValue.just((double)-10.0, (Object)"tristan"));
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(6L);
        Assertions.assertThat((List)this.redis.zpopmin((Object)"people", 2L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio")});
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(4L);
        this.redis.zpopmin((Object)"people", 10L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zpopmin((Object)"another"));
    }

    public void testZPOPMAX() {
        Assertions.assertThat((boolean)this.redis.zpopmax((Object)"not_existing").isEmpty()).isTrue();
        Assertions.assertThat((List)this.redis.zpopmax((Object)"not_existing", 2L)).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(7L);
        Assertions.assertThat((Object)this.redis.zpopmax((Object)"people")).isEqualTo((Object)ScoredValue.just((double)21.9, (Object)"marc"));
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(6L);
        Assertions.assertThat((List)this.redis.zpopmax((Object)"people", 2L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)18.9, (Object)"jose")});
        Assertions.assertThat((Long)this.redis.zcard((Object)"people")).isEqualTo(4L);
        this.redis.zpopmax((Object)"people", 10L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zpopmax((Object)"another"));
    }

    public void testZSCORE() {
        Assertions.assertThat((Double)this.redis.zscore((Object)"not_existing", (Object)"no_existing")).isNull();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Double)this.redis.zscore((Object)"people", (Object)"jose")).isEqualTo(18.9);
        Assertions.assertThat((Double)this.redis.zscore((Object)"people", (Object)"takolo")).isNull();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zscore((Object)"another", (Object)"tristan"));
    }

    public void testZRANGE() {
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, -1L)).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, -1L)).containsExactly((Object[])new String[]{"tristan", "ryan", "vittorio", "fabio", "jose", "katia", "marc"});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", -1L, -1L)).containsExactly((Object[])new String[]{"marc"});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", -3L, -3L)).containsExactly((Object[])new String[]{"jose"});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, 0L)).containsExactly((Object[])new String[]{"tristan"});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 3L, 3L)).containsExactly((Object[])new String[]{"fabio"});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, 100L)).containsExactly((Object[])new String[]{"tristan", "ryan", "vittorio", "fabio", "jose", "katia", "marc"});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 2L, 5L)).containsExactly((Object[])new String[]{"vittorio", "fabio", "jose", "katia"});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", -1L, 0L)).isEmpty();
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrange((Object)"another", 0L, -1L));
    }

    public void testZREVRANGE() {
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", 0L, -1L)).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", 0L, -1L)).containsExactly((Object[])new String[]{"marc", "katia", "jose", "fabio", "vittorio", "ryan", "tristan"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", 0L, 0L)).containsExactly((Object[])new String[]{"marc"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", -1L, -1L)).containsExactly((Object[])new String[]{"tristan"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", -3L, -3L)).containsExactly((Object[])new String[]{"vittorio"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", 0L, 0L)).containsExactly((Object[])new String[]{"marc"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", 3L, 3L)).containsExactly((Object[])new String[]{"fabio"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", 0L, 100L)).containsExactly((Object[])new String[]{"marc", "katia", "jose", "fabio", "vittorio", "ryan", "tristan"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", 2L, 5L)).containsExactly((Object[])new String[]{"jose", "fabio", "vittorio", "ryan"});
        Assertions.assertThat((List)this.redis.zrevrange((Object)"people", -1L, 0L)).isEmpty();
        Assertions.assertThat((List)this.redis.zrevrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)21.9, (Object)"marc"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)-10.0, (Object)"tristan")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrevrange((Object)"another", 0L, -1L));
    }

    public void testZRANGEbyScore() {
        Assertions.assertThat((List)this.redis.zrangebyscore((Object)"people", Range.unbounded())).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"joselie"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)21.9, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrangebyscore((Object)"people", Range.unbounded())).containsExactly((Object[])new String[]{"joselie", "tristan", "dan", "gustavo", "ryan", "vittorio", "adrian", "audrey", "emmanuel", "fabio", "jose", "katia", "zineb", "anna"});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.unbounded())).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"joselie"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)21.9, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.unbounded(), Limit.create((long)3L, (long)7L))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"fabio")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.including((Object)18)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"joselie"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"zineb")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.excluding((Object)18)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"joselie"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)21.9, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)21.9, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18), (Range.Boundary)Range.Boundary.including((Object)18)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"zineb")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18), (Range.Boundary)Range.Boundary.including((Object)18)))).isEmpty();
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18), (Range.Boundary)Range.Boundary.excluding((Object)18)))).isEmpty();
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18), (Range.Boundary)Range.Boundary.excluding((Object)18)))).isEmpty();
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-11), (Range.Boundary)Range.Boundary.including((Object)17.5)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"joselie"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-10), (Range.Boundary)Range.Boundary.including((Object)1)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"joselie"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.including((Object)17)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)), Limit.create((long)1L, (long)1L))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"gustavo")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)), Limit.create((long)1L, (long)0L))).isEmpty();
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)), Limit.create((long)1L, (long)-1L))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrangebyscore((Object)"another", Range.unbounded()));
    }

    public void testZREVRANGEbyScore() {
        Assertions.assertThat((List)this.redis.zrevrangebyscore((Object)"people", Range.unbounded())).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"joselie"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)21.9, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrevrangebyscore((Object)"people", Range.unbounded())).containsExactly((Object[])new String[]{"anna", "zineb", "katia", "jose", "fabio", "emmanuel", "audrey", "adrian", "vittorio", "ryan", "gustavo", "dan", "tristan", "joselie"});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.unbounded())).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)21.9, (Object)"anna"), ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)-10.0, (Object)"joselie")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.unbounded(), Limit.create((long)3L, (long)7L))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)1.0, (Object)"ryan")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.excluding((Object)18)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)-10.0, (Object)"joselie")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.including((Object)18)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"adrian"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)-10.0, (Object)"joselie")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)21.9, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)21.9, (Object)"anna"), ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"adrian")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18), (Range.Boundary)Range.Boundary.including((Object)18)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)18.0, (Object)"zineb"), ScoredValue.just((double)18.0, (Object)"katia"), ScoredValue.just((double)18.0, (Object)"jose"), ScoredValue.just((double)18.0, (Object)"fabio"), ScoredValue.just((double)18.0, (Object)"emmanuel"), ScoredValue.just((double)18.0, (Object)"audrey"), ScoredValue.just((double)18.0, (Object)"adrian")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18), (Range.Boundary)Range.Boundary.including((Object)18)))).isEmpty();
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)18), (Range.Boundary)Range.Boundary.excluding((Object)18)))).isEmpty();
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)18), (Range.Boundary)Range.Boundary.excluding((Object)18)))).isEmpty();
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-11), (Range.Boundary)Range.Boundary.including((Object)17.5)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)-10.0, (Object)"joselie")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)-10), (Range.Boundary)Range.Boundary.including((Object)1)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan"), ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)-10.0, (Object)"joselie")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.including((Object)17)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)), Limit.create((long)1L, (long)1L))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"gustavo")});
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)), Limit.create((long)1L, (long)0L))).isEmpty();
        Assertions.assertThat((List)this.redis.zrevrangebyscoreWithScores((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)-10), (Range.Boundary)Range.Boundary.excluding((Object)17)), Limit.create((long)1L, (long)-1L))).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"gustavo"), ScoredValue.just((double)1.0, (Object)"dan")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrevrangebyscore((Object)"another", Range.unbounded()));
    }

    public void testZRANGEbyLex() {
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"not_existing", Range.unbounded())).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)0.0, (Object)"antonio"), ScoredValue.just((double)0.0, (Object)"bautista"), ScoredValue.just((double)0.0, (Object)"carlos"), ScoredValue.just((double)0.0, (Object)"carmela"), ScoredValue.just((double)0.0, (Object)"carmelo"), ScoredValue.just((double)0.0, (Object)"daniel"), ScoredValue.just((double)0.0, (Object)"daniela"), ScoredValue.just((double)0.0, (Object)"debora"), ScoredValue.just((double)0.0, (Object)"ernesto"), ScoredValue.just((double)0.0, (Object)"gonzalo"), ScoredValue.just((double)0.0, (Object)"luis")});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.unbounded())).containsExactly((Object[])new String[]{"antonio", "bautista", "carlos", "carmela", "carmelo", "daniel", "daniela", "debora", "ernesto", "gonzalo", "luis"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.including((Object)"debora")))).containsExactly((Object[])new String[]{"antonio", "bautista", "carlos", "carmela", "carmelo", "daniel", "daniela", "debora"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.excluding((Object)"debora")))).containsExactly((Object[])new String[]{"antonio", "bautista", "carlos", "carmela", "carmelo", "daniel", "daniela"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"carmelo"), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new String[]{"carmelo", "daniel", "daniela", "debora", "ernesto", "gonzalo", "luis"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"carmelo"), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new String[]{"daniel", "daniela", "debora", "ernesto", "gonzalo", "luis"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"ca"), (Range.Boundary)Range.Boundary.excluding((Object)"d")))).containsExactly((Object[])new String[]{"carlos", "carmela", "carmelo"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"ca"), (Range.Boundary)Range.Boundary.excluding((Object)"de")))).containsExactly((Object[])new String[]{"carlos", "carmela", "carmelo", "daniel", "daniela"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"co"), (Range.Boundary)Range.Boundary.excluding((Object)"di")))).containsExactly((Object[])new String[]{"daniel", "daniela", "debora"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.unbounded(), Limit.create((long)2L, (long)4L))).containsExactly((Object[])new String[]{"carlos", "carmela", "carmelo", "daniel"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.unbounded(), Limit.create((long)0L, (long)0L))).isEmpty();
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.unbounded(), Limit.create((long)5L, (long)-1L))).containsExactly((Object[])new String[]{"daniel", "daniela", "debora", "ernesto", "gonzalo", "luis"});
        Assertions.assertThat((List)this.redis.zrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"ca"), (Range.Boundary)Range.Boundary.excluding((Object)"d")), Limit.create((long)1L, (long)1L))).containsExactly((Object[])new String[]{"carmela"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrangebylex((Object)"another", Range.unbounded()));
    }

    public void testZREVRANGEbyLex() {
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"not_existing", Range.unbounded())).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)0.0, (Object)"antonio"), ScoredValue.just((double)0.0, (Object)"bautista"), ScoredValue.just((double)0.0, (Object)"carlos"), ScoredValue.just((double)0.0, (Object)"carmela"), ScoredValue.just((double)0.0, (Object)"carmelo"), ScoredValue.just((double)0.0, (Object)"daniel"), ScoredValue.just((double)0.0, (Object)"daniela"), ScoredValue.just((double)0.0, (Object)"debora"), ScoredValue.just((double)0.0, (Object)"ernesto"), ScoredValue.just((double)0.0, (Object)"gonzalo"), ScoredValue.just((double)0.0, (Object)"luis")});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.unbounded())).containsExactly((Object[])new String[]{"luis", "gonzalo", "ernesto", "debora", "daniela", "daniel", "carmelo", "carmela", "carlos", "bautista", "antonio"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.including((Object)"debora")))).containsExactly((Object[])new String[]{"debora", "daniela", "daniel", "carmelo", "carmela", "carlos", "bautista", "antonio"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.excluding((Object)"debora")))).containsExactly((Object[])new String[]{"daniela", "daniel", "carmelo", "carmela", "carlos", "bautista", "antonio"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"debora"), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new String[]{"luis", "gonzalo", "ernesto", "debora"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"debora"), (Range.Boundary)Range.Boundary.unbounded()))).containsExactly((Object[])new String[]{"luis", "gonzalo", "ernesto"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"ca"), (Range.Boundary)Range.Boundary.excluding((Object)"d")))).containsExactly((Object[])new String[]{"carmelo", "carmela", "carlos"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"ca"), (Range.Boundary)Range.Boundary.excluding((Object)"de")))).containsExactly((Object[])new String[]{"daniela", "daniel", "carmelo", "carmela", "carlos"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"co"), (Range.Boundary)Range.Boundary.excluding((Object)"di")))).containsExactly((Object[])new String[]{"debora", "daniela", "daniel"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.unbounded(), Limit.create((long)2L, (long)4L))).containsExactly((Object[])new String[]{"ernesto", "debora", "daniela", "daniel"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.unbounded(), Limit.create((long)0L, (long)0L))).isEmpty();
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.unbounded(), Limit.create((long)5L, (long)-1L))).containsExactly((Object[])new String[]{"daniel", "carmelo", "carmela", "carlos", "bautista", "antonio"});
        Assertions.assertThat((List)this.redis.zrevrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"ca"), (Range.Boundary)Range.Boundary.excluding((Object)"d")), Limit.create((long)2L, (long)1L))).containsExactly((Object[])new String[]{"carlos"});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrevrangebylex((Object)"another", Range.unbounded()));
    }

    public void testZRANGESTORE() {
        Assertions.assertThat((Long)this.redis.zrangestore((Object)"npeople", (Object)"not_existing", Range.create((Object)0L, (Object)1L))).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"npeople"})).isEqualTo(0L);
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)0.0, (Object)"antonio"), ScoredValue.just((double)0.0, (Object)"bautista"), ScoredValue.just((double)0.0, (Object)"carlos"), ScoredValue.just((double)0.0, (Object)"carmela"), ScoredValue.just((double)0.0, (Object)"carmelo"), ScoredValue.just((double)0.0, (Object)"daniel"), ScoredValue.just((double)0.0, (Object)"daniela"), ScoredValue.just((double)0.0, (Object)"debora"), ScoredValue.just((double)0.0, (Object)"ernesto"), ScoredValue.just((double)0.0, (Object)"gonzalo"), ScoredValue.just((double)0.0, (Object)"luis")});
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 1L, 5L)).containsExactly((Object[])new String[]{"bautista", "carlos", "carmela", "carmelo", "daniel"});
        Assertions.assertThat((Long)this.redis.zrangestore((Object)"npeople", (Object)"people", Range.create((Object)1L, (Object)5L))).isEqualTo(5L);
        Assertions.assertThat((List)this.redis.zrange((Object)"npeople", 0L, -1L)).containsExactly((Object[])new String[]{"bautista", "carlos", "carmela", "carmelo", "daniel"});
        Assertions.assertThat((Long)this.redis.zrangestorebylex((Object)"npeople", (Object)"people", Range.create((Object)"deb", (Object)"luisa"), Limit.create((long)1L, (long)2L))).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.zrange((Object)"npeople", 0L, -1L)).containsExactly((Object[])new String[]{"ernesto", "gonzalo"});
        Assertions.assertThat((Long)this.redis.zrangestorebylex((Object)"npeople", (Object)"people", Range.create((Object)"zi", (Object)"zu"), Limit.unlimited())).isEqualTo(0L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"npeople"})).isEqualTo(0L);
        this.redis.zadd((Object)"infinipeople", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"galder"), ScoredValue.just((double)2.0, (Object)"dan"), ScoredValue.just((double)3.0, (Object)"adrian"), ScoredValue.just((double)3.5, (Object)"radim"), ScoredValue.just((double)4.0, (Object)"tristan"), ScoredValue.just((double)4.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"pedro"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)6.0, (Object)"jose"), ScoredValue.just((double)6.0, (Object)"ryan"), ScoredValue.just((double)6.0, (Object)"anna")});
        Assertions.assertThat((Long)this.redis.zrangestorebyscore((Object)"remaining", (Object)"infinipeople", Range.from((Range.Boundary)Range.Boundary.including((Object)3.4), (Range.Boundary)Range.Boundary.including((Object)6.8)), Limit.create((long)1L, (long)-1L))).isEqualTo(7L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"remaining", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)4.0, (Object)"tristan"), ScoredValue.just((double)4.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)5.0, (Object)"pedro"), ScoredValue.just((double)6.0, (Object)"anna"), ScoredValue.just((double)6.0, (Object)"jose"), ScoredValue.just((double)6.0, (Object)"ryan")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrevrangebylex((Object)"another", Range.unbounded()));
    }

    public void testZRANK() {
        Assertions.assertThat((Long)this.redis.zrank((Object)"people", (Object)"tristan")).isNull();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"galder"), ScoredValue.just((double)2.0, (Object)"dan"), ScoredValue.just((double)3.0, (Object)"adrian"), ScoredValue.just((double)3.5, (Object)"radim"), ScoredValue.just((double)4.0, (Object)"tristan"), ScoredValue.just((double)4.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"pedro"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)6.0, (Object)"jose"), ScoredValue.just((double)6.0, (Object)"ryan"), ScoredValue.just((double)6.0, (Object)"anna")});
        Assertions.assertThat((Long)this.redis.zrank((Object)"people", (Object)"ramona")).isNull();
        Assertions.assertThat((Long)this.redis.zrank((Object)"people", (Object)"tristan")).isEqualTo(4L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrank((Object)"another", (Object)"tristan"));
    }

    public void testZREVRANK() {
        Assertions.assertThat((Long)this.redis.zrevrank((Object)"people", (Object)"tristan")).isNull();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"galder"), ScoredValue.just((double)2.0, (Object)"dan"), ScoredValue.just((double)3.0, (Object)"adrian"), ScoredValue.just((double)3.5, (Object)"radim"), ScoredValue.just((double)4.0, (Object)"tristan"), ScoredValue.just((double)4.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"pedro"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)6.0, (Object)"jose"), ScoredValue.just((double)6.0, (Object)"ryan"), ScoredValue.just((double)6.0, (Object)"anna")});
        Assertions.assertThat((Long)this.redis.zrevrank((Object)"people", (Object)"ramona")).isNull();
        Assertions.assertThat((Long)this.redis.zrevrank((Object)"people", (Object)"tristan")).isEqualTo(6L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrevrank((Object)"another", (Object)"tristan"));
    }

    public void testZMSCORE() {
        List notExistingSortedSetCallResult = this.redis.zmscore((Object)"not_existing", (Object[])new String[]{"no_existing"});
        Assertions.assertThat((List)notExistingSortedSetCallResult).hasSize(1);
        Assertions.assertThat((Double)((Double)notExistingSortedSetCallResult.get(0))).isNull();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        List notExistingMemberCallResult = this.redis.zmscore((Object)"people", (Object[])new String[]{"maria", "juana"});
        Assertions.assertThat((List)notExistingMemberCallResult).hasSize(2);
        Assertions.assertThat((Double)((Double)notExistingMemberCallResult.get(0))).isNull();
        Assertions.assertThat((Double)((Double)notExistingMemberCallResult.get(1))).isNull();
        Assertions.assertThat((List)this.redis.zmscore((Object)"people", (Object[])new String[]{"jose", "juliette", "marc"})).containsExactly((Object[])new Double[]{18.9, null, 21.9});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zmscore((Object)"another", (Object[])new String[]{"tristan"}));
    }

    public void testZDIFF() {
        Assertions.assertThat((List)this.redis.zdiff((Object[])new String[]{"result", "not_existing1", "not_existing2"})).isEmpty();
        this.redis.zadd((Object)"s1", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zdiff((Object[])new String[]{"s1"})).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((List)this.redis.zdiffWithScores((Object[])new String[]{"s1"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        this.redis.zadd((Object)"s2", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)3.0, (Object)"b"), ScoredValue.just((double)7.0, (Object)"g")});
        Assertions.assertThat((List)this.redis.zdiff((Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new String[]{"c"});
        Assertions.assertThat((List)this.redis.zdiffWithScores((Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zdiffWithScores((Object[])new String[]{"s2", "s1"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)7.0, (Object)"g")});
        this.redis.zadd((Object)"s2", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)3.0, (Object)"b"), ScoredValue.just((double)7.0, (Object)"g")});
        Assertions.assertThat((List)this.redis.zdiffWithScores((Object[])new String[]{"not_existing", "s2", "s1"})).isEmpty();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zdiff((Object[])new String[]{"another"}));
    }

    public void testZDIFFSTORE() {
        Assertions.assertThat((Long)this.redis.zdiffstore((Object)"result", (Object[])new String[]{"not_existing1", "not_existing2"})).isZero();
        this.redis.zadd((Object)"s1", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        this.redis.zadd((Object)"s2", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)7.0, (Object)"g")});
        this.redis.zadd((Object)"s3", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)7.0, (Object)"g"), ScoredValue.just((double)8.0, (Object)"h")});
        Assertions.assertThat((Long)this.redis.zdiffstore((Object)"result", (Object[])new String[]{"s1", "s2", "s3"})).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"result", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zdiffstore((Object)"result", (Object[])new String[]{"s2", "s3"})).isEqualTo(0L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"result", 0L, -1L)).isEmpty();
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"result"})).isEqualTo(0L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another1", (Object)"tristan"), () -> this.redis.zdiffstore((Object)"another1", (Object[])new String[]{"s1"}));
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another2", (Object)"tristan"), () -> this.redis.zdiffstore((Object)"people", (Object[])new String[]{"another2"}));
    }

    public void testZINCRBY() {
        Assertions.assertThat((Double)this.redis.zincrby((Object)"people", 30.0, (Object)"tristan")).isEqualTo(30.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)30.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zincrby((Object)"people", 2.0, (Object)"tristan")).isEqualTo(32.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)32.0, (Object)"tristan")});
        Assertions.assertThat((Double)this.redis.zincrby((Object)"people", -4.0, (Object)"tristan")).isEqualTo(28.0);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)28.0, (Object)"tristan")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zincrby((Object)"another", 30.0, (Object)"tristan"));
    }

    public void testZUNION() {
        Assertions.assertThat((List)this.redis.zunion((Object[])new String[]{"s1"})).isEmpty();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s1", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zunion((Object[])new String[]{"s1"})).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((List)this.redis.zunionWithScores((Object[])new String[]{"s1"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zunionWithScores(ZAggregateArgs.Builder.weights((double[])new double[]{2.0}), (Object[])new String[]{"s1"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"a"), ScoredValue.just((double)4.0, (Object)"b"), ScoredValue.just((double)6.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"s2", new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"a"), ScoredValue.just((double)3.0, (Object)"b"), ScoredValue.just((double)4.0, (Object)"c"), ScoredValue.just((double)5.0, (Object)"d")})).isEqualTo(4L);
        Assertions.assertThat((List)this.redis.zunionWithScores((Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)5.0, (Object)"b"), ScoredValue.just((double)5.0, (Object)"d"), ScoredValue.just((double)7.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zunionWithScores(ZAggregateArgs.Builder.sum(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)5.0, (Object)"b"), ScoredValue.just((double)5.0, (Object)"d"), ScoredValue.just((double)7.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zunionWithScores(ZAggregateArgs.Builder.weights((double[])new double[]{3.0, 2.0}), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)7.0, (Object)"a"), ScoredValue.just((double)10.0, (Object)"d"), ScoredValue.just((double)12.0, (Object)"b"), ScoredValue.just((double)17.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zunionWithScores(ZAggregateArgs.Builder.max(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"a"), ScoredValue.just((double)3.0, (Object)"b"), ScoredValue.just((double)4.0, (Object)"c"), ScoredValue.just((double)5.0, (Object)"d")});
        Assertions.assertThat((List)this.redis.zunionWithScores(ZAggregateArgs.Builder.min(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c"), ScoredValue.just((double)5.0, (Object)"d")});
        Assertions.assertThat((List)this.redis.zunionWithScores(ZAggregateArgs.Builder.weights((double[])new double[]{3.0, 2.0}).min(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)6.0, (Object)"b"), ScoredValue.just((double)8.0, (Object)"c"), ScoredValue.just((double)10.0, (Object)"d")});
        Assertions.assertThat((List)this.redis.zunionWithScores(ZAggregateArgs.Builder.weights((double[])new double[]{3.0, 2.0}).max(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)4.0, (Object)"a"), ScoredValue.just((double)6.0, (Object)"b"), ScoredValue.just((double)9.0, (Object)"c"), ScoredValue.just((double)10.0, (Object)"d")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zunion((Object[])new String[]{"another", "people"}));
    }

    public void testZUNIONSTORE() {
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s1", (Object[])new String[]{"s1"})).isZero();
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"s1"})).isZero();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s1", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s1", (Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s1", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s2", (Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s2", ZStoreArgs.Builder.weights((double[])new double[]{3.0}), (Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)6.0, (Object)"b"), ScoredValue.just((double)9.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s3", ZStoreArgs.Builder.min(), (Object[])new String[]{"s1", "s2"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s3", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s3", ZStoreArgs.Builder.max(), (Object[])new String[]{"s1", "s2"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s3", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)6.0, (Object)"b"), ScoredValue.just((double)9.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s3", ZStoreArgs.Builder.sum(), (Object[])new String[]{"s1", "s2"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s3", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)4.0, (Object)"a"), ScoredValue.just((double)8.0, (Object)"b"), ScoredValue.just((double)12.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zadd((Object)"s3", new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"d"), ScoredValue.just((double)7.0, (Object)"f")})).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s4", (Object[])new String[]{"s1", "s2", "s3"})).isEqualTo(5L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s4", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"d"), ScoredValue.just((double)7.0, (Object)"f"), ScoredValue.just((double)8.0, (Object)"a"), ScoredValue.just((double)16.0, (Object)"b"), ScoredValue.just((double)24.0, (Object)"c")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zunionstore((Object)"another", (Object[])new String[]{"people"}));
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zunionstore((Object)"people", (Object[])new String[]{"another"}));
    }

    @Test
    public void testZUNIONSTORELowerCaseArgsAndInf() {
        StringCodec codec = StringCodec.UTF8;
        Assertions.assertThat((Long)this.redis.zunionstore((Object)"s1", (Object[])new String[]{"s1"})).isZero();
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"s1"})).isZero();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s1", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zadd((Object)"s2", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)3.0, (Object)"d")})).isEqualTo(2L);
        Assertions.assertThat((Long)((Long)this.redis.dispatch((ProtocolKeyword)CommandType.ZUNIONSTORE, (CommandOutput)new IntegerOutput((RedisCodec)codec), new CommandArgs((RedisCodec)codec).addKey((Object)"sout").add(2L).add("s1").add("s2").add("weights").add(1L).add("Inf")))).isEqualTo(4L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"sout", 0L, -1L)).containsExactlyInAnyOrder((Object[])new ScoredValue[]{ScoredValue.just((double)Double.POSITIVE_INFINITY, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c"), ScoredValue.just((double)Double.POSITIVE_INFINITY, (Object)"d")});
    }

    public void testZINTER() {
        Assertions.assertThat((List)this.redis.zinter((Object[])new String[]{"s1"})).isEmpty();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s1", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zinter((Object[])new String[]{"s1"})).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((List)this.redis.zinterWithScores((Object[])new String[]{"s1"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zinterWithScores((Object[])new String[]{"s1", "s1"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"a"), ScoredValue.just((double)4.0, (Object)"b"), ScoredValue.just((double)6.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zinterWithScores(ZAggregateArgs.Builder.weights((double[])new double[]{1.0, 2.0, 3.0}), (Object[])new String[]{"s1", "s1", "s1"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)6.0, (Object)"a"), ScoredValue.just((double)12.0, (Object)"b"), ScoredValue.just((double)18.0, (Object)"c")});
        Assertions.assertThat((List)this.redis.zinterWithScores((Object[])new String[]{"s1", "s2"})).isEmpty();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s2", new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)8.0, (Object)"b"), ScoredValue.just((double)1.0, (Object)"d")})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zinterWithScores((Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)4.0, (Object)"a"), ScoredValue.just((double)10.0, (Object)"b")});
        Assertions.assertThat((List)this.redis.zinterWithScores(ZAggregateArgs.Builder.min(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b")});
        Assertions.assertThat((List)this.redis.zinterWithScores(ZAggregateArgs.Builder.max(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)8.0, (Object)"b")});
        Assertions.assertThat((List)this.redis.zinterWithScores(ZAggregateArgs.Builder.weights((double[])new double[]{5.0, 1.0}).max(), (Object[])new String[]{"s1", "s2"})).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)5.0, (Object)"a"), ScoredValue.just((double)10.0, (Object)"b")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zinter((Object[])new String[]{"another", "people"}));
    }

    public void testZINTERSTORE() {
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s1", (Object[])new String[]{"s1"})).isZero();
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"s1"})).isZero();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s1", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s1", (Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s1", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", (Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", ZStoreArgs.Builder.weights((double[])new double[]{2.0}), (Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)2.0, (Object)"a"), ScoredValue.just((double)4.0, (Object)"b"), ScoredValue.just((double)6.0, (Object)"c")});
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", ZStoreArgs.Builder.weights((double[])new double[]{2.0}), (Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", (Object[])new String[]{"s1", "s3"})).isZero();
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"s2"})).isZero();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s3", new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)8.0, (Object)"b"), ScoredValue.just((double)1.0, (Object)"d")})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", (Object[])new String[]{"s1", "s3"})).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)4.0, (Object)"a"), ScoredValue.just((double)10.0, (Object)"b")});
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", ZStoreArgs.Builder.min(), (Object[])new String[]{"s1", "s3"})).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b")});
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", ZStoreArgs.Builder.max(), (Object[])new String[]{"s1", "s3"})).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)3.0, (Object)"a"), ScoredValue.just((double)8.0, (Object)"b")});
        Assertions.assertThat((Long)this.redis.zinterstore((Object)"s2", ZStoreArgs.Builder.weights((double[])new double[]{5.0, 1.0}).max(), (Object[])new String[]{"s1", "s3"})).isEqualTo(2L);
        Assertions.assertThat((List)this.redis.zrangeWithScores((Object)"s2", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)5.0, (Object)"a"), ScoredValue.just((double)10.0, (Object)"b")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zinterstore((Object)"another", (Object[])new String[]{"people"}));
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zinterstore((Object)"people", (Object[])new String[]{"another"}));
    }

    public void testZREM() {
        Assertions.assertThat((Long)this.redis.zrem((Object)"not_existing", (Object[])new String[]{"value"})).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zrem((Object)"people", (Object[])new String[]{"tristan", "marc", "fabio", "pedro"})).isEqualTo(3L);
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, -1L)).containsExactly((Object[])new String[]{"ryan", "vittorio", "jose", "katia"});
        Assertions.assertThat((Long)this.redis.zrem((Object)"people", (Object[])new String[]{"ryan", "vittorio", "jose", "katia"})).isEqualTo(4L);
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, -1L)).isEmpty();
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isZero();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrem((Object)"another", (Object[])new String[]{"tristan"}));
    }

    public void testZREMRANGEBYRANK() {
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"not_existing", 0L, -1L)).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"people", 0L, -1L)).isEqualTo(7L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"people", 7L, 8L)).isZero();
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"people", 2L, 6L)).isEqualTo(5L);
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"people", -3L, -3L)).isZero();
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, -1L)).containsExactly((Object[])new String[]{"tristan", "ryan"});
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"people", -3L, -2L)).isEqualTo(1L);
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, -1L)).containsExactly((Object[])new String[]{"ryan"});
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"people", 1L, 1L)).isZero();
        Assertions.assertThat((Long)this.redis.zremrangebyrank((Object)"people", -1L, -1L)).isEqualTo(1L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isZero();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zremrangebyrank((Object)"another", 0L, -1L));
    }

    public void testZREMRANGEBYSCORE() {
        Assertions.assertThat((Long)this.redis.zremrangebyscore((Object)"not_existing", Range.unbounded())).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"pedro"), ScoredValue.just((double)18.9, (Object)"juan"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zremrangebyscore((Object)"people", Range.unbounded())).isEqualTo(9L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"pedro"), ScoredValue.just((double)18.9, (Object)"juan"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zremrangebyscore((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.including((Object)18.9)))).isEqualTo(8L);
        Assertions.assertThat((List)this.redis.zrange((Object)"people", 0L, -1L)).containsExactly((Object[])new String[]{"marc"});
        Assertions.assertThat((Long)this.redis.zremrangebyscore((Object)"people", Range.create((Object)-11, (Object)22))).isEqualTo(1L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)-10.0, (Object)"tristan"), ScoredValue.just((double)1.0, (Object)"ryan"), ScoredValue.just((double)17.0, (Object)"vittorio"), ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)18.9, (Object)"jose"), ScoredValue.just((double)18.9, (Object)"pedro"), ScoredValue.just((double)18.9, (Object)"juan"), ScoredValue.just((double)18.9, (Object)"katia"), ScoredValue.just((double)21.9, (Object)"marc")});
        Assertions.assertThat((Long)this.redis.zremrangebyscore((Object)"people", Range.unbounded())).isEqualTo(9L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isZero();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zremrangebyscore((Object)"another", 0.0, 1.0));
    }

    public void testZREMRANGEBYLEX() {
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"not_existing", Range.unbounded())).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)0.0, (Object)"antonio"), ScoredValue.just((double)0.0, (Object)"bautista")});
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.unbounded())).isEqualTo(2L);
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)0.0, (Object)"antonio"), ScoredValue.just((double)0.0, (Object)"bautista"), ScoredValue.just((double)0.0, (Object)"carlos"), ScoredValue.just((double)0.0, (Object)"carmela"), ScoredValue.just((double)0.0, (Object)"carmelo"), ScoredValue.just((double)0.0, (Object)"daniel"), ScoredValue.just((double)0.0, (Object)"daniela"), ScoredValue.just((double)0.0, (Object)"debora"), ScoredValue.just((double)0.0, (Object)"ernesto"), ScoredValue.just((double)0.0, (Object)"gonzalo"), ScoredValue.just((double)0.0, (Object)"luis")});
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.excluding((Object)"carlos")))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.including((Object)"daniel")))).isEqualTo(4L);
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"debora"), (Range.Boundary)Range.Boundary.unbounded()))).isEqualTo(3L);
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)0.0, (Object)"antonio"), ScoredValue.just((double)0.0, (Object)"bautista"), ScoredValue.just((double)0.0, (Object)"carlos"), ScoredValue.just((double)0.0, (Object)"carmela"), ScoredValue.just((double)0.0, (Object)"carmelo"), ScoredValue.just((double)0.0, (Object)"daniel"), ScoredValue.just((double)0.0, (Object)"daniela"), ScoredValue.just((double)0.0, (Object)"debora"), ScoredValue.just((double)0.0, (Object)"ernesto"), ScoredValue.just((double)0.0, (Object)"gonzalo"), ScoredValue.just((double)0.0, (Object)"luis")});
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"debora"), (Range.Boundary)Range.Boundary.unbounded()))).isEqualTo(4L);
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"bau"), (Range.Boundary)Range.Boundary.including((Object)"dan")))).isEqualTo(4L);
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"bau"), (Range.Boundary)Range.Boundary.excluding((Object)"dan")))).isZero();
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"antonio"), (Range.Boundary)Range.Boundary.excluding((Object)"daniela")))).isEqualTo(1L);
        Assertions.assertThat((Long)this.redis.zremrangebylex((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"antonia"), (Range.Boundary)Range.Boundary.excluding((Object)"danielo")))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.exists((Object[])new String[]{"people"})).isZero();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zremrangebylex((Object)"another", Range.unbounded()));
    }

    public void testZINTERCARD() {
        Assertions.assertThat((Long)this.redis.zintercard((Object[])new String[]{"s1"})).isZero();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s1", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zintercard((Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zintercard((Object[])new String[]{"s1"})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zintercard((Object[])new String[]{"s1", "s2"})).isZero();
        Assertions.assertThat((Long)this.redis.zadd((Object)"s2", new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"a"), ScoredValue.just((double)2.0, (Object)"b"), ScoredValue.just((double)3.0, (Object)"c")})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zintercard((Object[])new String[]{"s1", "s2"})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zintercard(0L, (Object[])new String[]{"s1", "s2"})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zintercard(4L, (Object[])new String[]{"s1", "s2"})).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zintercard(2L, (Object[])new String[]{"s1", "s2"})).isEqualTo(2L);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zintercard((Object[])new String[]{"another"}));
    }

    public void testZRANDMEMBER() {
        Assertions.assertThat((String)((String)this.redis.zrandmember((Object)"people"))).isNull();
        Assertions.assertThat((List)this.redis.zrandmember((Object)"people", 1L)).isEmpty();
        Assertions.assertThat((List)this.redis.zrandmemberWithScores((Object)"people", 1L)).isEmpty();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"galder"), ScoredValue.just((double)2.0, (Object)"dan"), ScoredValue.just((double)3.0, (Object)"adrian"), ScoredValue.just((double)3.5, (Object)"radim"), ScoredValue.just((double)4.0, (Object)"tristan"), ScoredValue.just((double)4.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"pedro"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)6.0, (Object)"jose"), ScoredValue.just((double)6.0, (Object)"ryan"), ScoredValue.just((double)6.0, (Object)"anna")});
        Assertions.assertThat((String)((String)this.redis.zrandmember((Object)"people"))).containsAnyOf(new CharSequence[]{"galder", "dan", "adrian", "radim", "tristan", "vittorio", "pedro", "fabio", "jose", "ryan", "anna"});
        Assertions.assertThat((List)this.redis.zrandmember((Object)"people", 2L)).containsAnyOf((Object[])new String[]{"galder", "dan", "adrian", "radim", "tristan", "vittorio", "pedro", "fabio", "jose", "ryan", "anna"});
        Assertions.assertThat((List)this.redis.zrandmember((Object)"people", 11L)).containsExactlyInAnyOrder((Object[])new String[]{"galder", "dan", "adrian", "radim", "tristan", "vittorio", "pedro", "fabio", "jose", "ryan", "anna"});
        Assertions.assertThat((List)this.redis.zrandmemberWithScores((Object)"people", 11L)).containsExactlyInAnyOrder((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"galder"), ScoredValue.just((double)2.0, (Object)"dan"), ScoredValue.just((double)3.0, (Object)"adrian"), ScoredValue.just((double)3.5, (Object)"radim"), ScoredValue.just((double)4.0, (Object)"tristan"), ScoredValue.just((double)4.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"pedro"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)6.0, (Object)"jose"), ScoredValue.just((double)6.0, (Object)"ryan"), ScoredValue.just((double)6.0, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrandmember((Object)"people", 13L)).containsExactlyInAnyOrder((Object[])new String[]{"galder", "dan", "adrian", "radim", "tristan", "vittorio", "pedro", "fabio", "jose", "ryan", "anna"});
        Assertions.assertThat((List)this.redis.zrandmember((Object)"people", -20L)).hasSize(20);
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrandmember((Object)"another"));
    }

    public void testZLEXCOUNT() {
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.unbounded())).isZero();
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)0.0, (Object)"antonio"), ScoredValue.just((double)0.0, (Object)"bautista"), ScoredValue.just((double)0.0, (Object)"carlos"), ScoredValue.just((double)0.0, (Object)"carmela"), ScoredValue.just((double)0.0, (Object)"carmelo"), ScoredValue.just((double)0.0, (Object)"daniel"), ScoredValue.just((double)0.0, (Object)"daniela"), ScoredValue.just((double)0.0, (Object)"debora"), ScoredValue.just((double)0.0, (Object)"ernesto"), ScoredValue.just((double)0.0, (Object)"gonzalo"), ScoredValue.just((double)0.0, (Object)"luis")});
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.unbounded())).isEqualTo(11L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"daniel"), (Range.Boundary)Range.Boundary.unbounded()))).isEqualTo(5L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"daniel"), (Range.Boundary)Range.Boundary.unbounded()))).isEqualTo(6L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.excluding((Object)"carmela")))).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.unbounded(), (Range.Boundary)Range.Boundary.including((Object)"carmela")))).isEqualTo(4L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"bautista"), (Range.Boundary)Range.Boundary.excluding((Object)"carmela")))).isEqualTo(1L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"bautista"), (Range.Boundary)Range.Boundary.including((Object)"carmela")))).isEqualTo(3L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"bautista"), (Range.Boundary)Range.Boundary.excluding((Object)"carmela")))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"bautista"), (Range.Boundary)Range.Boundary.including((Object)"carmela")))).isEqualTo(2L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.excluding((Object)"lars"), (Range.Boundary)Range.Boundary.excluding((Object)"luna")))).isEqualTo(1L);
        Assertions.assertThat((Long)this.redis.zlexcount((Object)"people", Range.from((Range.Boundary)Range.Boundary.including((Object)"lars"), (Range.Boundary)Range.Boundary.including((Object)"lana")))).isZero();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zrandmember((Object)"another"));
    }

    public void testZSCAN() {
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"tristan"), ScoredValue.just((double)2.0, (Object)"vittorio"), ScoredValue.just((double)2.0, (Object)"pedro"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)5.0, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zscan((Object)"people").getValues()).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"tristan"), ScoredValue.just((double)2.0, (Object)"pedro"), ScoredValue.just((double)2.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"anna"), ScoredValue.just((double)5.0, (Object)"fabio")});
        Assertions.assertThat((List)this.redis.zscan((Object)"people", ScanArgs.Builder.matches((String)"tris*")).getValues()).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"tristan")});
        Assertions.assertThat((List)this.redis.zscan((Object)"people", ScanArgs.Builder.matches((String)"nonsense")).getValues()).isEmpty();
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zscan((Object)"another"));
    }

    public void testZMPOP() {
        Assertions.assertThat((Object)this.redis.zmpop(ZPopArgs.Builder.min(), (Object[])new String[]{"people"})).isEqualTo((Object)KeyValue.empty((Object)"people"));
        Assertions.assertThat((Object)this.redis.zmpop(ZPopArgs.Builder.min(), (Object[])new String[]{"people1", "people2"})).isEqualTo((Object)KeyValue.empty((Object)"people1"));
        this.redis.zadd((Object)"people2", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"galder"), ScoredValue.just((double)2.0, (Object)"dan"), ScoredValue.just((double)3.0, (Object)"adrian"), ScoredValue.just((double)3.5, (Object)"radim"), ScoredValue.just((double)4.0, (Object)"tristan"), ScoredValue.just((double)4.0, (Object)"vittorio"), ScoredValue.just((double)5.0, (Object)"pedro"), ScoredValue.just((double)5.0, (Object)"fabio"), ScoredValue.just((double)6.0, (Object)"jose"), ScoredValue.just((double)6.0, (Object)"ryan"), ScoredValue.just((double)6.0, (Object)"anna")});
        Assertions.assertThat((Object)this.redis.zmpop(ZPopArgs.Builder.min(), (Object[])new String[]{"people1", "people2"})).isEqualTo((Object)KeyValue.just((Object)"people2", (Object)ScoredValue.just((double)1.0, (Object)"galder")));
        Assertions.assertThat((Object)this.redis.zmpop(ZPopArgs.Builder.max(), (Object[])new String[]{"people1", "people2", "people3"})).isEqualTo((Object)KeyValue.just((Object)"people2", (Object)ScoredValue.just((double)6.0, (Object)"ryan")));
        this.redis.zadd((Object)"people3", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)1.0, (Object)"maria"), ScoredValue.just((double)2.0, (Object)"pepa"), ScoredValue.just((double)3.0, (Object)"josefa"), ScoredValue.just((double)6.0, (Object)"mariona")});
        KeyValue zmpopCount = this.redis.zmpop(2, ZPopArgs.Builder.max(), (Object[])new String[]{"people1", "people3", "people2"});
        Assertions.assertThat((String)((String)zmpopCount.getKey())).isEqualTo("people3");
        Assertions.assertThat((List)((List)zmpopCount.getValue())).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)6.0, (Object)"mariona"), ScoredValue.just((double)3.0, (Object)"josefa")});
        RespTestingUtil.assertWrongType(() -> this.redis.set((Object)"another", (Object)"tristan"), () -> this.redis.zmpop(ZPopArgs.Builder.min(), (Object[])new String[]{"another"}));
    }

    public void testZRANGEWithInfinity() {
        this.redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)Double.POSITIVE_INFINITY, (Object)"galder"), ScoredValue.just((double)Double.NEGATIVE_INFINITY, (Object)"anna")});
        Assertions.assertThat((List)this.redis.zrangebyscoreWithScores((Object)"people", Range.unbounded())).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)Double.NEGATIVE_INFINITY, (Object)"anna"), ScoredValue.just((double)Double.POSITIVE_INFINITY, (Object)"galder")});
    }

    private /* synthetic */ void lambda$testIncompatibleArgsError$7(RedisCodec codec) throws Throwable {
        this.redis.dispatch((ProtocolKeyword)CommandType.ZADD, (CommandOutput)new IntegerOutput(codec), new CommandArgs(codec).addKey((Object)"ztmp").add("nx").add("gt").add(10L).addValue((Object)"x"));
    }

    private /* synthetic */ void lambda$testIncompatibleArgsError$6(RedisCodec codec) throws Throwable {
        this.redis.dispatch((ProtocolKeyword)CommandType.ZADD, (CommandOutput)new IntegerOutput(codec), new CommandArgs(codec).addKey((Object)"ztmp").add("nx").add("lt").add(10L).addValue((Object)"x"));
    }

    private /* synthetic */ void lambda$testIncompatibleArgsError$5(RedisCodec codec) throws Throwable {
        this.redis.dispatch((ProtocolKeyword)CommandType.ZADD, (CommandOutput)new IntegerOutput(codec), new CommandArgs(codec).addKey((Object)"ztmp").add("lt").add("gt").add(10L).addValue((Object)"x"));
    }

    private /* synthetic */ void lambda$testIncompatibleArgsError$4(RedisCodec codec) throws Throwable {
        this.redis.dispatch((ProtocolKeyword)CommandType.ZADD, (CommandOutput)new IntegerOutput(codec), new CommandArgs(codec).addKey((Object)"ztmp").add("xx").add("nx").add(10L).addValue((Object)"x"));
    }
}

