/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.dist;

import io.lettuce.core.api.sync.RedisCommands;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.RespSingleNodeTest;
import org.infinispan.server.resp.test.TestSetup;
import org.testng.SkipException;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="dist.server.resp.RespMultiNodeTest")
public class RespMultiNodeTest
extends RespSingleNodeTest {
    private CacheMode mode;

    @Override
    public Object[] factory() {
        return new Object[]{new RespMultiNodeTest().withCacheMode(CacheMode.DIST_SYNC), new RespMultiNodeTest().withCacheMode(CacheMode.REPL_SYNC)};
    }

    protected RespMultiNodeTest withCacheMode(CacheMode mode) {
        this.mode = mode;
        return this;
    }

    @Override
    protected String parameters() {
        return "[mode=" + String.valueOf(this.mode) + "]";
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        configurationBuilder.clustering().cacheMode(this.mode);
    }

    @Override
    protected TestSetup setup() {
        return TestSetup.clusteredTestSetup(3);
    }

    @Override
    public void testClusterShardsSingleNode() {
        RedisCommands redis = this.redisConnection.sync();
        switch (this.mode) {
            case REPL_SYNC: {
                Assertions.assertThat((List)redis.clusterShards()).hasSize(3);
                break;
            }
            case DIST_SYNC: {
                Assertions.assertThat((List)redis.clusterShards()).hasSize(6);
            }
        }
    }

    @Override
    public void testClusterNodesSingleNode() {
        throw new SkipException("Not executed in clustered test");
    }
}

