/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.logging;

import io.lettuce.core.api.sync.RedisCommands;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.commons.test.skip.StringLogAppender;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.logging.RespAccessLogger;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.logging.RespAccessLoggingTest")
public class RespAccessLoggingTest
extends SingleNodeRespBaseTest {
    public static final String LOG_FORMAT = "%X{address} %X{user} [%d{dd/MMM/yyyy:HH:mm:ss Z}] \"%X{method} %m %X{protocol}\" %X{status} %X{requestSize} %X{responseSize} %X{duration}";
    StringLogAppender logAppender;
    private String testShortName;

    @Override
    protected void afterSetupFinished() {
        this.testShortName = TestResourceTracker.getCurrentTestShortName();
        this.logAppender = new StringLogAppender(RespAccessLogger.log.getName(), Level.TRACE, t -> t.getName().startsWith("non-blocking-thread-" + this.testShortName), (Layout)PatternLayout.newBuilder().withPattern(LOG_FORMAT).build());
        this.logAppender.install();
        Assertions.assertThat((boolean)RespAccessLogger.isEnabled()).isTrue();
        super.afterSetupFinished();
    }

    @Override
    @AfterClass(alwaysRun=true)
    protected void destroy() {
        this.logAppender.uninstall();
        super.destroy();
    }

    @Test
    public void testAccessLogg() {
        int i;
        int size = 10;
        RedisCommands redis = this.redisConnection.sync();
        for (i = 0; i < size; ++i) {
            redis.set((Object)("key" + i), (Object)("value" + i));
        }
        redis.info();
        redis.mget((Object[])new String[]{"key1", "key2", "key3"});
        redis.mset(Map.of("k1", "v1", "k2", "v2", "k3", "v3"));
        this.server.getTransport().stop();
        Assertions.assertThat((String)this.logAppender.getLog(0)).matches((CharSequence)"^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d*] \"HELLO /\\[] RESP\" OK \\d+ \\d+ \\d+$");
        Assertions.assertThat((String)this.logAppender.getLog(1)).matches((CharSequence)"^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d*] \"CLIENT /\\[] RESP\" OK \\d+ \\d+ \\d+$");
        Assertions.assertThat((String)this.logAppender.getLog(2)).matches((CharSequence)"^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d*] \"CLIENT /\\[] RESP\" OK \\d+ \\d+ \\d+$");
        size += 2;
        for (i = 3; i <= size; ++i) {
            String logLine = this.logAppender.getLog(i);
            Assertions.assertThat((String)logLine).matches((CharSequence)"^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d*] \"SET /\\[\\[B0x\\w+] RESP\" OK \\d+ \\d+ \\d+$");
        }
        Assertions.assertThat((String)this.logAppender.getLog(size + 1)).matches((CharSequence)"^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d*] \"INFO /\\[] RESP\" OK \\d+ 4\\d{3} \\d+$");
        Assertions.assertThat((String)this.logAppender.getLog(size + 2)).matches((CharSequence)"^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d*] \"MGET /\\[?(\\[B0x\\w+[,\\]]){3} RESP\" OK \\d+ \\d+ \\d+$");
        Assertions.assertThat((String)this.logAppender.getLog(size + 3)).matches((CharSequence)"^127\\.0\\.0\\.1 - \\[\\d+/\\w+/\\d+:\\d+:\\d+:\\d+ [+-]?\\d*] \"MSET /\\[?(\\[B0x\\w+[,\\]]){3} RESP\" OK \\d+ \\d+ \\d+$");
    }
}

