/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.types;

import java.util.ArrayList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.TransactionOperationsTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.types.TransactionMediaTypeTest")
public class TransactionMediaTypeTest
extends TransactionOperationsTest {
    private boolean simpleCache;
    private MediaType valueType;

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        if (this.simpleCache) {
            configurationBuilder.clustering().cacheMode(CacheMode.LOCAL).simpleCache(true);
        } else {
            configurationBuilder.clustering().cacheMode(this.cacheMode);
            configurationBuilder.invocationBatching().enable(true);
        }
        configurationBuilder.encoding().value().mediaType(this.valueType.toString());
    }

    private TransactionMediaTypeTest withValueType(MediaType type) {
        this.valueType = type;
        return this;
    }

    private TransactionMediaTypeTest withSimpleCache() {
        this.simpleCache = true;
        return this;
    }

    private TransactionMediaTypeTest withCacheMode(CacheMode mode) {
        this.cacheMode = mode;
        return this;
    }

    public Object[] factory() {
        MediaType[] types;
        ArrayList<TransactionMediaTypeTest> instances = new ArrayList<TransactionMediaTypeTest>();
        for (MediaType value : types = new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_PROTOSTREAM, MediaType.APPLICATION_OBJECT, MediaType.TEXT_PLAIN}) {
            instances.add(new TransactionMediaTypeTest().withValueType(value).withCacheMode(CacheMode.LOCAL));
            instances.add(new TransactionMediaTypeTest().withValueType(value).withSimpleCache());
        }
        return instances.toArray();
    }

    protected String parameters() {
        return "[simpleCache=" + this.simpleCache + ", cacheMode=" + String.valueOf(this.cacheMode) + ", value=" + String.valueOf(this.valueType) + "]";
    }
}

