/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.list.blocking;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.Util;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.list.blocking.AbstractBlockingPop;
import org.infinispan.server.resp.commands.list.blocking.PopConfiguration;

public class BLMPOP
extends AbstractBlockingPop {
    private static final byte[] LEFT = new byte[]{76, 69, 70, 84};
    private static final byte[] RIGHT = new byte[]{82, 73, 71, 72, 84};

    public BLMPOP() {
        super(-5, 0, 0, 0);
    }

    @Override
    PopConfiguration parseArguments(Resp3Handler handler, List<byte[]> arguments) {
        double timeout = ArgumentUtils.toDouble(arguments.get(0));
        if (timeout < 0.0) {
            RespErrorUtil.mustBePositive(handler.allocator(), "timeout");
            return null;
        }
        int numKeys = ArgumentUtils.toInt(arguments.get(1));
        int additionalArgs = numKeys + 2;
        List<byte[]> keys = arguments.subList(2, additionalArgs);
        boolean head = this.isHead(arguments.get(additionalArgs++));
        int count = -1;
        if (arguments.size() == additionalArgs + 2 && (count = ArgumentUtils.toInt(arguments.get(++additionalArgs))) <= 0) {
            RespErrorUtil.mustBePositive(handler.allocator(), "count");
            return null;
        }
        return new PopConfiguration(head, count == -1 ? numKeys : count, (long)(timeout * (double)Duration.ofSeconds(1L).toMillis()), keys);
    }

    private boolean isHead(byte[] bytes) {
        if (Util.isAsciiBytesEquals(LEFT, bytes)) {
            return true;
        }
        if (!Util.isAsciiBytesEquals(RIGHT, bytes)) {
            throw new IllegalArgumentException("Unknown argument: " + Arrays.toString(bytes));
        }
        return false;
    }
}

