/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.tx;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.io.ObjectInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.exts.NoStateExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.server.resp.Consumers;
import org.infinispan.server.resp.ExternalizerIds;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespErrorUtil;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.commands.TransactionResp3Command;
import org.infinispan.server.resp.filter.EventListenerKeysFilter;
import org.infinispan.server.resp.tx.RespTransactionHandler;

public class WATCH
extends RespCommand
implements Resp3Command,
TransactionResp3Command {
    public static final AdvancedExternalizer<TxEventConverterEmpty> EXTERNALIZER = new TxEventConverterEmpty.Externalizer();
    static final AttributeKey<List<TxKeysListener>> WATCHER_KEY = AttributeKey.newInstance((String)"watchers");

    public WATCH() {
        super(-2, 1, -1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        AdvancedCache<byte[], byte[]> cache = handler.cache();
        TxKeysListener listener = new TxKeysListener();
        byte[][] keys = (byte[][])arguments.toArray((T[])Util.EMPTY_BYTE_ARRAY_ARRAY);
        EventListenerKeysFilter filter = new EventListenerKeysFilter(keys);
        CompletionStage<Void> cs = cache.addListenerAsync((Object)listener, (CacheEventFilter)filter, (CacheEventConverter)new TxEventConverterEmpty()).thenAccept(ignore -> this.register(ctx, listener));
        return handler.stageToReturn(cs, ctx, Consumers.OK_BICONSUMER);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(RespTransactionHandler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        RespErrorUtil.customError("WATCH inside MULTI is not allowed", handler.allocator());
        handler.errorInTransactionContext();
        return handler.myStage();
    }

    public void register(ChannelHandlerContext ctx, TxKeysListener listener) {
        ArrayList<TxKeysListener> watchers = (ArrayList<TxKeysListener>)ctx.channel().attr(WATCHER_KEY).get();
        if (watchers == null) {
            watchers = new ArrayList<TxKeysListener>();
            ctx.channel().attr(WATCHER_KEY).set(watchers);
        }
        watchers.add(listener);
    }

    @Listener(clustered=true)
    public static class TxKeysListener {
        private final AtomicBoolean hasEvent = new AtomicBoolean(false);

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryExpired
        @CacheEntryRemoved
        public CompletionStage<Void> onEvent(CacheEntryEvent<Object, Object> ignore) {
            this.hasEvent.set(true);
            return CompletableFutures.completedNull();
        }

        public boolean hasSeenEvents() {
            return this.hasEvent.get();
        }
    }

    private static class TxEventConverterEmpty
    implements CacheEventConverter<Object, Object, Object> {
        private TxEventConverterEmpty() {
        }

        public Object convert(Object key, Object oldValue, Metadata oldMetadata, Object newValue, Metadata newMetadata, EventType eventType) {
            return null;
        }

        private static class Externalizer
        extends NoStateExternalizer<TxEventConverterEmpty> {
            private Externalizer() {
            }

            public Integer getId() {
                return ExternalizerIds.EVENT_IGNORE_VALUE_CONVERTER;
            }

            public Set<Class<? extends TxEventConverterEmpty>> getTypeClasses() {
                return Collections.singleton(TxEventConverterEmpty.class);
            }

            public TxEventConverterEmpty readObject(ObjectInput input) {
                return new TxEventConverterEmpty();
            }
        }
    }
}

