/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import org.infinispan.Cache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.test.TestResourceTracker;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.RESPHashFunctionPartitioner;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.resp.RespServer;
import org.infinispan.server.resp.configuration.RespServerConfigurationBuilder;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.AfterClass;

public abstract class BaseMultipleRespTest
extends MultipleCacheManagersTest {
    protected RedisClient client1;
    protected RedisClient client2;
    protected RespServer server1;
    protected RespServer server2;
    protected StatefulRedisConnection<String, String> redisConnection1;
    protected StatefulRedisConnection<String, String> redisConnection2;
    protected static final int timeout = 60;

    protected void createCacheManagers() {
        ConfigurationBuilder cacheBuilder = BaseMultipleRespTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        this.amendCacheConfiguration(cacheBuilder);
        cacheBuilder.encoding().key().mediaType(MediaType.APPLICATION_OCTET_STREAM).clustering().cacheMode(CacheMode.DIST_SYNC).clustering().hash().keyPartitioner((KeyPartitioner)new RESPHashFunctionPartitioner()).numSegments(256);
        this.createCluster(cacheBuilder, 2);
        this.defineRespConfiguration(cacheBuilder.build());
        this.waitForClusterToForm();
        this.server1 = RespTestingUtil.startServer((EmbeddedCacheManager)this.cacheManagers.get(0), this.serverConfiguration(0).build());
        this.server2 = RespTestingUtil.startServer((EmbeddedCacheManager)this.cacheManagers.get(1), this.serverConfiguration(1).build());
        this.client1 = RespTestingUtil.createClient(30000L, this.server1.getPort());
        this.client2 = RespTestingUtil.createClient(30000L, this.server2.getPort());
        this.redisConnection1 = this.client1.connect();
        this.redisConnection2 = this.client2.connect();
    }

    protected void defineRespConfiguration(Configuration configuration) {
        for (EmbeddedCacheManager ecm : this.managers()) {
            ecm.defineConfiguration("respCache", configuration);
        }
    }

    protected Cache<String, String> respCache(int index) {
        return this.manager(index).getCache("respCache");
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        log.debug((Object)"Test finished, close resp server");
        RespTestingUtil.killClient((AbstractRedisClient)this.client1);
        RespTestingUtil.killClient((AbstractRedisClient)this.client2);
        RespTestingUtil.killServer(this.server1);
        RespTestingUtil.killServer(this.server2);
        super.destroy();
    }

    protected RespServerConfigurationBuilder serverConfiguration(int offset) {
        String serverName = TestResourceTracker.getCurrentTestShortName();
        return (RespServerConfigurationBuilder)((RespServerConfigurationBuilder)((RespServerConfigurationBuilder)new RespServerConfigurationBuilder().name(serverName)).host("127.0.0.1")).port(RespTestingUtil.port() + offset);
    }

    protected void amendCacheConfiguration(ConfigurationBuilder builder) {
    }
}

