/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.ScoredValue;
import io.lettuce.core.ZAddArgs;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespSimpleCacheTest")
public class RespSimpleCacheTest
extends SingleNodeRespBaseTest {
    protected CacheMode cacheMode = CacheMode.LOCAL;
    protected boolean simpleCache;

    public Object[] factory() {
        return new Object[]{new RespSimpleCacheTest(), new RespSimpleCacheTest().simpleCache()};
    }

    protected RespSimpleCacheTest simpleCache() {
        this.cacheMode = CacheMode.LOCAL;
        this.simpleCache = true;
        return this;
    }

    @Override
    protected String parameters() {
        return "[simpleCache=" + this.simpleCache + ", cacheMode=" + String.valueOf(this.cacheMode) + "]";
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder builder) {
        if (this.simpleCache) {
            builder.clustering().cacheMode(CacheMode.LOCAL).simpleCache(true);
        } else {
            builder.clustering().cacheMode(this.cacheMode);
        }
    }

    public void testSetGetDelete() {
        RedisCommands redis = this.redisConnection.sync();
        redis.set((Object)"k1", (Object)"v1");
        String v = (String)redis.get((Object)"k1");
        Assertions.assertThat((String)v).isEqualTo("v1");
        redis.del((Object[])new String[]{"k1"});
        Assertions.assertThat((String)((String)redis.get((Object)"k1"))).isNull();
        Assertions.assertThat((String)((String)redis.get((Object)"something"))).isNull();
    }

    public void testHashStructureOperations() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.hdel((Object)"not-existent", (Object[])new String[]{"unknown"})).isEqualTo(0L);
        Assertions.assertThat((Map)redis.hgetall((Object)"not-existent")).isEmpty();
        Map<String, String> map = Map.of("key1", "value1", "key2", "value2", "key3", "value3");
        Assertions.assertThat((Long)redis.hset((Object)"HSET", map)).isEqualTo(3L);
        Assertions.assertThat((Long)redis.hset((Object)"HSET", Map.of("key1", "other-value1"))).isEqualTo(0L);
        Assertions.assertThat((Long)redis.hset((Object)"HSET", Map.of("key2", "other-value2", "key4", "value4"))).isEqualTo(1L);
        Assertions.assertThat((String)((String)redis.hget((Object)"HSET", (Object)"key1"))).isEqualTo("other-value1");
        Assertions.assertThat((String)((String)redis.hget((Object)"HSET", (Object)"unknown"))).isNull();
        Assertions.assertThat((String)((String)redis.hget((Object)"UNKNOWN", (Object)"unknown"))).isNull();
        Assertions.assertThat((Map)redis.hgetall((Object)"HSET")).containsAllEntriesOf(Map.of("key1", "other-value1", "key2", "other-value2", "key3", "value3", "key4", "value4"));
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"plain", (Object)"string"), () -> redis.hmset((Object)"plain", Map.of("k1", "v1")));
        RespTestingUtil.assertWrongType(() -> {}, () -> redis.hget((Object)"plain", (Object)"k1"));
    }

    public void testSortedSetOperations() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((Long)redis.zcard((Object)"not_existing")).isEqualTo(0L);
        Assertions.assertThat((Long)redis.zadd((Object)"people", ZAddArgs.Builder.ch(), new ScoredValue[]{ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")})).isEqualTo(2L);
        Assertions.assertThat((Long)redis.zcard((Object)"people")).isEqualTo(2L);
        Assertions.assertThat((List)redis.zrangeWithScores((Object)"people", 0L, -1L)).containsExactly((Object[])new ScoredValue[]{ScoredValue.just((double)18.9, (Object)"fabio"), ScoredValue.just((double)21.9, (Object)"marc")});
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"another", (Object)"tristan"), () -> redis.zcard((Object)"another"));
    }

    public void testListOperations() {
        RedisCommands redis = this.redisConnection.sync();
        long result = redis.rpush((Object)"people", (Object[])new String[]{"tristan"});
        Assertions.assertThat((long)result).isEqualTo(1L);
        result = redis.rpush((Object)"people", (Object[])new String[]{"william"});
        Assertions.assertThat((long)result).isEqualTo(2L);
        result = redis.rpush((Object)"people", (Object[])new String[]{"william", "jose", "pedro"});
        Assertions.assertThat((long)result).isEqualTo(5L);
        Assertions.assertThat((List)redis.lrange((Object)"people", 0L, 4L)).containsExactly((Object[])new String[]{"tristan", "william", "william", "jose", "pedro"});
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.rpush((Object)"leads", (Object[])new String[]{"william"}));
    }

    public void testSetOperations() {
        RedisCommands redis = this.redisConnection.sync();
        String key = "sadd";
        Long newValue = redis.sadd((Object)key, (Object[])new String[]{"1", "2", "3"});
        Assertions.assertThat((long)newValue).isEqualTo(3L);
        newValue = redis.sadd((Object)key, (Object[])new String[]{"4", "5"});
        Assertions.assertThat((long)newValue).isEqualTo(2L);
        newValue = redis.sadd((Object)key, (Object[])new String[]{"5", "6"});
        Assertions.assertThat((long)newValue).isEqualTo(1L);
        RespTestingUtil.assertWrongType(() -> redis.set((Object)"leads", (Object)"tristan"), () -> redis.sadd((Object)"leads", (Object[])new String[]{"william"}));
        RespTestingUtil.assertWrongType(() -> redis.lpush((Object)"listleads", (Object[])new String[]{"tristan"}), () -> redis.sadd((Object)"listleads", (Object[])new String[]{"william"}));
    }
}

