/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.cluster.SlotHash;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.hash.CRC16;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.RESPHashFunctionPartitioner;
import org.infinispan.server.resp.commands.cluster.SegmentSlotRelation;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.SlotDistributionTest")
public class SlotDistributionTest {
    private final KeyPartitioner partitioner = RESPHashFunctionPartitioner.instance((int)16384);
    private final CRC16 hash = CRC16.getInstance();

    @Test
    public void testRedisExample() {
        byte[] example = "123456789".getBytes(StandardCharsets.US_ASCII);
        Assertions.assertThat((int)this.hash.hash(example)).isEqualTo(12739);
        Assertions.assertThat((int)this.hash.hash(example)).isEqualTo(io.lettuce.core.codec.CRC16.crc16((byte[])example));
        for (int i = 0; i < 1000; ++i) {
            byte[] key = ("key" + i).getBytes(StandardCharsets.US_ASCII);
            Assertions.assertThat((int)this.hash.hash(key)).isEqualTo(io.lettuce.core.codec.CRC16.crc16((byte[])key));
        }
    }

    @Test
    public void testWithMod() {
        for (int i = 0; i < 1000; ++i) {
            byte[] key = ("key" + i).getBytes(StandardCharsets.US_ASCII);
            Assertions.assertThat((int)this.partitioner.getSegment((Object)key)).isEqualTo(this.hash.hash(key) % 16384);
        }
    }

    @Test(dataProvider="segments")
    public void testMappingWithLessSegments(int segmentSize) {
        SegmentSlotRelation mapper = new SegmentSlotRelation(segmentSize);
        RESPHashFunctionPartitioner partitioner = RESPHashFunctionPartitioner.instance((int)segmentSize);
        for (int i = 0; i < 1000; ++i) {
            String keyString = "key" + i;
            byte[] key = keyString.getBytes(StandardCharsets.US_ASCII);
            int h = this.hash.hash(key);
            int segment = partitioner.getSegment((Object)key);
            int slot = SlotHash.getSlot((byte[])key);
            ((AbstractIntegerAssert)Assertions.assertThat((int)mapper.hashToSlot(h)).as(keyString, new Object[0])).isEqualTo(slot);
            ((AbstractIntegerAssert)Assertions.assertThat((int)mapper.slotToSegment(slot)).as(keyString, new Object[0])).isEqualTo(segment);
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)mapper.segmentToSlots(segment)).as(keyString, new Object[0])).contains((Object[])new Integer[]{slot});
        }
    }

    @DataProvider(name="segments")
    protected Object[][] segmentsProvider() {
        ArrayList<Object[]> segments = new ArrayList<Object[]>(14);
        for (int i = 1; i <= 14; ++i) {
            segments.add(new Object[]{1 << i});
        }
        return (Object[][])segments.toArray((T[])new Object[0][]);
    }
}

