/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyValue;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.infinispan.commons.test.skip.SkipTestNG;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.TransactionOperationsTest")
public class TransactionOperationsTest
extends SingleNodeRespBaseTest {
    public Object[] factory() {
        return new Object[]{new TransactionOperationsTest(), new TransactionOperationsTest().withAuthorization()};
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        configurationBuilder.invocationBatching().enable(true);
        configurationBuilder.transaction().lockingMode(LockingMode.PESSIMISTIC);
    }

    protected String getOperationKey(int i) {
        return TestingUtil.k((int)i);
    }

    @Test
    public void testStartTxAndQueueCommands() throws Exception {
        int i;
        int numCommands = 20;
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        for (i = 0; i < numCommands; ++i) {
            Assertions.assertThat((String)redis.set((Object)("k" + i), (Object)("v" + i))).isNull();
        }
        ((IterableAssert)Assertions.assertThat((Iterable)redis.exec()).hasSize(numCommands)).allMatch("OK"::equals);
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        for (i = 0; i < numCommands; ++i) {
            Assertions.assertThat((String)((String)redis.get((Object)("k" + i)))).isEqualTo("v" + i);
        }
    }

    @Test
    public void testExecWithoutMulti() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).exec()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR EXEC without MULTI");
    }

    @Test
    public void testEmptyTransaction() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((Iterable)redis.exec()).isEmpty();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
    }

    @Test
    public void testTransactionWithError() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        String k1 = this.getOperationKey(0);
        String k2 = this.getOperationKey(1);
        redis.set((Object)k1, (Object)"v1");
        redis.hlen((Object)k1);
        redis.set((Object)k2, (Object)"v2");
        TransactionResult result = redis.exec();
        Assertions.assertThat((String)((String)result.get(0))).isEqualTo("OK");
        Assertions.assertThat((Throwable)((Throwable)result.get(1))).hasMessage("WRONGTYPE Operation against a key holding the wrong kind of value");
        Assertions.assertThat((String)((String)result.get(2))).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)((String)redis.get((Object)k1))).isEqualTo("v1");
        Assertions.assertThat((String)((String)redis.get((Object)k2))).isEqualTo("v2");
    }

    @Test
    public void testStartNestedTx() throws Exception {
        StatefulRedisConnection<String, String> multi = this.newConnection();
        RedisCommands redis = multi.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)multi.isMulti()).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).multi()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR MULTI calls can not be nested");
        multi.closeAsync().get(10L, TimeUnit.SECONDS);
    }

    @Test(enabled=false, description="redis/lettuce#3009")
    public void testWatchInMultiNotAbort() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        redis.set((Object)this.getOperationKey(0), (Object)TestingUtil.v());
        redis.set((Object)this.getOperationKey(1), (Object)TestingUtil.v((int)1));
        Assertions.assertThat((String)redis.watch((Object[])new String[]{"something"})).isNull();
        redis.set((Object)this.getOperationKey(2), (Object)TestingUtil.v((int)2));
        TransactionResult result = redis.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isFalse();
        ((IterableAssert)Assertions.assertThat((Iterable)result).hasSize(3)).allMatch("OK"::equals);
        for (int i = 0; i < 3; ++i) {
            Assertions.assertThat((String)((String)redis.get((Object)this.getOperationKey(i)))).isEqualTo(TestingUtil.v((int)i));
        }
    }

    @Test
    public void testTransactionWithWatcher() {
        RedisCommands redis = this.redisConnection.sync();
        String key = this.getOperationKey(0);
        Assertions.assertThat((String)redis.watch((Object[])new String[]{key})).isEqualTo("OK");
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)key, (Object)"value")).isNull();
        TransactionResult result = redis.exec();
        Assertions.assertThat((String)((String)result.get(0))).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("value");
    }

    @Test
    public void testWatcherCapturesChange() {
        this.testMultiWithWatcher(false);
    }

    @Test
    public void testRemovingWatcherBeforeExec() {
        this.testMultiWithWatcher(true);
    }

    private void testMultiWithWatcher(boolean unwatchBeforeExec) {
        StatefulRedisConnection<String, String> multi = this.newConnection();
        StatefulRedisConnection<String, String> outside = this.newConnection();
        RedisCommands tx = multi.sync();
        RedisCommands redis = outside.sync();
        String key = this.getOperationKey(0);
        Assertions.assertThat((String)tx.watch((Object[])new String[]{key})).isEqualTo("OK");
        Assertions.assertThat((String)redis.set((Object)key, (Object)"value-outside")).isEqualTo("OK");
        if (unwatchBeforeExec) {
            Assertions.assertThat((String)tx.unwatch()).isEqualTo("OK");
        }
        Assertions.assertThat((String)tx.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)multi.isMulti()).isTrue();
        Assertions.assertThat((boolean)outside.isMulti()).isFalse();
        Assertions.assertThat((String)tx.set((Object)key, (Object)"value-inside")).isNull();
        TransactionResult result = tx.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isEqualTo(!unwatchBeforeExec);
        Assertions.assertThat((boolean)multi.isMulti()).isFalse();
        String expected = unwatchBeforeExec ? "value-inside" : "value-outside";
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo(expected);
        Assertions.assertThat((String)((String)tx.get((Object)key))).isEqualTo(expected);
    }

    @Test
    public void testDiscardWithoutMulti() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).discard()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR DISCARD without MULTI");
    }

    @Test
    public void testDiscardingTransaction() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        String key = this.getOperationKey(0);
        Assertions.assertThat((String)redis.set((Object)key, (Object)"value")).isNull();
        Assertions.assertThat((String)redis.discard()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).exec()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("ERR EXEC without MULTI");
        Assertions.assertThat((String)((String)redis.get((Object)key))).isNull();
    }

    @Test
    public void testDiscardRemoveListeners() {
        RedisCommands redis = this.redisConnection.sync();
        String key = this.getOperationKey(0);
        Assertions.assertThat((String)redis.watch((Object[])new String[]{key})).isEqualTo("OK");
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)key, (Object)"value")).isNull();
        Assertions.assertThat((String)redis.discard()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)key, (Object)"value-inside")).isNull();
        StatefulRedisConnection<String, String> outside = this.newConnection();
        RedisCommands outsideSync = outside.sync();
        Assertions.assertThat((String)outsideSync.set((Object)key, (Object)"value-outside")).isEqualTo("OK");
        Assertions.assertThat((String)((String)outsideSync.get((Object)key))).isEqualTo("value-outside");
        outside.close();
        TransactionResult result = redis.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isFalse();
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isFalse();
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("value-inside");
    }

    public void testBlpopNotBlocking() {
        RedisCommands redis = this.redisConnection.sync();
        String key = this.getOperationKey(0);
        String v0 = TestingUtil.v();
        String v1 = TestingUtil.v((int)1);
        Assertions.assertThat((Long)redis.lpush((Object)key, (Object[])new String[]{v0, v1})).isEqualTo(2L);
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        redis.blpop(0L, (Object[])new String[]{key});
        redis.blpop(0L, (Object[])new String[]{key});
        redis.blpop(0L, (Object[])new String[]{key});
        TransactionResult result = redis.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isFalse();
        Assertions.assertThat((Iterable)result).hasSize(3);
        Assertions.assertThat((Object)result.get(0)).isInstanceOfSatisfying(KeyValue.class, kv -> {
            Assertions.assertThat((Object)kv.getKey()).isEqualTo((Object)key);
            Assertions.assertThat((Object)kv.getValue()).isEqualTo((Object)v1);
        });
        Assertions.assertThat((Object)result.get(1)).isInstanceOfSatisfying(KeyValue.class, kv -> {
            Assertions.assertThat((Object)kv.getKey()).isEqualTo((Object)key);
            Assertions.assertThat((Object)kv.getValue()).isEqualTo((Object)v0);
        });
        Assertions.assertThat((Object)result.get(2)).isNull();
    }

    public void testAbortBecauseOfError() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        Assertions.assertThat((String)redis.set((Object)TestingUtil.k(), (Object)TestingUtil.v())).isNull();
        redis.xadd((Object)TestingUtil.k((int)1), new Object[]{TestingUtil.v(), TestingUtil.v((int)1)});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((RedisCommands)redis).exec()).isInstanceOf(RedisCommandExecutionException.class)).hasMessage("EXECABORT Transaction discarded because of previous errors.");
        Assertions.assertThat((String)((String)redis.get((Object)TestingUtil.k()))).isNull();
    }

    public void testBlockingPopWithTx() throws Throwable {
        SkipTestNG.skipIf((!this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional() ? 1 : 0) != 0, (String)"Test does not have batching enabled.");
        String key = this.getOperationKey(0);
        RedisAsyncCommands async = this.newConnection().async();
        RedisCommands redis = this.redisConnection.sync();
        RedisFuture listener = async.blpop(0L, (Object[])new String[]{key});
        Assertions.assertThat((boolean)listener.isDone()).isFalse();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        redis.lpush((Object)key, (Object[])new String[]{"value"});
        Assertions.assertThat((boolean)listener.isDone()).isFalse();
        redis.del((Object[])new String[]{key});
        Assertions.assertThat((boolean)listener.isDone()).isFalse();
        TransactionResult result = redis.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isFalse();
        ((IterableAssert)Assertions.assertThat((Iterable)result).hasSize(2)).allMatch(elem -> elem.equals(1L));
        Assertions.assertThat((boolean)listener.isDone()).isFalse();
        redis.lpush((Object)key, (Object[])new String[]{"added-later"});
        TransactionOperationsTest.eventually(() -> listener.isDone());
        KeyValue kv = (KeyValue)listener.get();
        Assertions.assertThat((String)((String)kv.getKey())).isEqualTo(key);
        Assertions.assertThat((String)((String)kv.getValue())).isEqualTo("added-later");
    }

    public void testListAndStringSameKey() {
        String key = this.getOperationKey(0);
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.multi()).isEqualTo("OK");
        Assertions.assertThat((boolean)this.redisConnection.isMulti()).isTrue();
        redis.lpush((Object)key, (Object[])new String[]{"value"});
        redis.del((Object[])new String[]{key});
        redis.set((Object)key, (Object)"foo");
        TransactionResult result = redis.exec();
        Assertions.assertThat((boolean)result.wasDiscarded()).isFalse();
        ((IterableAssert)Assertions.assertThat((Iterable)result).hasSize(3)).containsExactly(new Object[]{1L, 1L, "OK"});
        Assertions.assertThat((String)((String)redis.get((Object)key))).isEqualTo("foo");
    }
}

