/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.hll;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.infinispan.server.resp.hll.HyperLogLog;
import org.infinispan.server.resp.hll.internal.CompactSet;
import org.infinispan.server.resp.hll.internal.ExplicitSet;
import org.infinispan.server.resp.hll.internal.HLLRepresentation;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.hll.HyperLogLogTest")
public class HyperLogLogTest
extends AbstractInfinispanTest {
    public void testUnderlyingSetUpdates() {
        HyperLogLog hll = new HyperLogLog();
        Assertions.assertThat((Object)hll.store()).isNull();
        for (int i = 0; i < 192; ++i) {
            Assertions.assertThat((boolean)hll.add(("hll-" + i).getBytes(StandardCharsets.US_ASCII))).isTrue();
        }
        Assertions.assertThat((Object)hll.store()).isInstanceOf(ExplicitSet.class);
        Assertions.assertThat((long)hll.cardinality()).isEqualTo(192L);
        Assertions.assertThat((boolean)hll.add("hll-192".getBytes(StandardCharsets.US_ASCII))).isTrue();
        Assertions.assertThat((Object)hll.store()).isInstanceOf(CompactSet.class);
        Assertions.assertThat((long)hll.cardinality()).isEqualTo(193L);
    }

    public void testCompactRepresentationRelativeError() {
        CompactSet hll = new CompactSet();
        long max = (long)Math.pow(10.0, 7.0);
        Assertions.assertThat((long)hll.cardinality()).isEqualTo(0L);
        int i = 1;
        while ((long)i <= max) {
            hll.set(("hll-" + i).getBytes(StandardCharsets.US_ASCII));
            long current = hll.cardinality();
            Assertions.assertThat((double)((double)(current - (long)i) / (double)i)).isBetween(Double.valueOf(-0.015), Double.valueOf(0.015));
            ++i;
        }
    }

    public void testSameElementDoesNotChangeCardinality() {
        CompactSet cs = new CompactSet();
        ExplicitSet es = new ExplicitSet();
        Assertions.assertThat((long)cs.cardinality()).isEqualTo(0L);
        Assertions.assertThat((long)es.cardinality()).isEqualTo(0L);
        byte[] value = "value".getBytes(StandardCharsets.US_ASCII);
        Assertions.assertThat((boolean)cs.set(value)).isTrue();
        Assertions.assertThat((boolean)es.set(value)).isTrue();
        Assertions.assertThat((long)cs.cardinality()).isEqualTo(1L);
        Assertions.assertThat((long)es.cardinality()).isEqualTo(1L);
        for (int i = 0; i < 1024; ++i) {
            Assertions.assertThat((boolean)cs.set(value)).isFalse();
            Assertions.assertThat((boolean)es.set(value)).isFalse();
        }
        Assertions.assertThat((long)cs.cardinality()).isEqualTo(1L);
        Assertions.assertThat((long)es.cardinality()).isEqualTo(1L);
    }

    public void testConcurrentOperationsHLL() throws Exception {
        HyperLogLog hll = new HyperLogLog();
        CyclicBarrier barrier = new CyclicBarrier(3);
        Future future1 = this.fork(() -> {
            barrier.await();
            for (int i = 0; i < 1000; ++i) {
                hll.add(("zt-" + i).getBytes(StandardCharsets.US_ASCII));
            }
        });
        Future future2 = this.fork(() -> {
            barrier.await();
            for (int i = 0; i < 1000; ++i) {
                hll.add(("tt-" + i).getBytes(StandardCharsets.US_ASCII));
            }
        });
        barrier.await();
        future1.get(10L, TimeUnit.SECONDS);
        future2.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((Object)hll.store()).isInstanceOf(CompactSet.class);
        Assertions.assertThat((long)hll.cardinality()).isEqualTo(2003L);
    }

    @Test(dataProvider="representations")
    public void testSingleThreadOperationsRepresentation(HLLRepresentation representation, long expected) {
        int i;
        Assertions.assertThat((long)representation.cardinality()).isEqualTo(0L);
        for (i = 0; i < 1000; ++i) {
            representation.set(("zt-" + i).getBytes(StandardCharsets.US_ASCII));
        }
        for (i = 0; i < 1000; ++i) {
            representation.set(("tt-" + i).getBytes(StandardCharsets.US_ASCII));
        }
        Assertions.assertThat((long)representation.cardinality()).isEqualTo(expected);
    }

    @Test(dataProvider="representations")
    public void testConcurrentOperationsRepresentation(HLLRepresentation representation, long expected) throws Exception {
        Assertions.assertThat((long)representation.cardinality()).isEqualTo(0L);
        CyclicBarrier barrier = new CyclicBarrier(3);
        Future future1 = this.fork(() -> {
            barrier.await();
            for (int i = 0; i < 1000; ++i) {
                representation.set(("zt-" + i).getBytes(StandardCharsets.US_ASCII));
            }
        });
        Future future2 = this.fork(() -> {
            barrier.await();
            for (int i = 0; i < 1000; ++i) {
                representation.set(("tt-" + i).getBytes(StandardCharsets.US_ASCII));
            }
        });
        barrier.await();
        future1.get(10L, TimeUnit.SECONDS);
        future2.get(10L, TimeUnit.SECONDS);
        Assertions.assertThat((long)representation.cardinality()).isEqualTo(expected);
    }

    @DataProvider
    protected Object[][] representations() {
        return new Object[][]{{new ExplicitSet(), 2000L}, {new CompactSet(), 2003L}};
    }
}

