/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.operation;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.infinispan.server.resp.operation.LCSOperation;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="server.resp.operation.OperationTest")
public class OperationTest {
    @Test
    public void testLcs() {
        byte[] val1 = "ohmytext".getBytes(StandardCharsets.US_ASCII);
        byte[] val2 = "mynewtext".getBytes(StandardCharsets.US_ASCII);
        LCSOperation.LCSOperationContext lcsOpts = new LCSOperation.LCSOperationContext(val1, val2, false, false, false, 0L);
        lcsOpts.lcsLength(val1, val2);
        lcsOpts.backtrack(val1, val2);
        Assertions.assertThat((byte[])lcsOpts.getResult().lcs).isEqualTo((Object)new byte[]{109, 121, 116, 101, 120, 116});
    }

    @Test
    public void testLcsMinMatch() {
        byte[] val1 = "ohmytext".getBytes(StandardCharsets.US_ASCII);
        byte[] val2 = "mynewtext".getBytes(StandardCharsets.US_ASCII);
        LCSOperation.LCSOperationContext lcsOpts = new LCSOperation.LCSOperationContext(val1, val2, false, true, false, 4L);
        lcsOpts.lcsLength(val1, val2);
        lcsOpts.backtrack(val1, val2);
        Assertions.assertThat((List)lcsOpts.getResult().idx).containsExactly((Object[])new long[][]{{4L, 7L, 5L, 8L}});
        Assertions.assertThat((int)lcsOpts.getResult().len).isEqualTo(6);
    }
}

