/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.test;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Security;
import org.infinispan.security.mappers.IdentityRoleMapper;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;

public interface TestSetup {
    public int clusterSize();

    public EmbeddedCacheManager createCacheManager(Supplier<ConfigurationBuilder> var1, Consumer<GlobalConfigurationBuilder> var2, Consumer<ConfigurationBuilder> var3);

    public static TestSetup singleNodeTestSetup() {
        return SingleNodeTestSetup.INSTANCE;
    }

    public static TestSetup clusteredTestSetup(int numNodes) {
        return new MultiNodeTestSetup(numNodes);
    }

    public static TestSetup authorizationEnabled(TestSetup delegate) {
        return new AuthorizationSetup(delegate);
    }

    public static class SingleNodeTestSetup
    implements TestSetup {
        private static final TestSetup INSTANCE = new SingleNodeTestSetup();

        private SingleNodeTestSetup() {
        }

        @Override
        public int clusterSize() {
            return 1;
        }

        @Override
        public EmbeddedCacheManager createCacheManager(Supplier<ConfigurationBuilder> base, Consumer<GlobalConfigurationBuilder> globalDecorator, Consumer<ConfigurationBuilder> decorator) {
            GlobalConfigurationBuilder globalBuilder = new GlobalConfigurationBuilder().nonClusteredDefault();
            TestCacheManagerFactory.amendGlobalConfiguration((GlobalConfigurationBuilder)globalBuilder, (TransportFlags)new TransportFlags());
            globalDecorator.accept(globalBuilder);
            ConfigurationBuilder builder = base.get();
            decorator.accept(builder);
            return TestCacheManagerFactory.newDefaultCacheManager((boolean)true, (GlobalConfigurationBuilder)globalBuilder, (ConfigurationBuilder)builder);
        }
    }

    public record MultiNodeTestSetup(int clusterSize) implements TestSetup
    {
        @Override
        public EmbeddedCacheManager createCacheManager(Supplier<ConfigurationBuilder> base, Consumer<GlobalConfigurationBuilder> globalDecorator, Consumer<ConfigurationBuilder> decorator) {
            ConfigurationBuilder builder = base.get();
            decorator.accept(builder);
            GlobalConfigurationBuilder gcb = GlobalConfigurationBuilder.defaultClusteredBuilder();
            globalDecorator.accept(gcb);
            return TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)gcb, (ConfigurationBuilder)builder);
        }
    }

    public static class AuthorizationSetup
    implements TestSetup {
        private final TestSetup delegate;

        public AuthorizationSetup(TestSetup delegate) {
            this.delegate = delegate;
        }

        @Override
        public int clusterSize() {
            return this.delegate.clusterSize();
        }

        @Override
        public EmbeddedCacheManager createCacheManager(Supplier<ConfigurationBuilder> base, Consumer<GlobalConfigurationBuilder> globalDecorator, Consumer<ConfigurationBuilder> decorator) {
            Consumer<GlobalConfigurationBuilder> wrapGlobal = builder -> {
                globalDecorator.accept((GlobalConfigurationBuilder)builder);
                this.enableAuthorization((GlobalConfigurationBuilder)builder);
            };
            return (EmbeddedCacheManager)Security.doAs((Subject)RespTestingUtil.ADMIN, () -> this.delegate.createCacheManager(base, wrapGlobal, decorator));
        }

        private void enableAuthorization(GlobalConfigurationBuilder builder) {
            GlobalAuthorizationConfigurationBuilder gcb = builder.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper());
            for (AuthorizationPermission perm : AuthorizationPermission.values()) {
                gcb.role(perm.toString()).permission(perm);
            }
        }
    }
}

