/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.util;

import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="resp.util.ArgumentUtilsTest")
public class ArgumentUtilsTest {
    public void testReadingDoubleValues() {
        double[] values;
        for (double value : values = new double[]{Double.NEGATIVE_INFINITY, Double.MIN_VALUE, -129873.2387, -0.3847823, 0.0, 0.398475783, 2349879.0, 2.983782343487832E8, Double.MAX_VALUE, Double.POSITIVE_INFINITY}) {
            byte[] bytes = Double.toString(value).getBytes(StandardCharsets.US_ASCII);
            Assertions.assertThat((double)ArgumentUtils.toDouble((byte[])bytes)).isEqualTo(value);
        }
        Assertions.assertThat((double)ArgumentUtils.toDouble((byte[])new byte[]{105, 110, 102})).isEqualTo(Double.POSITIVE_INFINITY);
        Assertions.assertThat((double)ArgumentUtils.toDouble((byte[])new byte[]{45, 105, 110, 102})).isEqualTo(Double.NEGATIVE_INFINITY);
        this.assertInvalidNumber(() -> ArgumentUtils.toDouble((byte[])" 1.0".getBytes(StandardCharsets.US_ASCII)));
        this.assertInvalidNumber(() -> ArgumentUtils.toDouble((byte[])"string".getBytes(StandardCharsets.US_ASCII)));
    }

    public void testReadingLongValues() {
        long[] values;
        for (long value : values = new long[]{Long.MIN_VALUE, -298471982737L, -1L, 0L, 1L, 9284774833948L, Long.MAX_VALUE}) {
            byte[] bytes = Long.toString(value).getBytes(StandardCharsets.US_ASCII);
            Assertions.assertThat((long)ArgumentUtils.toLong((byte[])bytes)).isEqualTo(value);
        }
        this.assertInvalidNumber(() -> ArgumentUtils.toLong((byte[])"string".getBytes(StandardCharsets.US_ASCII)));
        this.assertInvalidNumber(() -> ArgumentUtils.toLong((byte[])Double.toString(1.2398).getBytes(StandardCharsets.US_ASCII)));
        this.assertInvalidNumber(() -> ArgumentUtils.toLong((byte[])"9223372036854775808".getBytes(StandardCharsets.US_ASCII)));
        this.assertInvalidNumber(() -> ArgumentUtils.toLong((byte[])"10000000000000000000".getBytes(StandardCharsets.US_ASCII)));
        this.assertInvalidNumber(() -> ArgumentUtils.toLong((byte[])"-9223372036854775809".getBytes(StandardCharsets.US_ASCII)));
        this.assertInvalidNumber(() -> ArgumentUtils.toLong((byte[])"-10000000000000000000".getBytes(StandardCharsets.US_ASCII)));
    }

    private void assertInvalidNumber(ThrowableAssert.ThrowingCallable callable) {
        Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(NumberFormatException.class);
    }
}

