/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import io.lettuce.core.KeyValue;
import io.lettuce.core.LMPopArgs;
import io.lettuce.core.RedisCommandExecutionException;
import io.lettuce.core.RedisFuture;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.async.RedisAsyncCommands;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.server.resp.commands.list.blocking.AbstractBlockingPop;
import org.infinispan.server.resp.test.RespTestingUtil;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.resp.RespBxPOPTest")
public class RespBxPOPTest
extends SingleNodeRespBaseTest {
    private CacheMode cacheMode = CacheMode.LOCAL;
    private boolean simpleCache;
    private boolean right;

    public Object[] factory() {
        return new Object[]{new RespBxPOPTest(), new RespBxPOPTest().simpleCache(), new RespBxPOPTest().right(), new RespBxPOPTest().simpleCache().right()};
    }

    RespBxPOPTest simpleCache() {
        this.cacheMode = CacheMode.LOCAL;
        this.simpleCache = true;
        return this;
    }

    protected RespBxPOPTest right() {
        this.right = true;
        return this;
    }

    protected boolean isRight() {
        return this.right;
    }

    @Override
    protected String parameters() {
        return "[simpleCache=" + this.simpleCache + ", cacheMode=" + String.valueOf(this.cacheMode) + ", right=" + this.right + "]";
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder configurationBuilder) {
        if (this.simpleCache) {
            configurationBuilder.clustering().cacheMode(CacheMode.LOCAL).simpleCache(true);
        } else {
            configurationBuilder.clustering().cacheMode(this.cacheMode);
        }
    }

    <T> RedisFuture<T> registerListener(Supplier<RedisFuture<T>> redisOp) {
        return this.registerListener((Cache<Object, Object>)this.cache, redisOp);
    }

    protected final <T> RedisFuture<T> registerListener(Cache<Object, Object> cache, Supplier<RedisFuture<T>> redisOp) {
        Predicate<Object> p = l -> l instanceof AbstractBlockingPop.PubSubListener || l instanceof FailingListener;
        CacheNotifierImpl cni = (CacheNotifierImpl)TestingUtil.extractComponent(cache, CacheNotifier.class);
        long pre = cni.getListeners().stream().filter(p).count();
        RedisFuture rf = redisOp.get();
        RespBxPOPTest.eventually(() -> cni.getListeners().stream().filter(p).count() == pre + 1L || rf.isDone());
        return rf;
    }

    void verifyListenerUnregistered() {
        RespBxPOPTest.verifyListenerUnregistered((Cache<Object, Object>)this.cache);
    }

    static void verifyListenerUnregistered(Cache<Object, Object> cache) {
        CacheNotifierImpl cni = (CacheNotifierImpl)TestingUtil.extractComponent(cache, CacheNotifier.class);
        RespBxPOPTest.eventually(() -> cni.getListeners().stream().noneMatch(l -> l instanceof AbstractBlockingPop.PubSubListener || l instanceof FailingListener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpop() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        try {
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "keyZ"));
            redis.lpush((Object)"keyZ", (Object[])new String[]{"firstZ", "secondZ"});
            KeyValue<String, String> res = (KeyValue<String, String>)cf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("keyZ");
            String expectPop = this.isRight() ? "firstZ" : "secondZ";
            String expectRemain = this.isRight() ? "secondZ" : "firstZ";
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo(expectPop);
            Assertions.assertThat((List)redis.lrange((Object)"keyZ", 0L, -1L)).containsExactly((Object[])new String[]{expectRemain});
            Object[] values = new String[]{"first", "second", "third"};
            redis.rpush((Object)"key1", values);
            res = this.bxPop(0L, "key1");
            String expectPop1 = this.isRight() ? "third" : "first";
            Object[] remaining = (String[])Arrays.stream(values).filter(arg -> arg != expectPop1).toArray(String[]::new);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo(expectPop1);
            Assertions.assertThat((List)redis.lrange((Object)"key1", 0L, -1L)).containsExactlyInAnyOrder(remaining);
            res = this.bxPop(0L, "key2", "key1");
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo("second");
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxPopMultipleListenersTwoKeysTwoEvents() throws InterruptedException, ExecutionException, TimeoutException {
        try {
            RedisCommands redis = this.redisConnection.sync();
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            RedisFuture cf3 = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            if (this.isRight()) {
                redis.lpush((Object)"key1", (Object[])new String[]{"value1a", "value1b"});
                redis.lpush((Object)"key2", (Object[])new String[]{"value2a", "value2b"});
            } else {
                redis.rpush((Object)"key1", (Object[])new String[]{"value1a", "value1b"});
                redis.rpush((Object)"key2", (Object[])new String[]{"value2a", "value2b"});
            }
            List<KeyValue> events = List.of((KeyValue)cf.get(10L, TimeUnit.SECONDS), (KeyValue)cf2.get(10L, TimeUnit.SECONDS), (KeyValue)cf3.get(10L, TimeUnit.SECONDS));
            ((ListAssert)Assertions.assertThat(events).hasSize(3)).containsExactlyInAnyOrder((Object[])new KeyValue[]{KeyValue.just((Object)"key1", (Object)"value1a"), KeyValue.just((Object)"key1", (Object)"value1b"), KeyValue.just((Object)"key2", (Object)"value2a")});
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxPopTwoListenersWithValues() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        try {
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(0L, "key"));
            if (this.isRight()) {
                redis.lpush((Object)"key", (Object[])new String[]{"first", "second", "third"});
            } else {
                redis.rpush((Object)"key", (Object[])new String[]{"first", "second", "third"});
            }
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key");
            Assertions.assertThat((String)((String)res2.getKey())).isEqualTo("key");
            Assertions.assertThat((List)redis.lrange((Object)"key", 0L, -1L)).containsExactly((Object[])new String[]{"third"});
            Assertions.assertThat(Arrays.asList((String)res.getValue(), (String)res2.getValue())).containsExactlyInAnyOrder((Object[])new String[]{"first", "second"});
            Assertions.assertThat((List)redis.lrange((Object)"key", 0L, -1L)).containsExactly((Object[])new String[]{"third"});
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoKeys() throws InterruptedException, ExecutionException, TimeoutException {
        try {
            RedisCommands redis = this.redisConnection.sync();
            Object[] data = new String[]{"value1a", "value1b"};
            redis.rpush((Object)"key1", data);
            redis.rpush((Object)"key2", (Object[])new String[]{"value2a", "value2b"});
            RedisFuture<KeyValue<String, String>> cf = this.bxPopAsync(0L, "key1", "key2");
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo(this.head((String[])data));
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoKeysOneEvent() throws InterruptedException, ExecutionException, TimeoutException {
        try {
            RedisCommands redis = this.redisConnection.sync();
            String[] data = new String[]{"value2a", "value2b"};
            redis.rpush((Object)"key2", (Object[])new String[]{"value2a", "value2b"});
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            redis.rpush((Object)"key1", (Object[])new String[]{"value1a", "value1b"});
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key2");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo(this.head(data));
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoKeysTwoEvents() throws InterruptedException, ExecutionException, TimeoutException {
        try {
            Object[] data = new String[]{"value1a", "value1b"};
            RedisCommands redis = this.redisConnection.sync();
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            redis.rpush((Object)"key1", data);
            redis.rpush((Object)"key2", (Object[])new String[]{"value2a", "value2b"});
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo(this.head((String[])data));
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoListenersTwoKeys() throws InterruptedException, ExecutionException, TimeoutException {
        try {
            Object[] data = new String[]{"value1a", "value1b"};
            RedisCommands redis = this.redisConnection.sync();
            redis.rpush((Object)"key1", data);
            redis.rpush((Object)"key2", (Object[])new String[]{"value2a", "value2b"});
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo(this.head((String[])data));
            Assertions.assertThat((String)((String)res2.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res2.getValue())).isEqualTo(this.fromHead((String[])data, 1));
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoListenersTwoKeys2() throws InterruptedException, ExecutionException, TimeoutException {
        try {
            Object[] data = new String[]{"value2a", "value2b"};
            RedisCommands redis = this.redisConnection.sync();
            redis.rpush((Object)"key1", (Object[])new String[]{"value1a"});
            redis.rpush((Object)"key2", data);
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo("value1a");
            Assertions.assertThat((String)((String)res2.getKey())).isEqualTo("key2");
            Assertions.assertThat((String)((String)res2.getValue())).isEqualTo(this.head((String[])data));
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoListenersTwoKeysOneEvent() throws Exception {
        try {
            Object[] data = new String[]{"value2a", "value2b"};
            RedisCommands redis = this.redisConnection.sync();
            redis.rpush((Object)"key1", (Object[])new String[]{"value1a"});
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(0L, "key1", "key2"));
            redis.rpush((Object)"key2", data);
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key1");
            Assertions.assertThat((String)((String)res.getValue())).isEqualTo("value1a");
            Assertions.assertThat((String)((String)res2.getKey())).isEqualTo("key2");
            Assertions.assertThat((String)((String)res2.getValue())).isEqualTo(this.head((String[])data));
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoListenersOneTimeout() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        try {
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(5L, "key"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(5L, "key"));
            redis.lpush((Object)"key", (Object[])new String[]{"first"});
            KeyValue res = (KeyValue)cf.get(15L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(15L, TimeUnit.SECONDS);
            KeyValue completed = res != null ? res : res2;
            Assertions.assertThat((Object)completed).isNotNull();
            Assertions.assertThat((String)((String)completed.getKey())).isEqualTo("key");
            Assertions.assertThat((String)((String)completed.getValue())).isEqualTo("first");
            Assertions.assertThat((res == null || res2 == null ? 1 : 0) != 0).isTrue();
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTwoListenersTwoProducers() throws Exception {
        RedisCommands redis1 = this.redisConnection.sync();
        RedisCommands redis2 = this.redisConnection.sync();
        try {
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "key"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(0L, "key"));
            this.fork(() -> redis1.lpush((Object)"key", (Object[])new String[]{"first"}));
            this.fork(() -> redis2.lpush((Object)"key", (Object[])new String[]{"second", "third"}));
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res.getKey())).isEqualTo("key");
            Assertions.assertThat((String)((String)res2.getKey())).isEqualTo("key");
            List rest = redis1.lrange((Object)"key", 0L, -1L);
            Assertions.assertThat((int)rest.size()).isEqualTo(1);
            Assertions.assertThat(Arrays.asList((String)res.getValue(), (String)res2.getValue(), (String)rest.get(0))).containsExactlyInAnyOrder((Object[])new String[]{"first", "second", "third"});
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopThreeListenersOneTimesOutTwoProducers() throws Exception {
        RedisCommands redis1 = this.redisConnection.sync();
        RedisCommands redis2 = this.redisConnection.sync();
        try {
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(3L, "key"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(3L, "key"));
            RedisFuture cf3 = this.registerListener(() -> this.bxPopAsync(3L, "key"));
            this.fork(() -> redis1.lpush((Object)"key", (Object[])new String[]{"first"}));
            this.fork(() -> redis2.lpush((Object)"key", (Object[])new String[]{"second"}));
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(10L, TimeUnit.SECONDS);
            KeyValue res3 = (KeyValue)cf3.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat(Arrays.asList(this.extractValue((KeyValue<String, String>)res), this.extractValue((KeyValue<String, String>)res2), this.extractValue((KeyValue<String, String>)res3))).containsExactlyInAnyOrder((Object[])new String[]{"first", "second", null});
            Assertions.assertThat((List)redis1.lrange((Object)"key", 0L, -1L)).isEmpty();
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopThreeListenersTwoProducers() throws Exception {
        RedisCommands redis1 = this.redisConnection.sync();
        RedisCommands redis2 = this.redisConnection.sync();
        try {
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(10L, "key"));
            RedisFuture cf2 = this.registerListener(() -> this.bxPopAsync(10L, "key"));
            RedisFuture cf3 = this.registerListener(() -> this.bxPopAsync(10L, "key"));
            this.fork(() -> this.xPush((RedisCommands<String, String>)redis1, "key", "first"));
            this.fork(() -> this.xPush((RedisCommands<String, String>)redis2, "key", "second", "third", "fourth"));
            KeyValue res = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)cf2.get(10L, TimeUnit.SECONDS);
            KeyValue res3 = (KeyValue)cf3.get(10L, TimeUnit.SECONDS);
            List<String> results = Arrays.asList((String)res.getValue(), (String)res2.getValue(), (String)res3.getValue());
            results.sort(null);
            List<String> expected1 = Arrays.asList("first", "fourth", "third");
            List<String> expected2 = Arrays.asList("fourth", "second", "third");
            Assertions.assertThat((int)results.size()).isEqualTo(3);
            Assertions.assertThat((results.containsAll(expected1) || results.containsAll(expected2) ? 1 : 0) != 0).isTrue();
            List rest = redis1.lrange((Object)"key", 0L, -1L);
            Assertions.assertThat((int)rest.size()).isEqualTo(1);
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopTimeout() throws InterruptedException, ExecutionException {
        RedisCommands redis = this.redisConnection.sync();
        RedisAsyncCommands redisAsync = this.newConnection().async();
        redis.rpush((Object)"key1", (Object[])new String[]{"first", "second", "third"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.bxPopAsync(-1L, "keyZ").get(10L, TimeUnit.SECONDS)).cause().isInstanceOf(RedisCommandExecutionException.class)).hasMessageContaining("ERR value is out of range, must be positive");
        RedisFuture<KeyValue<String, String>> res = this.bxPopAsync(1L, "keyZ");
        RespBxPOPTest.eventually(() -> res.isDone());
        redis.lpush((Object)"keyZ", (Object[])new String[]{"firstZ"});
        Assertions.assertThat((Object)((KeyValue)res.get())).isNull();
        try {
            RedisFuture cf = this.registerListener(() -> redisAsync.brpop(0L, (Object[])new String[]{"keyY"}));
            redis.lpush((Object)"keyY", (Object[])new String[]{"valueY"});
            Assertions.assertThat((String)((String)((KeyValue)cf.get()).getKey())).isEqualTo("keyY");
            Assertions.assertThat((String)((String)((KeyValue)cf.get()).getValue())).isEqualTo("valueY");
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    private String extractValue(KeyValue<String, String> kv) {
        return kv == null ? null : (String)kv.getValue();
    }

    private RedisFuture<KeyValue<String, String>> bxPopAsync(long to, String ... keys) {
        RedisAsyncCommands redisAsync = this.newConnection().async();
        return this.registerListener(() -> this.right ? redisAsync.brpop(to, (Object[])keys) : redisAsync.blpop(to, (Object[])keys));
    }

    private RedisFuture<KeyValue<String, List<String>>> blmpop(long timeout, int count, String ... keys) {
        RedisAsyncCommands async = this.newConnection().async();
        LMPopArgs args = (this.right ? LMPopArgs.Builder.right() : LMPopArgs.Builder.left()).count((long)count);
        return this.registerListener(() -> async.blmpop(timeout, args, (Object[])keys));
    }

    private KeyValue<String, String> bxPop(long to, String ... keys) {
        RedisCommands redis = this.newConnection().sync();
        return this.right ? redis.brpop(to, (Object[])keys) : redis.blpop(to, (Object[])keys);
    }

    private Long xPush(RedisCommands<String, String> redis, String key, String ... values) {
        return this.right ? redis.rpush((Object)key, (Object[])values) : redis.lpush((Object)key, (Object[])values);
    }

    String head(String[] a) {
        if (this.right) {
            return a[a.length - 1];
        }
        return a[0];
    }

    String fromHead(String[] a, int c) {
        if (this.right) {
            return a[a.length - c - 1];
        }
        return a[c];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBxpopAsync() throws InterruptedException, ExecutionException, TimeoutException {
        RedisCommands redis = this.redisConnection.sync();
        redis.lpush((Object)"keyY", (Object[])new String[]{"firstY"});
        try {
            RedisFuture cf = this.registerListener(() -> this.bxPopAsync(0L, "keyZ"));
            redis.lpush((Object)"keyZ", (Object[])new String[]{"firstZ"});
            KeyValue response = (KeyValue)cf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)response.getKey())).isEqualTo("keyZ");
            Assertions.assertThat((String)((String)response.getValue())).isEqualTo("firstZ");
            Assertions.assertThat((String)((String)redis.lpop((Object)"keyZ"))).isNull();
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBLMPOP() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        String key = "key-blmpop";
        redis.lpush((Object)key, (Object[])new String[]{"v1", "v2", "v3", "v4", "v5"});
        try {
            Object[] objectArray;
            RedisFuture<KeyValue<String, List<String>>> rf = this.blmpop(0L, 3, key);
            KeyValue response = (KeyValue)rf.get(10L, TimeUnit.SECONDS);
            List<String> expected = this.right ? List.of("v1", "v2", "v3") : List.of("v5", "v4", "v3");
            Assertions.assertThat((String)((String)response.getKey())).isEqualTo(key);
            Assertions.assertThat((List)((List)response.getValue())).containsExactlyElementsOf(expected);
            if (this.right) {
                Object[] objectArray2 = new String[2];
                objectArray2[0] = "v5";
                objectArray = objectArray2;
                objectArray2[1] = "v4";
            } else {
                String[] stringArray = new String[2];
                stringArray[0] = "v2";
                objectArray = stringArray;
                stringArray[1] = "v1";
            }
            Object[] remaining = objectArray;
            Assertions.assertThat((List)redis.lrange((Object)key, 0L, -1L)).containsExactly(remaining);
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitBLMPOP() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        String key = "key-blmpop-split";
        try {
            RedisFuture<KeyValue<String, List<String>>> rf = this.blmpop(0L, 3, key);
            redis.lpush((Object)key, (Object[])new String[]{"v1"});
            redis.lpush((Object)key, (Object[])new String[]{"v2"});
            redis.lpush((Object)key, (Object[])new String[]{"v3", "v4", "v5"});
            KeyValue response = (KeyValue)rf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)response.getKey())).isEqualTo(key);
            Assertions.assertThat((List)((List)response.getValue())).containsExactly((Object[])new String[]{"v1"});
            Assertions.assertThat((List)redis.lrange((Object)key, 0L, -1L)).containsExactly((Object[])new String[]{"v5", "v4", "v3", "v2"});
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSplitAndSpreadBLMPOP() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        String key1 = "key-blmpop-split-1";
        String key2 = "key-blmpop-split-2";
        try {
            RedisFuture<KeyValue<String, List<String>>> rf = this.blmpop(0L, 3, key1, key2);
            redis.lpush((Object)key1, (Object[])new String[]{"v1-1", "v2-1"});
            redis.lpush((Object)key2, (Object[])new String[]{"v1-2", "v2-2", "v3-2"});
            KeyValue response = (KeyValue)rf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)response.getKey())).isEqualTo(key1);
            Assertions.assertThat((List)((List)response.getValue())).containsExactlyInAnyOrder((Object[])new String[]{"v2-1", "v1-1"});
            Assertions.assertThat((List)redis.lrange((Object)key1, 0L, -1L)).isEmpty();
            Assertions.assertThat((List)redis.lrange((Object)key2, 0L, -1L)).containsExactly((Object[])new String[]{"v3-2", "v2-2", "v1-2"});
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTwoListenersBLMPOP() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        String key = "key-blmpop-two";
        try {
            String[] stringArray;
            String[] stringArray2;
            RedisFuture<KeyValue<String, List<String>>> rf1 = this.blmpop(0L, 2, key);
            RedisFuture<KeyValue<String, List<String>>> rf2 = this.blmpop(0L, 2, key);
            redis.lpush((Object)key, (Object[])new String[]{"v1", "v2", "v3", "v4", "v5"});
            KeyValue res1 = (KeyValue)rf1.get(10L, TimeUnit.SECONDS);
            KeyValue res2 = (KeyValue)rf2.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((String)((String)res1.getKey())).isEqualTo(key);
            Assertions.assertThat((String)((String)res2.getKey())).isEqualTo(key);
            if (this.right) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "v1";
                stringArray2 = stringArray3;
                stringArray3[1] = "v2";
            } else {
                String[] stringArray4 = new String[2];
                stringArray4[0] = "v5";
                stringArray2 = stringArray4;
                stringArray4[1] = "v4";
            }
            String[] exp1 = stringArray2;
            if (this.right) {
                String[] stringArray5 = new String[2];
                stringArray5[0] = "v3";
                stringArray = stringArray5;
                stringArray5[1] = "v4";
            } else {
                String[] stringArray6 = new String[2];
                stringArray6[0] = "v3";
                stringArray = stringArray6;
                stringArray6[1] = "v2";
            }
            String[] exp2 = stringArray;
            ((ListAssert)Assertions.assertThat((List)((List)res1.getValue())).hasSize(2)).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).containsExactlyInAnyOrder((Object[])exp1), l -> Assertions.assertThat((List)l).containsExactlyInAnyOrder((Object[])exp2)});
            ((ListAssert)Assertions.assertThat((List)((List)res2.getValue())).hasSize(2)).satisfiesAnyOf(new ThrowingConsumer[]{l -> Assertions.assertThat((List)l).containsExactlyInAnyOrder((Object[])exp1), l -> Assertions.assertThat((List)l).containsExactlyInAnyOrder((Object[])exp2)});
            Assertions.assertThat((List)((List)res1.getValue())).doesNotContainAnyElementsOf((Iterable)res2.getValue());
            Assertions.assertThat((List)redis.lrange((Object)key, 0L, -1L)).containsExactly((Object[])new String[]{this.right ? "v5" : "v1"});
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBLMPOPListenerTimeout() throws Exception {
        try (StatefulRedisConnection<String, String> conn = this.newConnection();){
            LMPopArgs args = LMPopArgs.Builder.left().count(3L);
            RedisFuture rf = this.registerListener(() -> conn.async().blmpop(1L, args, (Object[])new String[]{"whatever"}));
            KeyValue response = (KeyValue)rf.get(3L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)response).isNull();
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBLMPOPTimeoutWhenNotAList() throws Exception {
        RedisCommands redis = this.redisConnection.sync();
        String key = "key-blmpop-string";
        try {
            RedisFuture<KeyValue<String, List<String>>> rf = this.blmpop(3L, 1, key);
            redis.set((Object)key, (Object)"some-value");
            KeyValue response = (KeyValue)rf.get(10L, TimeUnit.SECONDS);
            Assertions.assertThat((Object)response).isNull();
        }
        finally {
            this.verifyListenerUnregistered();
        }
    }

    public void testBLMPOPWhenKeyNotAList() throws Exception {
        String key = "blmpop-string";
        RedisCommands redis = this.redisConnection.sync();
        RespTestingUtil.assertWrongType(() -> redis.set((Object)key, (Object)"something"), () -> redis.blmpop(0L, LMPopArgs.Builder.left().count(1L), (Object[])new String[]{key}));
    }

    @Listener(clustered=true)
    public static class FailingListener {
        AbstractBlockingPop.PubSubListener blpop;

        public FailingListener(AbstractBlockingPop.PubSubListener arg) {
            this.blpop = arg;
        }

        @CacheEntryCreated
        @CacheEntryModified
        public CompletionStage<Void> onEvent(CacheEntryEvent<Object, Object> entryEvent) {
            this.blpop.getFuture().completeExceptionally(new RuntimeException("Injected failure in OnEvent"));
            return CompletableFutures.completedNull();
        }
    }
}

