/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.response;

import java.util.ArrayList;
import java.util.function.BiConsumer;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class LCSResponse {
    public static final BiConsumer<LCSResponse, ResponseWriter> SERIALIZER = (res, writer) -> writer.write(res, LcsResponseSerializer.INSTANCE);
    public ArrayList<long[]> idx;
    public byte[] lcs;
    public int[][] C;
    public int len;

    private static final class LcsResponseSerializer
    implements JavaObjectSerializer<LCSResponse> {
        private static final LcsResponseSerializer INSTANCE = new LcsResponseSerializer();
        private static final byte[] MATCHES = new byte[]{109, 97, 116, 99, 104, 101, 115};
        private static final byte[] LEN = new byte[]{108, 101, 110};

        private LcsResponseSerializer() {
        }

        @Override
        public void accept(LCSResponse res, ResponseWriter writer) {
            if (res.lcs != null) {
                writer.string(res.lcs);
                return;
            }
            if (res.idx == null) {
                writer.integers(res.len);
                return;
            }
            writer.writeNumericPrefix((byte)37, 2L);
            writer.string(MATCHES);
            writer.writeNumericPrefix((byte)42, res.idx.size());
            for (long[] match : res.idx) {
                int size = match.length > 4 ? 3 : 2;
                writer.writeNumericPrefix((byte)42, size);
                writer.writeNumericPrefix((byte)42, 2L);
                writer.integers(match[0]);
                writer.integers(match[1]);
                writer.writeNumericPrefix((byte)42, 2L);
                writer.integers(match[2]);
                writer.integers(match[3]);
                if (match.length <= 4) continue;
                writer.integers(match[4]);
            }
            writer.string(LEN);
            writer.integers(res.len);
        }
    }
}

