/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.serialization.bytebuf;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.serialization.JavaObjectSerializer;
import org.infinispan.server.resp.serialization.NestedResponseSerializer;
import org.infinispan.server.resp.serialization.Resp3Type;
import org.infinispan.server.resp.serialization.RespConstants;
import org.infinispan.server.resp.serialization.ResponseSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;
import org.infinispan.server.resp.serialization.SerializationHint;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufCollectionSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufDoubleSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufMapSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufPrimitiveSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufSerializerRegistry;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufThrowableSerializer;
import org.infinispan.server.resp.serialization.bytebuf.ByteBufferUtils;

public final class ByteBufResponseWriter
implements ResponseWriter {
    private final ByteBufPool alloc;

    public ByteBufResponseWriter(ByteBufPool alloc) {
        this.alloc = alloc;
    }

    @Override
    public void nulls() {
        ByteBufPrimitiveSerializer.NullSerializer.INSTANCE.accept((Object)null, this.alloc);
    }

    @Override
    public void ok() {
        this.simpleString("OK");
    }

    @Override
    public void queued(Object ignore) {
        this.simpleString("QUEUED");
    }

    @Override
    public void simpleString(CharSequence value) {
        this.serialize(value, ByteBufPrimitiveSerializer.SimpleStringSerializer.INSTANCE);
    }

    @Override
    public void string(CharSequence value) {
        this.serialize(value, ByteBufPrimitiveSerializer.BulkStringSerializer2.INSTANCE);
    }

    @Override
    public void string(byte[] value) {
        this.serialize(value, ByteBufPrimitiveSerializer.BulkStringSerializer.INSTANCE);
    }

    @Override
    public void integers(Number value) {
        this.serialize(value, ByteBufPrimitiveSerializer.IntegerSerializer.INSTANCE);
    }

    @Override
    public void doubles(Number value) {
        this.serialize(value, ByteBufDoubleSerializer.INSTANCE);
    }

    @Override
    public void booleans(boolean value) {
        this.serialize(value, ByteBufPrimitiveSerializer.BooleanSerializer.INSTANCE);
    }

    @Override
    public void arrayEmpty() {
        this.write(Collections.emptyList(), (ignore, writer) -> writer.writeNumericPrefix((byte)42, 0L));
    }

    @Override
    public <T> void array(Collection<T> collection, JavaObjectSerializer<T> serializer) {
        this.serialize(collection, ByteBufCollectionSerializer.ArraySerializer.INSTANCE, (o, b) -> serializer.accept(o, b));
    }

    @Override
    public void array(Collection<?> collection, Resp3Type contentType) {
        this.serialize(collection, ByteBufCollectionSerializer.ArraySerializer.INSTANCE, contentType);
    }

    @Override
    public void emptySet() {
        this.write(Collections.emptySet(), (ignore, writer) -> writer.writeNumericPrefix((byte)126, 0L));
    }

    @Override
    public void set(Set<?> set, Resp3Type contentType) {
        this.serialize(set, ByteBufCollectionSerializer.SetSerializer.INSTANCE, contentType);
    }

    @Override
    public void map(Map<?, ?> value) {
        this.serialize(value, ByteBufMapSerializer.INSTANCE);
    }

    @Override
    public void map(Map<?, ?> value, Resp3Type contentType) {
        this.serialize(value, ByteBufMapSerializer.INSTANCE, new SerializationHint.KeyValueHint(contentType, contentType));
    }

    @Override
    public void map(Map<?, ?> value, Resp3Type keyType, Resp3Type valueType) {
        this.serialize(value, ByteBufMapSerializer.INSTANCE, new SerializationHint.KeyValueHint(keyType, valueType));
    }

    @Override
    public void error(CharSequence value) {
        this.serialize(value, ByteBufPrimitiveSerializer.SimpleErrorSerializer.INSTANCE);
    }

    @Override
    public void error(Throwable t) {
        this.serialize(t, ByteBufThrowableSerializer.INSTANCE);
    }

    @Override
    public <T> void write(T object, JavaObjectSerializer<T> serializer) {
        if (object == null) {
            this.nulls();
        } else {
            serializer.accept(object, this);
        }
    }

    @Override
    public <T> void write(JavaObjectSerializer<T> serializer) {
        if (serializer == null) {
            this.nulls();
        } else {
            serializer.accept(null, this);
        }
    }

    @Override
    public void serialize(Object object) {
        ByteBufSerializerRegistry.serialize(object, this.alloc);
    }

    @Override
    public void writeNumericPrefix(byte symbol, long number, int additionalWidth) {
        int decimalWidth = ByteBufferUtils.stringSize(number);
        int size = 1 + decimalWidth + 2 + additionalWidth;
        ByteBuf buffer = this.alloc.acquire(size);
        buffer.writeByte((int)symbol);
        ByteBufferUtils.setIntChars(number, decimalWidth, buffer);
        buffer.writeBytes(RespConstants.CRLF);
    }

    private void serialize(Object object, ResponseSerializer<?, ByteBufPool> candidate) {
        ByteBufSerializerRegistry.serialize(object, this.alloc, candidate);
    }

    private <H extends SerializationHint> void serialize(Object object, NestedResponseSerializer<?, ByteBufPool, H> candidate, H hint) {
        ByteBufSerializerRegistry.serialize(object, this.alloc, candidate, hint);
    }
}

