/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.persistent;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.sync.RedisCommands;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.resp.SingleNodeRespBaseTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="server.resp.persistent.PersistentStringCommandTest")
public class PersistentStringCommandTest
extends SingleNodeRespBaseTest {
    @AfterClass(alwaysRun=true)
    protected void removeData() {
        Util.recursiveFileRemove((String)this.baseFolderName());
    }

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() throws Throwable {
        Util.recursiveFileRemove((String)this.baseFolderName());
        this.destroy();
        super.createBeforeMethod();
    }

    @Override
    protected void amendConfiguration(ConfigurationBuilder builder) {
        String dir = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.baseFolderName() + "/" + this.nodeId()});
        builder.persistence().addSoftIndexFileStore().dataLocation(dir + "/data").indexLocation(dir + "/index");
    }

    public void testSetGetPersistent() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((String)redis.set((Object)"key", (Object)"value")).isEqualTo("OK");
        Assertions.assertThat((String)((String)redis.get((Object)"key"))).isEqualTo("value");
    }

    public void testIteration() {
        RedisCommands redis = this.redisConnection.sync();
        Assertions.assertThat((List)redis.keys((Object)"*")).isEmpty();
        Assertions.assertThat((String)redis.set((Object)"test-key", (Object)"value")).isEqualTo("OK");
        ((ListAssert)Assertions.assertThat((List)redis.keys((Object)"*")).hasSize(1)).containsExactly((Object[])new String[]{"test-key"});
        ((ListAssert)Assertions.assertThat((List)redis.keys((Object)"test-*")).hasSize(1)).containsExactly((Object[])new String[]{"test-key"});
        Assertions.assertThat((List)redis.keys((Object)"other-*")).isEmpty();
    }

    public void testBatchingScan() {
        RedisCommands redis = this.redisConnection.sync();
        HashSet<CallSite> expected = new HashSet<CallSite>();
        for (int i = 0; i < 100; ++i) {
            String k = "prefix-" + i;
            expected.add((CallSite)((Object)k));
            Assertions.assertThat((String)redis.set((Object)k, (Object)"value")).isEqualTo("OK");
        }
        HashSet actual = new HashSet();
        ScanArgs args = ScanArgs.Builder.limit((long)10L).match("prefix-*");
        KeyScanCursor cursor = redis.scan(args);
        while (true) {
            actual.addAll(cursor.getKeys());
            if (cursor.isFinished()) break;
            cursor = redis.scan((ScanCursor)cursor, args);
        }
        ((AbstractCollectionAssert)Assertions.assertThat(actual).hasSize(expected.size())).isEqualTo(expected);
    }

    protected String baseFolderName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String nodeId() {
        return "";
    }
}

