/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.sortedset.internal;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.infinispan.multimap.impl.EmbeddedMultimapSortedSetCache;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.response.ScoredValueSerializer;
import org.infinispan.server.resp.serialization.ResponseWriter;

public abstract class POP
extends RespCommand
implements Resp3Command {
    private static final BiConsumer<Object, ResponseWriter> SERIALIZER = (res, writer) -> {
        if (res instanceof Collection) {
            Collection cast = (Collection)res;
            writer.array(cast, ScoredValueSerializer.INSTANCE);
            return;
        }
        ScoredValue sv = (ScoredValue)res;
        writer.write(sv, ScoredValueSerializer.INSTANCE);
    };
    private final boolean min;

    public POP(boolean min) {
        super(-2, 1, 1, 1);
        this.min = min;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        boolean hasCount;
        long count;
        EmbeddedMultimapSortedSetCache<byte[], byte[]> sortedSetCache;
        byte[] name;
        block4: {
            name = arguments.get(0);
            sortedSetCache = handler.getSortedSeMultimap();
            if (arguments.size() > 1) {
                try {
                    count = ArgumentUtils.toLong(arguments.get(1));
                    hasCount = true;
                    if (count < 0L) {
                        handler.writer().mustBePositive();
                        return handler.myStage();
                    }
                    break block4;
                }
                catch (NumberFormatException e) {
                    handler.writer().mustBePositive();
                    return handler.myStage();
                }
            }
            count = 1L;
            hasCount = false;
        }
        CompletionStage<Object> popElements = sortedSetCache.pop((Object)name, this.min, count).thenApply(r -> {
            if (r.isEmpty() || hasCount) {
                return r;
            }
            return r.iterator().next();
        });
        return handler.stageToReturn(popElements, ctx, SERIALIZER);
    }
}

