/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.cluster;

import org.infinispan.commons.logging.Log;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;

public class SegmentSlotRelation {
    public static final int SLOT_SIZE = 16384;
    private final int segmentCount;
    private final int width;

    public SegmentSlotRelation(int segmentSize) {
        if (!Util.isPow2((int)segmentSize)) {
            throw Log.CONFIG.respCacheSegmentSizePow2(segmentSize);
        }
        this.segmentCount = segmentSize;
        if (segmentSize > 16384) {
            throw new IllegalArgumentException("Number of segments cannot be larger than 16384");
        }
        this.width = 16384 / segmentSize;
    }

    public int hashToSlot(int hash) {
        return hash % 16384;
    }

    public IntSet segmentToSlots(int segment) {
        assert (segment >= 0 && segment < this.segmentCount) : "Not provided a segment value";
        int start = segment * this.width;
        int end = segment * this.width + this.width;
        return IntSets.immutableOffsetIntSet((int)start, (int)end);
    }

    public int slotToSegment(int slot) {
        assert (slot >= 0 && slot < 16384) : "Not provided a slot value";
        return slot / this.width;
    }

    public int slotWidth() {
        return this.width;
    }
}

