/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.list;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.multimap.impl.EmbeddedMultimapListCache;
import org.infinispan.server.resp.AclCategory;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.server.resp.logging.Log;
import org.infinispan.server.resp.serialization.ResponseWriter;

public class LMOVE
extends RespCommand
implements Resp3Command {
    public static final String LEFT = "LEFT";
    public static final String RIGHT = "RIGHT";

    public LMOVE(int arity) {
        super(arity, 1, 2, 1);
    }

    public LMOVE() {
        super(5, 1, 2, 1);
    }

    @Override
    public long aclMask() {
        return AclCategory.WRITE | AclCategory.LIST | AclCategory.SLOW;
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        return this.lmoveAndReturn(handler, ctx, arguments, false);
    }

    protected CompletionStage<RespRequestHandler> lmoveAndReturn(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments, boolean rightLeft) {
        boolean isDestinationLeft;
        boolean isSourceLeft;
        byte[] destination;
        byte[] source = arguments.get(0);
        boolean sameList = Arrays.equals(source, destination = arguments.get(1));
        if (!sameList) {
            Log.SERVER.lmoveConsistencyMessage();
        }
        if (rightLeft) {
            isSourceLeft = false;
            isDestinationLeft = true;
        } else {
            String sourceWhereFrom = new String(arguments.get(2)).toUpperCase();
            String destinationWhereFrom = new String(arguments.get(3)).toUpperCase();
            isSourceLeft = LEFT.equals(sourceWhereFrom);
            isDestinationLeft = LEFT.equals(destinationWhereFrom);
            if (!isSourceLeft && !RIGHT.equals(sourceWhereFrom) || !isDestinationLeft && !RIGHT.equals(destinationWhereFrom)) {
                handler.writer().syntaxError();
                return handler.myStage();
            }
        }
        EmbeddedMultimapListCache<byte[], byte[]> listMultimap = handler.getListMultimap();
        if (sameList) {
            CompletionStage performedCall = isSourceLeft && isDestinationLeft ? listMultimap.index((Object)source, 0L) : (!isSourceLeft && !isDestinationLeft ? listMultimap.index((Object)source, -1L) : listMultimap.rotate((Object)source, isSourceLeft));
            return handler.stageToReturn(performedCall, ctx, ResponseWriter.BULK_STRING_BYTES);
        }
        CompletionStage pollCall = isSourceLeft ? listMultimap.pollFirst((Object)source, 1L) : listMultimap.pollLast((Object)source, 1L);
        CompletionStage cs = pollCall.thenCompose(pollResult -> {
            if (pollResult == null) {
                return CompletableFutures.completedNull();
            }
            byte[] element = (byte[])pollResult.iterator().next();
            CompletionStage offerCall = isDestinationLeft ? listMultimap.offerFirst((Object)destination, (Object)element) : listMultimap.offerLast((Object)destination, (Object)element);
            return offerCall.thenApply(r -> element);
        });
        return handler.stageToReturn(cs, ctx, ResponseWriter.BULK_STRING_BYTES);
    }
}

