/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.list.blocking;

import java.time.Duration;
import java.util.List;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.commands.ArgumentUtils;
import org.infinispan.server.resp.commands.list.blocking.AbstractBlockingPop;
import org.infinispan.server.resp.commands.list.blocking.PopConfiguration;

abstract class SingleBlockingPop
extends AbstractBlockingPop {
    private final boolean head;

    SingleBlockingPop(boolean head, int arity, int firstKeyPos, int lastKeyPos, int steps) {
        super(arity, firstKeyPos, lastKeyPos, steps);
        this.head = head;
    }

    @Override
    PopConfiguration parseArguments(Resp3Handler handler, List<byte[]> arguments) {
        int lastKeyIdx = arguments.size() - 1;
        List<byte[]> filterKeys = arguments.subList(0, lastKeyIdx);
        double argTimeout = ArgumentUtils.toDouble(arguments.get(lastKeyIdx));
        if (argTimeout < 0.0) {
            handler.writer().mustBePositive();
            return null;
        }
        long timeout = (long)(argTimeout * (double)Duration.ofSeconds(1L).toMillis());
        return new PopConfiguration(this.head, 1, timeout, filterKeys);
    }
}

